/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.ldap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import net.morilib.ldap.AttributeFilter;
import net.morilib.ldap.DistinguishedName;

public final class LDAPManager {
    private InitialDirContext dir;

    public LDAPManager(String hostname, String rootdn, String rootpw) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + hostname);
        env.put("java.naming.ldap.version", "3");
        env.put("java.naming.security.principal", rootdn.toString());
        env.put("java.naming.security.credentials", rootpw);
        this.dir = new InitialDirContext(env);
    }

    public LDAPManager(String hostname, DistinguishedName rootdn, String rootpw) throws NamingException {
        this(hostname, rootdn.toString(), rootpw);
    }

    public void add(String dn, Attributes attrs) throws NamingException {
        this.dir.createSubcontext(dn, attrs);
    }

    public List<Map<String, List<String>>> search(String basedn, AttributeFilter filter, int searchScope) throws NamingException {
        SearchControls ctr = new SearchControls();
        ArrayList<Map<String, List<String>>> r = new ArrayList<Map<String, List<String>>>();
        ctr.setSearchScope(searchScope);
        NamingEnumeration<SearchResult> resenum = this.dir.search(basedn, "(" + filter.toString() + ")", ctr);
        while (resenum.hasMore()) {
            SearchResult res = resenum.next();
            NamingEnumeration<? extends Attribute> attrs = res.getAttributes().getAll();
            HashMap e = new HashMap();
            while (attrs.hasMore()) {
                Attribute attr = (Attribute)attrs.nextElement();
                NamingEnumeration<?> venum = attr.getAll();
                ArrayList<String> vl = new ArrayList<String>();
                while (venum.hasMoreElements()) {
                    vl.add((String)venum.nextElement());
                }
                e.put(attr.getID(), vl);
            }
            r.add(e);
        }
        return r;
    }

    public List<Map<String, List<String>>> search(DistinguishedName basedn, AttributeFilter filter, int searchScope) throws NamingException {
        return this.search(basedn.toString(), filter, searchScope);
    }

    public void modify(String dn, ModificationItem[] moditems) throws NamingException {
        this.dir.modifyAttributes(dn.toString(), moditems);
    }

    public void delete(String dn) throws NamingException {
        this.dir.destroySubcontext(dn.toString());
    }
}

