/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.system;

import java.io.Serializable;
import java.util.Arrays;

public final class Version
implements Comparable<Version>,
Serializable {
    public static final Version OF_JAVA = new Version(System.getProperty("java.version"));
    private String verstr;
    private int[] ver;

    public Version(String version) {
        this.verstr = version;
        String[] vers = version.split("[._\\- ]");
        this.ver = new int[vers.length];
        int i = 0;
        while (i < this.ver.length) {
            this.ver[i] = Integer.parseInt(vers[i]);
            ++i;
        }
    }

    public Version(int ... vernum) {
        StringBuilder b = new StringBuilder();
        String dlm = "";
        this.ver = new int[vernum.length];
        System.arraycopy(vernum, 0, this.ver, 0, this.ver.length);
        int i = 0;
        while (i < this.ver.length) {
            b.append(dlm).append(this.ver[i]);
            dlm = ".";
            ++i;
        }
        this.verstr = b.toString();
    }

    public boolean isVersionOf(Version v) {
        if (this.ver.length < v.ver.length) {
            return false;
        }
        int i = 0;
        while (i < v.ver.length) {
            if (this.ver[i] != v.ver[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int[] toIntArray() {
        int[] r = new int[this.ver.length];
        System.arraycopy(this.ver, 0, r, 0, r.length);
        return r;
    }

    public int hashCode() {
        return Arrays.hashCode(this.ver);
    }

    public boolean equals(Object o) {
        if (o instanceof Version) {
            return Arrays.equals(this.ver, ((Version)o).ver);
        }
        return false;
    }

    @Override
    public int compareTo(Version o) {
        int i = 0;
        while (i < this.ver.length && i < o.ver.length) {
            if (this.ver[i] < o.ver[i]) {
                return -1;
            }
            if (this.ver[i] > o.ver[i]) {
                return 1;
            }
            ++i;
        }
        return this.ver.length < o.ver.length ? -1 : (this.ver.length > o.ver.length ? 1 : 0);
    }

    public String toString() {
        return this.verstr;
    }
}

