/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.proposition;

import net.morilib.lang.composite.Traverse;
import net.morilib.lang.proposition.LogicalAnd;
import net.morilib.lang.proposition.LogicalOr;
import net.morilib.lang.proposition.Proposition;

public final class LogicalNot<S extends Proposition<S>>
implements Proposition<S> {
    @Traverse
    Proposition<S> proposition1;

    LogicalNot(Proposition<S> a) {
        this.proposition1 = a;
    }

    public static <S extends Proposition<S>> Proposition<S> newInstance(Proposition<S> proposition) {
        if (proposition instanceof LogicalAnd) {
            return ((LogicalAnd)proposition).negation;
        }
        if (proposition instanceof LogicalOr) {
            return ((LogicalOr)proposition).negation;
        }
        if (proposition instanceof LogicalNot) {
            return ((LogicalNot)proposition).proposition1;
        }
        return new LogicalNot<S>(proposition);
    }

    @Override
    public boolean is(Object ... variables) {
        return !this.proposition1.is(variables);
    }

    @Override
    public boolean is1(Object var1) {
        return !this.proposition1.is(var1);
    }

    @Override
    public boolean is2(Object var1, Object var2) {
        return !this.proposition1.is(var1, var2);
    }

    @Override
    public boolean isEqualTo(Proposition<S> p) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (p instanceof LogicalNot) {
            return this.proposition1.isEqualTo(((LogicalNot)p).proposition1);
        }
        return false;
    }

    @Override
    public boolean implies(Proposition<S> p) {
        if (p == null) {
            throw new NullPointerException();
        }
        return this.proposition1.isIndependent(p);
    }

    @Override
    public boolean isImplied(Proposition<S> p) {
        return LogicalNot.newInstance(p).implies(this.proposition1);
    }

    @Override
    public boolean isIndependent(Proposition<S> p) {
        if (p == null) {
            throw new NullPointerException();
        }
        return this.proposition1.implies(p);
    }

    @Override
    public boolean isFalse() {
        return this.proposition1.isTrue();
    }

    @Override
    public boolean isTrue() {
        return this.proposition1.isFalse();
    }

    public String toString() {
        return "(not " + this.proposition1.toString() + ")";
    }
}

