/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.proposition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.morilib.lang.composite.TraverseCollection;
import net.morilib.lang.proposition.Logical;
import net.morilib.lang.proposition.LogicalNot;
import net.morilib.lang.proposition.LogicalOr;
import net.morilib.lang.proposition.ManyVariableProposition;
import net.morilib.lang.proposition.Proposition;

public final class LogicalAnd<S extends Proposition<S>>
implements Proposition<S> {
    @TraverseCollection(value=ArrayList.class)
    List<Proposition<S>> propositions;
    Proposition<S> negation;

    LogicalAnd(List<Proposition<S>> propositions) {
        this.propositions = propositions;
    }

    LogicalAnd(List<Proposition<S>> propositions, Proposition<S> negation) {
        this.propositions = propositions;
        this.negation = negation;
    }

    public static <S extends Proposition<S>> Proposition<S> newInstance(List<Proposition<S>> propositions) {
        LogicalAnd<S> res = new LogicalAnd<S>(new ArrayList<Proposition<S>>());
        if (propositions == null) {
            throw new NullPointerException();
        }
        if (propositions.isEmpty()) {
            return Logical.getFalse();
        }
        ArrayList q = new ArrayList(propositions.size());
        int i = 0;
        while (i < propositions.size()) {
            q.add(LogicalNot.newInstance(propositions.get(i)));
            ++i;
        }
        res.negation = new LogicalOr(q, res);
        for (Proposition<S> p : propositions) {
            if (p == null) {
                throw new NullPointerException();
            }
            if (p.isTrue()) continue;
            if (p.isFalse()) {
                return p;
            }
            if (p instanceof LogicalAnd) {
                LogicalAnd pp = (LogicalAnd)p;
                for (Proposition<S> e : pp.propositions) {
                    if (res.implies(e)) {
                        res.propositions.clear();
                    }
                    res.propositions.add(e);
                }
                continue;
            }
            if (res.implies(p)) {
                res.propositions.clear();
            }
            res.propositions.add(p);
        }
        return res;
    }

    public static <S extends Proposition<S>> Proposition<S> newInstance(Proposition<?> ... propositions) {
        return LogicalAnd.newInstance(Arrays.asList(propositions));
    }

    @Override
    public boolean is(Object ... variables) {
        for (Proposition<S> p : this.propositions) {
            if (p.is(variables)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean is1(Object var1) {
        for (Proposition<S> p : this.propositions) {
            if (p.is(var1)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean is2(Object var1, Object var2) {
        for (Proposition<S> p : this.propositions) {
            if (p.is(var1, var2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEqualTo(Proposition<S> p) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (p instanceof LogicalAnd) {
            return ManyVariableProposition.isEquivalent(this.propositions, ((LogicalAnd)p).propositions);
        }
        return false;
    }

    @Override
    public boolean implies(Proposition<S> p) {
        if (p == null) {
            throw new NullPointerException();
        }
        for (Proposition<S> e : this.propositions) {
            if (e.implies(p)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isImplied(Proposition<S> p) {
        if (p == null) {
            throw new NullPointerException();
        }
        return this.isIndependent(LogicalNot.newInstance(p));
    }

    @Override
    public boolean isIndependent(Proposition<S> p) {
        if (p == null) {
            throw new NullPointerException();
        }
        return this.negation.implies(p);
    }

    @Override
    public boolean isFalse() {
        return false;
    }

    @Override
    public boolean isTrue() {
        return this.propositions.size() == 0;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String dlm = "";
        buf.append("(");
        for (Proposition<S> e : this.propositions) {
            buf.append(dlm);
            buf.append(e.toString());
            dlm = " and ";
        }
        buf.append(")");
        return buf.toString();
    }
}

