/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.proposition;

import java.util.Iterator;
import java.util.List;
import net.morilib.lang.proposition.Proposition;
import net.morilib.lang.proposition.TrueFalseProposition;

public final class Logical {
    private Logical() {
    }

    public static <S extends Proposition<S>> Proposition<S> getTrue() {
        return TrueFalseProposition.TRUE;
    }

    public static <S extends Proposition<S>> Proposition<S> getFalse() {
        return TrueFalseProposition.FALSE;
    }

    public static boolean isIndependent(Proposition ... propositions) {
        if (propositions.length < 2) {
            return true;
        }
        Proposition p = propositions[0];
        int i = 1;
        while (i < propositions.length) {
            if (!p.isIndependent(propositions[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static <S extends Proposition<S>> boolean isIndependent(List<Proposition<S>> propositions) {
        if (propositions.size() < 2) {
            return true;
        }
        Iterator<Proposition<S>> it = propositions.iterator();
        Proposition<S> p = it.next();
        while (it.hasNext()) {
            if (p.isIndependent(it.next())) continue;
            return false;
        }
        return true;
    }
}

