/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.number.complex;

import java.io.Serializable;
import net.morilib.lang.number.complex.ComplexDouble;

public class RectanglarComplexDouble
extends ComplexDouble
implements Serializable {
    private static final long serialVersionUID = 266450396005644630L;
    public static final RectanglarComplexDouble ONE = new RectanglarComplexDouble(1.0, 0.0);
    public static final RectanglarComplexDouble I = new RectanglarComplexDouble(0.0, 1.0);
    private double real;
    private double imag;

    private RectanglarComplexDouble(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public RectanglarComplexDouble(ComplexDouble z) {
        this.real = z.realPart();
        this.imag = z.imagPart();
    }

    public static ComplexDouble valueOf(double real, double imag) {
        if (real == 0.0 && imag == 0.0) {
            return ZERO;
        }
        if (Double.isInfinite(real) && Double.isInfinite(imag)) {
            return INFINITY;
        }
        if (Double.isNaN(real) || Double.isNaN(imag)) {
            return NaN;
        }
        return new RectanglarComplexDouble(real, imag);
    }

    public static ComplexDouble realValueOf(double real) {
        if (real == 0.0) {
            return ZERO;
        }
        if (Double.isNaN(real)) {
            return NaN;
        }
        return new RectanglarComplexDouble(real, 0.0);
    }

    public static ComplexDouble imagValueOf(double imag) {
        if (imag == 0.0) {
            return ZERO;
        }
        if (Double.isNaN(imag)) {
            return NaN;
        }
        return new RectanglarComplexDouble(0.0, imag);
    }

    @Override
    public ComplexDouble negate() {
        return RectanglarComplexDouble.valueOf(-this.real, -this.imag);
    }

    @Override
    public ComplexDouble subtract(ComplexDouble x) {
        return RectanglarComplexDouble.valueOf(this.real - x.realPart(), this.imag - x.imagPart());
    }

    @Override
    public ComplexDouble add(ComplexDouble x) {
        return RectanglarComplexDouble.valueOf(this.real + x.realPart(), this.imag + x.imagPart());
    }

    @Override
    public ComplexDouble multiply(int n) {
        return RectanglarComplexDouble.valueOf(this.real * (double)n, this.imag * (double)n);
    }

    @Override
    public ComplexDouble multiply(ComplexDouble x) {
        return RectanglarComplexDouble.valueOf(this.real * x.realPart() - this.imag * x.imagPart(), this.real * x.imagPart() + this.imag * x.realPart());
    }

    @Override
    public ComplexDouble power(int n) {
        if (this.isZero()) {
            if (n >= 1) {
                return ZERO;
            }
            throw new ArithmeticException(this.toString());
        }
        if (this.isUnit()) {
            return this;
        }
        if (n == 0) {
            return ONE;
        }
        if (n == 1) {
            return this;
        }
        if (n == -1) {
            return this.invert();
        }
        if (n > 1) {
            ComplexDouble res = this;
            int i = 1;
            while (i < n) {
                res = res.multiply(this);
                ++i;
            }
            return res;
        }
        ComplexDouble res = this.invert();
        int i = 1;
        while (i < n) {
            res = res.divide(this);
            ++i;
        }
        return res;
    }

    @Override
    public ComplexDouble invert() {
        double c = this.real;
        double d = this.imag;
        double n = c * c + d * d;
        return RectanglarComplexDouble.valueOf(c / n, -d / n);
    }

    @Override
    public ComplexDouble divide(ComplexDouble x) {
        double a = this.real;
        double b = this.imag;
        double c = x.realPart();
        double d = x.imagPart();
        double n = c * c + d * d;
        return RectanglarComplexDouble.valueOf((a * c + b * d) / n, (b * c - a * d) / n);
    }

    @Override
    public double realPart() {
        return this.real;
    }

    @Override
    public double imagPart() {
        return this.imag;
    }

    @Override
    public double abs() {
        return Math.sqrt(this.real * this.real + this.imag * this.imag);
    }

    @Override
    public double angle() {
        return Math.atan2(this.imag, this.real);
    }

    @Override
    public ComplexDouble rotate(double rad) {
        double n = this.abs();
        return RectanglarComplexDouble.valueOf(n * Math.cos(this.angle() + rad), n * Math.sin(this.angle() + rad));
    }

    @Override
    public ComplexDouble multiply(double x) {
        if (x == 0.0) {
            return ZERO;
        }
        return RectanglarComplexDouble.valueOf(this.real * x, this.imag * x);
    }

    @Override
    public ComplexDouble divide(double x) {
        if (x == 0.0) {
            return INFINITY;
        }
        return RectanglarComplexDouble.valueOf(this.real / x, this.imag / x);
    }

    @Override
    public ComplexDouble add(double x) {
        return RectanglarComplexDouble.valueOf(this.real + x, this.imag);
    }

    @Override
    public ComplexDouble subtract(double x) {
        return RectanglarComplexDouble.valueOf(this.real - x, this.imag);
    }

    @Override
    public boolean isNaN() {
        return false;
    }

    @Override
    public boolean isInfinity() {
        return false;
    }
}

