/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.number;

import java.io.Serializable;
import java.math.BigInteger;
import net.morilib.lang.algebra.QuotientAndRemainder;
import net.morilib.lang.number.Integer2;

public final class BigInt
extends Integer2
implements Serializable {
    private static final long serialVersionUID = 3591491043374883031L;
    private BigInteger value;

    BigInt(BigInteger value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.value = value;
    }

    @Override
    public Integer2 add(Integer2 x) {
        return Integer2.valueOf(this.value.add(x.toBigInteger()));
    }

    @Override
    public Integer2 divide(Integer2 x) {
        return Integer2.valueOf(this.value.divide(x.toBigInteger()));
    }

    @Override
    public Integer2 multiply(Integer2 x) {
        return Integer2.valueOf(this.value.multiply(x.toBigInteger()));
    }

    @Override
    public Integer2 subtract(Integer2 x) {
        return Integer2.valueOf(this.value.subtract(x.toBigInteger()));
    }

    @Override
    public Integer2 negate() {
        return new BigInt(this.value.negate());
    }

    public boolean isEqualTo(Integer2 x) {
        return this.value.equals(x.toBigInteger());
    }

    @Override
    public int signum() {
        return this.value.signum();
    }

    public String print() {
        return this.value.toString();
    }

    public String getResult() {
        return this.value.toString();
    }

    @Override
    public BigInteger toBigInteger() {
        return this.value;
    }

    @Override
    public int toInt() {
        return this.value.intValue();
    }

    @Override
    public long toLong() {
        return this.value.longValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public Integer2 remainder(Integer2 x) {
        return Integer2.valueOf(this.value.remainder(x.toBigInteger()));
    }

    @Override
    public QuotientAndRemainder<Integer2> divideAndRemainder(Integer2 x) {
        BigInteger[] dr = this.value.divideAndRemainder(x.toBigInteger());
        return new QuotientAndRemainder<Integer2>(Integer2.valueOf(dr[0]), Integer2.valueOf(dr[1]));
    }

    @Override
    public boolean isZero() {
        return this.value.equals(BigInteger.ZERO);
    }

    @Override
    public Integer2 multiply(int n) {
        return Integer2.valueOf(this.value.multiply(BigInteger.valueOf(n)));
    }

    @Override
    public Integer2 power(int n) {
        return Integer2.valueOf(this.value.pow(n));
    }

    @Override
    public int compareTo(Integer2 o) {
        return this.value.compareTo(o.toBigInteger());
    }

    @Override
    public boolean isUnit() {
        return this.value.equals(BigInteger.ONE);
    }

    public boolean equals(Object x) {
        if (x instanceof BigInt) {
            return this.value.equals(((BigInt)x).value);
        }
        return false;
    }

    public int hashCode() {
        int l = 17;
        l = 37 * l + this.value.hashCode();
        return l;
    }

    public String toString() {
        return this.value.toString();
    }
}

