/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.bean;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.morilib.lang.bean.BeanException;
import net.morilib.lang.bean.BeanInfo2;
import net.morilib.lang.bean.BeanProperty;
import net.morilib.lang.bean.FieldProperty;
import net.morilib.lang.bean.Property;

final class StaticBeanInfo<T>
extends BeanInfo2<T> {
    private Class<?> klass;

    StaticBeanInfo(Class<T> t) {
        this.klass = t;
    }

    public static <T> StaticBeanInfo<T> newBean(T t) {
        return new StaticBeanInfo(t.getClass());
    }

    @Override
    public Property getPropertyOrField(String name) {
        try {
            return new FieldProperty(this.klass.getField(name));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            try {
                return new FieldProperty(this.klass.getDeclaredField(name));
            }
            catch (NoSuchFieldException noSuchFieldException2) {
                try {
                    return new BeanProperty(new PropertyDescriptor(name, this.klass));
                }
                catch (IntrospectionException e2) {
                    throw new BeanException(e2);
                }
            }
        }
    }

    @Override
    public Property[] getPropertiesAndFields() {
        Field f;
        Field[] fs;
        ArrayList<Property> res = new ArrayList<Property>();
        Field[] fieldArray = fs = this.klass.getFields();
        int n = fs.length;
        int n2 = 0;
        while (n2 < n) {
            f = fieldArray[n2];
            if (!res.contains(f)) {
                res.add(new FieldProperty(f));
            }
            ++n2;
        }
        fieldArray = fs = this.klass.getDeclaredFields();
        n = fs.length;
        n2 = 0;
        while (n2 < n) {
            f = fieldArray[n2];
            if (!res.contains(f)) {
                res.add(new FieldProperty(f));
            }
            ++n2;
        }
        try {
            BeanInfo bi = Introspector.getBeanInfo(this.klass);
            PropertyDescriptor[] propertyDescriptorArray = bi.getPropertyDescriptors();
            int n3 = propertyDescriptorArray.length;
            n = 0;
            while (n < n3) {
                PropertyDescriptor f2 = propertyDescriptorArray[n];
                if (!res.contains(f2)) {
                    res.add(new BeanProperty(f2));
                }
                ++n;
            }
        }
        catch (IntrospectionException e2) {
            throw new BeanException(e2);
        }
        return res.toArray(new Property[0]);
    }

    @Override
    public Property getProperty(String name) {
        try {
            return new BeanProperty(new PropertyDescriptor(name, this.klass));
        }
        catch (IntrospectionException e2) {
            throw new BeanException(e2);
        }
    }

    @Override
    public Property[] getProperties() {
        ArrayList<BeanProperty> res = new ArrayList<BeanProperty>();
        try {
            BeanInfo bi = Introspector.getBeanInfo(this.klass);
            PropertyDescriptor[] propertyDescriptorArray = bi.getPropertyDescriptors();
            int n = propertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor f = propertyDescriptorArray[n2];
                if (!res.contains(f)) {
                    res.add(new BeanProperty(f));
                }
                ++n2;
            }
        }
        catch (IntrospectionException e2) {
            throw new BeanException(e2);
        }
        return res.toArray(new Property[0]);
    }

    @Override
    public T newInstance(Object ... args) {
        if (args == null) {
            throw new NullPointerException();
        }
        try {
            Class[] clss = new Class[args.length];
            int i = 0;
            while (i < args.length) {
                clss[i] = args[i].getClass();
                ++i;
            }
            Constructor<?> c = this.klass.getConstructor(clss);
            return (T)c.newInstance(args);
        }
        catch (NoSuchMethodException e) {
            throw new BeanException(e);
        }
        catch (IllegalArgumentException e) {
            throw new BeanException(e);
        }
        catch (InstantiationException e) {
            throw new BeanException(e);
        }
        catch (IllegalAccessException e) {
            throw new BeanException(e);
        }
        catch (InvocationTargetException e) {
            throw new BeanException(e);
        }
    }

    @Override
    public T forceNewInstance(Object ... args) {
        if (args == null) {
            throw new NullPointerException();
        }
        try {
            Class[] clss = new Class[args.length];
            int i = 0;
            while (i < args.length) {
                clss[i] = args[i].getClass();
                ++i;
            }
            Constructor<?> c = this.klass.getDeclaredConstructor(clss);
            c.setAccessible(true);
            return (T)c.newInstance(args);
        }
        catch (NoSuchMethodException e) {
            throw new BeanException(e);
        }
        catch (IllegalArgumentException e) {
            throw new BeanException(e);
        }
        catch (InstantiationException e) {
            throw new BeanException(e);
        }
        catch (IllegalAccessException e) {
            throw new BeanException(e);
        }
        catch (InvocationTargetException e) {
            throw new BeanException(e);
        }
    }
}

