/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import net.morilib.lang.BCDDecimal;
import net.morilib.lang.BCDInteger;
import net.morilib.lang.BCDNaturalNumber;
import net.morilib.lang.Decimal64;

public final class Decimal32
extends Number
implements Comparable<Decimal32>,
Serializable {
    private static final int SGNMASK = Integer.MIN_VALUE;
    private static final int SIGMASK = 0x3F00000;
    private static final int EXPBIT = 20;
    private static final int CMBMASK = 0x7C000000;
    private static final int CMBBIT = 26;
    private static final int FRCSIZE = 6;
    private static final int EXPSIZE = 6;
    private static final int BIAS = 95;
    private static final int TBIT = 0x60000000;
    public static int MAX_EXPONENT = 96;
    public static int MIN_NORMALIZED_EXPONENT = -95;
    public static int MIN_EXPONENT = -101;
    public static int ZERO_BY_INT = 0;
    public static int MINUS_ZERO_BY_INT = Integer.MIN_VALUE;
    public static int POSITIVE_INFINITY_BY_INT = 0x78000000;
    public static int NEGATIVE_INFINITY_BY_INT = -134217728;
    public static int NaN_BY_INT = 0x7C000000;
    private int value;

    public Decimal32(int value) {
        this.value = value;
    }

    public static int getExponentField(int x) {
        int e = (x & 0x3F00000) >> 20;
        int c = (x & 0x7C000000) >> 26;
        if (c < 24) {
            return e | (c & 0x18) << 3;
        }
        return e | (c & 6) << 5;
    }

    public static int getCombinationField(int x) {
        return (x & 0x7C000000) >> 26;
    }

    public static BCDDecimal getFractionField(long x) {
        byte[] b = new byte[7];
        int c = (int)((x & 0x7C000000L) >> 26);
        Decimal64.writedpd((int)(x & 0x3FFL), b, 0);
        Decimal64.writedpd((int)(x >> 10 & 0x3FFL), b, 3);
        b[6] = (x & 0x60000000L) == 0x60000000L ? (byte)(8 | c & 1) : (byte)(c & 7);
        return new BCDDecimal(new BCDInteger(1, new BCDNaturalNumber(b)), 6);
    }

    public static boolean isZero(int x) {
        return (x & Integer.MAX_VALUE) == 0;
    }

    public static boolean isInfinite(int x) {
        return Decimal32.getCombinationField(x) == 30;
    }

    public static boolean isNaN(int x) {
        return Decimal32.getCombinationField(x) == 31;
    }

    static boolean isNormalized(int x) {
        return (x & 0x7C000000) != 0;
    }

    public static int getSignum(int x) {
        return Decimal32.isZero(x) ? 0 : ((x & Integer.MIN_VALUE) == 0 ? 1 : -1);
    }

    public static int getSignumExact(int x) {
        return (x & Integer.MIN_VALUE) == 0 ? 1 : -1;
    }

    public static int getExponent(int x) {
        int e = Decimal32.getExponentField(x);
        if (Decimal32.isZero(x)) {
            return Integer.MIN_VALUE;
        }
        if (Decimal32.isNaN(x)) {
            return Integer.MAX_VALUE;
        }
        if (Decimal32.isInfinite(x)) {
            return 0x7FFFFFFE;
        }
        if (e > 0) {
            return e - 95;
        }
        return MIN_NORMALIZED_EXPONENT + Decimal32.getFractionField(x).getMostSignificantDigit();
    }

    static int encodeDecimal(BCDDecimal d, int p) {
        int r = 0;
        r |= (int)Decimal64.encodedec1(d, p - 6);
        r |= (int)Decimal64.encodedec1(d, p - 3) << 10;
        if (d.getDigit(p) < 8) {
            r |= d.getDigit(p) << 26;
            r |= (p + 95 & 0x3F) << 20;
            r |= (p + 95 & 0xC0) << 23;
        } else {
            r |= (d.getDigit(p) & 1) << 26;
            r |= 0x60000000;
            r |= (p + 95 & 0x3F) << 20;
            r |= (p + 95 & 0xC0) << 21;
        }
        return r;
    }

    public static int toDecimal(BCDDecimal dd) {
        int r;
        int md = dd.getMostSignificantDigit();
        if (dd.isZero()) {
            return ZERO_BY_INT;
        }
        if (md < MIN_EXPONENT) {
            r = ZERO_BY_INT;
        } else if (md < MIN_NORMALIZED_EXPONENT) {
            dd = dd.round(-MIN_EXPONENT);
            r = Decimal32.encodeDecimal(dd, MIN_NORMALIZED_EXPONENT);
        } else if (md <= MAX_EXPONENT) {
            dd = dd.round(-(md - 6));
            r = Decimal32.encodeDecimal(dd, md);
        } else {
            r = POSITIVE_INFINITY_BY_INT;
        }
        if (dd.signum() < 0) {
            r |= Integer.MIN_VALUE;
        }
        return r;
    }

    public static int parseDecimal(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        if (s.equalsIgnoreCase("NaN")) {
            return NaN_BY_INT;
        }
        if (s.equalsIgnoreCase("Infinity")) {
            return POSITIVE_INFINITY_BY_INT;
        }
        if (s.equalsIgnoreCase("+Infinity")) {
            return POSITIVE_INFINITY_BY_INT;
        }
        if (s.equalsIgnoreCase("-Infinity")) {
            return NEGATIVE_INFINITY_BY_INT;
        }
        return Decimal32.toDecimal(BCDDecimal.parseBCD(s));
    }

    public static BCDDecimal toBCDDecimal(int d) {
        BCDDecimal f = Decimal32.getFractionField(d);
        int e = Decimal32.getExponentField(d) - 95;
        if (Decimal32.getSignum(d) < 0) {
            f = f.negate();
        }
        if (Decimal32.isNaN(d) || Decimal32.isInfinite(d)) {
            return null;
        }
        if (e < MIN_NORMALIZED_EXPONENT) {
            return f.shift(MIN_NORMALIZED_EXPONENT);
        }
        return f.shift(e);
    }

    public static int toDecimal(double x) {
        if (Double.isNaN(x)) {
            return NaN_BY_INT;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY_BY_INT;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY_BY_INT;
        }
        if (Double.doubleToLongBits(x) == 0L) {
            return ZERO_BY_INT;
        }
        if (Double.doubleToLongBits(x) == Integer.MIN_VALUE) {
            return MINUS_ZERO_BY_INT;
        }
        return Decimal32.parseDecimal(Double.toString(x));
    }

    public static int add(int a, int b) {
        if (Decimal32.isNaN(a) || Decimal32.isNaN(b)) {
            return NaN_BY_INT;
        }
        if (Decimal32.isInfinite(a)) {
            if (Decimal32.isInfinite(b)) {
                return Decimal32.getSignum(a) * Decimal32.getSignum(b) > 0 ? a : NaN_BY_INT;
            }
            return a;
        }
        if (Decimal32.isInfinite(b)) {
            return b;
        }
        return Decimal32.toDecimal(Decimal32.toBCDDecimal(a).add(Decimal32.toBCDDecimal(b)));
    }

    public static int subtract(int a, int b) {
        if (Decimal32.isNaN(a) || Decimal32.isNaN(b)) {
            return NaN_BY_INT;
        }
        if (Decimal32.isInfinite(a)) {
            if (Decimal32.isInfinite(b)) {
                return Decimal32.getSignum(a) * Decimal32.getSignum(b) < 0 ? a : NaN_BY_INT;
            }
            return a;
        }
        if (Decimal32.isInfinite(b)) {
            return b ^ Integer.MIN_VALUE;
        }
        return Decimal32.toDecimal(Decimal32.toBCDDecimal(a).subtract(Decimal32.toBCDDecimal(b)));
    }

    public static int multiply(int a, int b) {
        if (Decimal32.isNaN(a) || Decimal32.isNaN(b)) {
            return NaN_BY_INT;
        }
        if (Decimal32.isInfinite(a) || Decimal32.isInfinite(b)) {
            switch (Decimal32.getSignum(a) * Decimal32.getSignum(b)) {
                case 1: {
                    return POSITIVE_INFINITY_BY_INT;
                }
                case 0: {
                    return ZERO_BY_INT;
                }
                case -1: {
                    return NEGATIVE_INFINITY_BY_INT;
                }
            }
            throw new RuntimeException();
        }
        return Decimal32.toDecimal(Decimal32.toBCDDecimal(a).multiply(Decimal32.toBCDDecimal(b)));
    }

    public static int divide(int a, int b) {
        if (Decimal32.isNaN(a) || Decimal32.isNaN(b)) {
            return NaN_BY_INT;
        }
        if (Decimal32.isZero(b)) {
            if (Decimal32.isZero(a)) {
                return NaN_BY_INT;
            }
            if (Decimal32.getSignumExact(a) * Decimal32.getSignumExact(b) > 0) {
                return POSITIVE_INFINITY_BY_INT;
            }
            return NEGATIVE_INFINITY_BY_INT;
        }
        if (Decimal32.isInfinite(a)) {
            if (Decimal32.isInfinite(b)) {
                return NaN_BY_INT;
            }
            if (Decimal32.getSignumExact(a) * Decimal32.getSignumExact(b) > 0) {
                return ZERO_BY_INT;
            }
            return MINUS_ZERO_BY_INT;
        }
        if (Decimal32.isInfinite(b)) {
            if (Decimal32.getSignumExact(a) * Decimal32.getSignumExact(b) > 0) {
                return ZERO_BY_INT;
            }
            return MINUS_ZERO_BY_INT;
        }
        BCDDecimal da = Decimal32.toBCDDecimal(a).shiftExtend(8);
        BCDDecimal db = Decimal32.toBCDDecimal(b);
        BCDDecimal dc = da.divide(db);
        return Decimal32.toDecimal(dc);
    }

    public static int negate(int l) {
        return l ^ Integer.MIN_VALUE;
    }

    public static int toDecimal(long l) {
        return Decimal32.toDecimal(BCDDecimal.valueOf(l, 0));
    }

    public static BigDecimal toBigDecimal(int l) {
        if (Decimal32.isNaN(l) || Decimal32.isInfinite(l)) {
            throw new IllegalArgumentException();
        }
        if (Decimal32.isZero(l)) {
            return BigDecimal.ZERO;
        }
        if (Decimal32.isNormalized(l)) {
            int e = Decimal32.getExponent(l);
            BigDecimal d = Decimal32.getFractionField(l).toBigDecimal();
            return d.setScale(e + 6, RoundingMode.HALF_EVEN);
        }
        BigDecimal d = Decimal32.getFractionField(l).toBigDecimal();
        return d.setScale(-MIN_EXPONENT, RoundingMode.HALF_EVEN);
    }

    public static int round(int l, int digit) {
        BCDDecimal d;
        int e = Decimal32.getExponent(l);
        if (Decimal32.isNaN(l) || Decimal32.isInfinite(l) || Decimal32.isZero(l)) {
            return l;
        }
        if (-digit > e + 1) {
            return ZERO_BY_INT;
        }
        if (-digit == e + 1) {
            d = Decimal32.getFractionField(l);
            if (d.getDigit(0) < 5) {
                return ZERO_BY_INT;
            }
            d = BCDDecimal.parseBCD("1.000000").shift(-digit);
        } else if (Decimal32.isNormalized(l)) {
            d = Decimal32.getFractionField(l);
            if (-digit < e - 6) {
                return l;
            }
            d = d.round(digit + e).shift(e);
        } else {
            d = Decimal32.getFractionField(l);
            if (-digit < MIN_EXPONENT) {
                return l;
            }
            d = d.round(digit + MIN_NORMALIZED_EXPONENT).shift(e + 1);
        }
        return Decimal32.toDecimal(Decimal32.getSignum(l) > 0 ? d : d.negate());
    }

    public static int ceil(int l, int digit) {
        BCDDecimal d;
        int e = Decimal32.getExponent(l);
        if (Decimal32.isNaN(l) || Decimal32.isInfinite(l) || Decimal32.isZero(l)) {
            return l;
        }
        if (-digit >= e + 1) {
            BCDDecimal d2 = Decimal32.getFractionField(l);
            if (Decimal32.getSignum(l) > 0) {
                d2 = BCDDecimal.parseBCD("1.000000").shift(-digit);
                return Decimal32.toDecimal(d2);
            }
            return ZERO_BY_INT;
        }
        if (Decimal32.isNormalized(l)) {
            d = Decimal32.getFractionField(l);
            BCDDecimal bCDDecimal = d = Decimal32.getSignum(l) > 0 ? d : d.negate();
            if (-digit < e - 6) {
                return l;
            }
            d = d.ceil(digit + e).shift(e);
        } else {
            d = Decimal32.getFractionField(l);
            BCDDecimal bCDDecimal = d = Decimal32.getSignum(l) > 0 ? d : d.negate();
            if (-digit < MIN_EXPONENT) {
                return l;
            }
            d = d.ceil(digit + MIN_NORMALIZED_EXPONENT).shift(e + 1);
        }
        return Decimal32.toDecimal(d);
    }

    public static int floor(int l, int digit) {
        BCDDecimal d;
        int e = Decimal32.getExponent(l);
        if (Decimal32.isNaN(l) || Decimal32.isInfinite(l) || Decimal32.isZero(l)) {
            return l;
        }
        if (-digit >= e + 1) {
            BCDDecimal d2 = Decimal32.getFractionField(l);
            if (Decimal32.getSignum(l) > 0) {
                return ZERO_BY_INT;
            }
            d2 = BCDDecimal.parseBCD("-1.000000").shift(-digit);
            return Decimal32.toDecimal(d2);
        }
        if (Decimal32.isNormalized(l)) {
            d = Decimal32.getFractionField(l);
            BCDDecimal bCDDecimal = d = Decimal32.getSignum(l) > 0 ? d : d.negate();
            if (-digit < e - 6) {
                return l;
            }
            d = d.floor(digit + e).shift(e);
        } else {
            d = Decimal32.getFractionField(l);
            BCDDecimal bCDDecimal = d = Decimal32.getSignum(l) > 0 ? d : d.negate();
            if (-digit < MIN_EXPONENT) {
                return l;
            }
            d = d.floor(digit + MIN_NORMALIZED_EXPONENT).shift(e + 1);
        }
        return Decimal32.toDecimal(d);
    }

    public static String toString(int value) {
        if (Decimal32.isNaN(value)) {
            return "NaN";
        }
        if (Decimal32.isInfinite(value)) {
            return Decimal32.getSignum(value) > 0 ? "Infinity" : "-Infinity";
        }
        if (Decimal32.isZero(value)) {
            return Decimal32.getSignum(value) > 0 ? "0.0" : "-0.0";
        }
        BCDDecimal f = Decimal32.getFractionField(value);
        int e = Decimal32.getExponent(value);
        return f.shift(e).toString().replaceFirst("0+((e(\\+|-)?[0-9]+)?)$", "$1");
    }

    public static String toString(int value, int precision) {
        if (Decimal32.isNaN(value)) {
            return "NaN";
        }
        if (Decimal32.isInfinite(value)) {
            return Decimal32.getSignum(value) > 0 ? "Infinity" : "-Infinity";
        }
        if (Decimal32.isZero(value)) {
            return Decimal32.getSignum(value) > 0 ? "0.0" : "-0.0";
        }
        BCDDecimal f = Decimal32.getFractionField(value);
        int e = Decimal32.getExponent(value);
        return f.shift(e).toString(precision).replaceFirst("0+((e(\\+|-)?[0-9]+)?)$", "$1");
    }

    public static double doubleValue(int l) {
        if (Decimal32.isNaN(l)) {
            return Double.NaN;
        }
        if (Decimal32.isInfinite(l)) {
            return (double)Decimal32.getSignum(l) * Double.POSITIVE_INFINITY;
        }
        if (Decimal32.isZero(l)) {
            return (double)Decimal32.getSignum(l) * 0.0;
        }
        return Double.parseDouble(Decimal32.toString(l));
    }

    public static float floatValue(int l) {
        if (Decimal32.isNaN(l)) {
            return Float.NaN;
        }
        if (Decimal32.isInfinite(l)) {
            return (float)Decimal32.getSignum(l) * Float.POSITIVE_INFINITY;
        }
        if (Decimal32.isZero(l)) {
            return (float)Decimal32.getSignum(l) * 0.0f;
        }
        return Float.parseFloat(Decimal32.toString(l));
    }

    public static int compare(int a, int b) {
        if (Decimal32.isNaN(a)) {
            return Decimal32.isNaN(b) ? 0 : 1;
        }
        if (Decimal32.isNaN(b)) {
            return -1;
        }
        if (Decimal32.isInfinite(a)) {
            if (Decimal32.getSignum(a) > 0) {
                return Decimal32.isInfinite(b) && Decimal32.getSignum(b) > 0 ? 0 : 1;
            }
            return Decimal32.isInfinite(b) && Decimal32.getSignum(b) < 0 ? 0 : -1;
        }
        if (Decimal32.isInfinite(b)) {
            return Decimal32.getSignum(b) > 0 ? -1 : 1;
        }
        if (Decimal32.isNormalized(a)) {
            if (Decimal32.isNormalized(b)) {
                int eb;
                int ea = Decimal32.getExponent(a);
                if (ea > (eb = Decimal32.getExponent(b))) {
                    return 1;
                }
                if (ea < eb) {
                    return -1;
                }
                BCDDecimal da = Decimal32.getFractionField(a);
                BCDDecimal db = Decimal32.getFractionField(b);
                return da.compareTo(db);
            }
            return 1;
        }
        if (Decimal32.isNormalized(b)) {
            return -1;
        }
        BCDDecimal da = Decimal32.getFractionField(a);
        BCDDecimal db = Decimal32.getFractionField(b);
        return da.compareTo(db);
    }

    public static int decimal64To32(long l) {
        return Decimal32.toDecimal(Decimal64.toBCDDecimal(l));
    }

    public static long toDecimal(BigDecimal b) {
        BCDInteger bi = BCDInteger.valueOf(b.unscaledValue());
        BCDDecimal dd = new BCDDecimal(bi, 0);
        return Decimal32.toDecimal(dd.shift(-b.scale()));
    }

    @Override
    public int compareTo(Decimal32 o) {
        return Decimal32.compare(this.value, o.value);
    }

    @Override
    public int intValue() {
        return Decimal32.toBigDecimal(this.value).intValue();
    }

    @Override
    public long longValue() {
        return Decimal32.toBigDecimal(this.value).longValue();
    }

    @Override
    public float floatValue() {
        return Decimal32.floatValue(this.value);
    }

    @Override
    public double doubleValue() {
        return Decimal32.doubleValue(this.value);
    }
}

