/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.geography;

import net.morilib.arith.NonnegativeDegree;

public class Latitude
extends Number {
    private int PERIOD = 64800000;
    private int MAXSEC = 648000;
    private int HALFPERIOD = 32400000;
    private int HALFSEC = 324000;
    private static NonnegativeDegree PERIOD_DEG = new NonnegativeDegree(180, 0, 0, 0);
    private static NonnegativeDegree EQUATOR = new NonnegativeDegree(90, 0, 0, 0);
    private static NonnegativeDegree MAX_D = new NonnegativeDegree(90, 0, 0, 0);
    private NonnegativeDegree degree;

    Latitude(int x) {
        this.degree = new NonnegativeDegree(x);
    }

    Latitude(NonnegativeDegree degree) {
        this.degree = degree;
    }

    public Latitude(int degree, int minutes, int seconds, int undersec) {
        if (degree < -90 || degree > 90) {
            throw new IllegalArgumentException();
        }
        this.degree = degree > 0 ? new NonnegativeDegree(degree + 90, minutes, seconds, undersec) : (degree < 0 ? EQUATOR.subtract(new NonnegativeDegree(-degree, minutes, seconds, undersec)) : (minutes > 0 ? new NonnegativeDegree(90, minutes, seconds, undersec) : (minutes < 0 ? EQUATOR.subtract(new NonnegativeDegree(0, -minutes, seconds, undersec)) : (seconds > 0 ? new NonnegativeDegree(90, 0, seconds, undersec) : (seconds < 0 ? EQUATOR.subtract(new NonnegativeDegree(0, 0, -seconds, undersec)) : (undersec > 0 ? new NonnegativeDegree(90, 0, 0, undersec) : (undersec < 0 ? EQUATOR.subtract(new NonnegativeDegree(0, 0, 0, -undersec)) : EQUATOR)))))));
    }

    public static Latitude parse(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() == 0) {
            throw new NumberFormatException();
        }
        switch (string.charAt(string.length() - 1)) {
            case 'N': {
                NonnegativeDegree d = NonnegativeDegree.parse(string.substring(0, string.length() - 1));
                if (d.compareTo(MAX_D) > 0) {
                    throw new NumberFormatException();
                }
                return new Latitude(d.add(EQUATOR));
            }
            case 'S': {
                NonnegativeDegree d = NonnegativeDegree.parse(string.substring(0, string.length() - 1));
                if (d.compareTo(MAX_D) > 0) {
                    throw new NumberFormatException();
                }
                return new Latitude(EQUATOR.subtract(d));
            }
        }
        throw new NumberFormatException();
    }

    public Latitude add(Latitude x) {
        return new Latitude(this.degree.add(x.degree).add(MAX_D).remainder(PERIOD_DEG));
    }

    public Latitude subtract(Latitude x) {
        if (this.degree.compareTo(x.degree) >= 0) {
            return new Latitude(this.degree.subtract(x.degree).add(MAX_D));
        }
        return new Latitude(PERIOD_DEG.subtract(x.degree.subtract(this.degree)).add(MAX_D));
    }

    public Latitude multiply(int x) {
        long a = this.degree.toCentiSecond() - this.HALFPERIOD;
        a = (a * (long)x + (long)this.HALFPERIOD) % (long)this.PERIOD;
        return new Latitude(new NonnegativeDegree((int)a));
    }

    public Latitude multiply(double x) {
        double r = (this.degree.doubleValue() - (double)this.HALFSEC) * x + (double)this.HALFSEC;
        r = (r = Math.IEEEremainder(r, this.MAXSEC)) < 0.0 ? (double)this.MAXSEC + r : r;
        return new Latitude(new NonnegativeDegree(r));
    }

    public Latitude divide(int x) {
        long a = ((this.degree.toCentiSecond() - this.HALFPERIOD) / Math.abs(x) + this.HALFPERIOD) % this.PERIOD;
        a = x < 0 ? (long)this.PERIOD - a : a;
        return new Latitude(new NonnegativeDegree((int)a));
    }

    public Latitude divide(double x) {
        double r = (this.degree.doubleValue() - (double)this.HALFSEC) / x + (double)this.HALFSEC;
        r = (r = Math.IEEEremainder(r, this.MAXSEC)) < 0.0 ? (double)this.MAXSEC + r : r;
        return new Latitude(new NonnegativeDegree(r));
    }

    @Override
    public int intValue() {
        return this.degree.intValue();
    }

    @Override
    public long longValue() {
        return this.degree.longValue();
    }

    @Override
    public float floatValue() {
        return this.degree.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.degree.doubleValue();
    }

    public int hashCode() {
        return this.degree.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Latitude) {
            return this.degree.equals(((Latitude)o).degree);
        }
        return false;
    }

    public String toString() {
        if (this.degree.compareTo(EQUATOR) > 0) {
            return String.valueOf(this.degree.subtract(EQUATOR).toString()) + "N";
        }
        if (this.degree.compareTo(EQUATOR) < 0) {
            return String.valueOf(EQUATOR.subtract(this.degree).toString()) + "S";
        }
        return NonnegativeDegree.ZERO.toString();
    }
}

