/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.games;

public final class JapaneseMahjongUtils {
    public static final int UNLIMITED = 2;
    public static final int OYA = 1;

    private JapaneseMahjongUtils() {
    }

    private static int scoreBase(int f, int h, boolean ul) {
        int sc = (f + 9) / 10 * 10;
        if (ul) {
            sc *= 1 << h + 2;
        } else if (h > 12) {
            sc = 8000;
        } else if (h > 10) {
            sc = 6000;
        } else if (h > 7) {
            sc = 4000;
        } else if (h > 5) {
            sc = 3000;
        } else if ((sc *= 1 << h + 2) >= 2000) {
            sc = 2000;
        }
        return sc;
    }

    public static int scoreRong(int fu, int fan, int flags) {
        boolean ul = (flags & 2) != 0;
        int sc = JapaneseMahjongUtils.scoreBase(fu, fan, ul);
        sc *= (flags & 1) == 0 ? 4 : 6;
        sc = (sc + 99) / 100 * 100;
        return sc;
    }

    public static int[] scoreZimo(int fu, int fan, int flags) {
        boolean ul = (flags & 2) != 0;
        int sc = JapaneseMahjongUtils.scoreBase(fu, fan, ul);
        int s2 = sc * 2;
        s2 = (s2 + 99) / 100 * 100;
        int s1 = (sc + 99) / 100 * 100;
        if ((flags & 1) == 0) {
            return new int[]{s2, s1, s1};
        }
        return new int[]{s2, s2, s2};
    }
}

