/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.calendar.cjkv;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.morilib.calendar.cjkv.CJKVEra;
import net.morilib.calendar.cjkv.CJKVGregorianEra;
import net.morilib.calendar.cjkv.CJKVOldEra;

final class MeijiEra
implements CJKVEra {
    private static final SimpleDateFormat FMT = new SimpleDateFormat("yyyy/MM/dd");
    private static final CJKVOldEra OLD_MEIJI;
    private static final CJKVGregorianEra NEW_MEIJI;
    private static final Date CHANGE_GREGORIAN_EPOCH;

    static {
        int[][] nArrayArray = new int[5][];
        nArrayArray[0] = new int[]{4, 4825};
        int[] nArray = new int[2];
        nArray[1] = 728;
        nArrayArray[1] = nArray;
        nArrayArray[2] = new int[]{10, 5801};
        int[] nArray2 = new int[2];
        nArray2[1] = 1700;
        nArrayArray[3] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = 1317;
        nArrayArray[4] = nArray3;
        OLD_MEIJI = new CJKVOldEra("\u660e\u6cbb", "1868/01/25", "1868/01/25", "1872/12/31", (int[][])nArrayArray);
        NEW_MEIJI = new CJKVGregorianEra("\u660e\u6cbb", "M", "1868/01/01", "1868/01/25", "1912/07/30");
        CHANGE_GREGORIAN_EPOCH = MeijiEra._p("1873/01/01");
    }

    MeijiEra() {
    }

    private static Date _p(String ymd) {
        try {
            return ymd == null ? null : FMT.parse(ymd);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Date getEnd() {
        return NEW_MEIJI.getEnd();
    }

    @Override
    public Date getEpoch() {
        return OLD_MEIJI.getEpoch();
    }

    @Override
    public int getLeapMonth(int year) {
        if (year < 1) {
            throw new IllegalArgumentException();
        }
        if (year <= 5) {
            return OLD_MEIJI.getLeapMonth(year);
        }
        return 0;
    }

    @Override
    public Date getNewYearEpoch() {
        return OLD_MEIJI.getNewYearEpoch();
    }

    @Override
    public int getYears() {
        return 45;
    }

    @Override
    public boolean isEra(Date d) {
        return NEW_MEIJI.isEra(d);
    }

    @Override
    public int getMonths(int year) {
        if (year < 1) {
            throw new IllegalArgumentException();
        }
        if (year <= 5) {
            return OLD_MEIJI.getMonths(year);
        }
        return 12;
    }

    @Override
    public int getDaysOfMonth(int year, int month) {
        if (year < 1 || month < 1 || month > 12) {
            throw new IllegalArgumentException();
        }
        if (year == 5 && month == 12) {
            return 2;
        }
        if (year <= 5) {
            return OLD_MEIJI.getDaysOfMonth(year, month);
        }
        return NEW_MEIJI.getDaysOfMonth(year, month);
    }

    @Override
    public int getDaysOfYear(int year) {
        if (year < 1) {
            throw new IllegalArgumentException();
        }
        if (year < 5) {
            return OLD_MEIJI.getDaysOfYear(year);
        }
        if (year == 5) {
            return 332;
        }
        return NEW_MEIJI.getDaysOfYear(year);
    }

    @Override
    public int getDaysFromNewYearEpoch(Date d) {
        if (CHANGE_GREGORIAN_EPOCH.after(d)) {
            return OLD_MEIJI.getDaysFromNewYearEpoch(d);
        }
        return NEW_MEIJI.getDaysFromEpoch(d);
    }

    @Override
    public int getDaysFromEpoch(Date d) {
        return NEW_MEIJI.getDaysFromEpoch(d);
    }

    @Override
    public int getYear(Date d) {
        if (!this.isEra(d)) {
            return -1;
        }
        if (CHANGE_GREGORIAN_EPOCH.after(d)) {
            return OLD_MEIJI.getYear(d);
        }
        return NEW_MEIJI.getYear(d);
    }

    @Override
    public boolean after(Date d) {
        return NEW_MEIJI.after(d);
    }

    @Override
    public boolean before(Date d) {
        return NEW_MEIJI.before(d);
    }

    @Override
    public String getInitialLetter() {
        return "M";
    }

    @Override
    public String getShortDescription() {
        return "\u660e";
    }

    public String toString() {
        return "\u660e\u6cbb";
    }
}

