/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.calendar.cjkv;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.morilib.calendar.cjkv.CJKVEra;
import net.morilib.util.BitUtils;

public class CJKVOldEra
implements CJKVEra {
    private static final SimpleDateFormat FMT = new SimpleDateFormat("yyyy/MM/dd");
    private static final long DAY_IN_MILLS = 86400000L;
    private long newYearEpoch;
    private long epoch;
    private long end;
    private byte[] intercalary;
    private short[] shonotsuki;
    private String desc;

    public CJKVOldEra(String desc, long newYearEpoch, long epoch, long end, int[] ... intercalary) {
        if (newYearEpoch > epoch) {
            throw new IllegalArgumentException();
        }
        if (epoch > end) {
            throw new IllegalArgumentException();
        }
        this.newYearEpoch = newYearEpoch;
        this.epoch = epoch;
        this.end = end;
        this.intercalary = new byte[intercalary.length];
        this.shonotsuki = new short[intercalary.length];
        int i = 0;
        while (i < intercalary.length) {
            this.intercalary[i] = (byte)intercalary[i][0];
            this.shonotsuki[i] = (short)intercalary[i][1];
            ++i;
        }
    }

    public CJKVOldEra(String desc, Date newYearEpoch, Date epoch, Date end, int[] ... intercalary) {
        this(desc, newYearEpoch.getTime(), epoch.getTime(), end.getTime(), intercalary);
    }

    public CJKVOldEra(String desc, String newYearEpoch, String epoch, String end, int[] ... intercalary) {
        this(desc, CJKVOldEra._p(newYearEpoch), CJKVOldEra._p(epoch), CJKVOldEra._p(end), intercalary);
    }

    private static long _p(String ymd) {
        try {
            if (ymd == null) {
                throw new NullPointerException();
            }
            return FMT.parse(ymd).getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Date getNewYearEpoch() {
        return new Date(this.newYearEpoch);
    }

    @Override
    public Date getEpoch() {
        return new Date(this.epoch);
    }

    @Override
    public Date getEnd() {
        return new Date(this.end);
    }

    @Override
    public int getYears() {
        return this.intercalary.length;
    }

    @Override
    public int getMonths(int year) {
        if (year < 1 || year > this.getYears()) {
            throw new IllegalArgumentException();
        }
        return this.intercalary[year - 1] == 0 ? 12 : 13;
    }

    @Override
    public int getDaysOfYear(int year) {
        if (year < 1 || year > this.getYears()) {
            throw new IllegalArgumentException(String.valueOf(year));
        }
        return (this.intercalary[year - 1] == 0 ? 360 : 390) - BitUtils.countBit(this.shonotsuki[year - 1]);
    }

    @Override
    public int getLeapMonth(int year) {
        if (year < 1 || year > this.getYears()) {
            throw new IllegalArgumentException();
        }
        return this.intercalary[year - 1];
    }

    @Override
    public boolean isEra(Date d) {
        return this.epoch <= d.getTime() && this.end >= d.getTime();
    }

    @Override
    public int getDaysOfMonth(int year, int month) {
        if (year < 1 || year > this.getYears() || month < 1 || month > this.getMonths(year)) {
            throw new IllegalArgumentException();
        }
        return (this.shonotsuki[year - 1] & 1 << month - 1) == 0 ? 30 : 29;
    }

    @Override
    public int getYear(Date d) {
        int dy = this.getDaysFromNewYearEpoch(d);
        int i = 0;
        while (dy >= 0) {
            dy -= this.getDaysOfYear(++i);
        }
        return i;
    }

    @Override
    public int getDaysFromNewYearEpoch(Date d) {
        if (this.isEra(d)) {
            return (int)((d.getTime() - this.newYearEpoch) / 86400000L);
        }
        return -1;
    }

    @Override
    public int getDaysFromEpoch(Date d) {
        if (this.isEra(d)) {
            return (int)((d.getTime() - this.epoch) / 86400000L);
        }
        return -1;
    }

    @Override
    public boolean after(Date d) {
        return this.getEpoch().after(d);
    }

    @Override
    public boolean before(Date d) {
        return this.getEnd().before(d);
    }

    @Override
    public String getInitialLetter() {
        return null;
    }

    @Override
    public String getShortDescription() {
        return null;
    }

    public String toString() {
        return this.desc;
    }
}

