/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.calendar;

import net.morilib.calendar.AbstractDay;
import net.morilib.calendar.SimpleGregorianCalendar;

public class MesoamericanLongCountCalendar
extends AbstractDay {
    private static final int TUN_PER_WINALS = 18;
    private static final int KATUN_PER_TUNS = 20;
    private static final int BAKTUN_PER_KATUNS = 20;
    private static final int PERIOD_PER_BAKTUNS = 13;
    private static final int WINAL = 20;
    private static final int TUN = 360;
    private static final int KATUN = 7200;
    private static final int BAKTUN = 144000;
    private static final int PERIOD = 1872000;
    private static final int DAYS_TO_UNIX_EPOCH = 1856304;
    private static final long DAY_MILLISECS = 86400000L;
    private int days;

    public MesoamericanLongCountCalendar(long date) {
        this.days = (int)SimpleGregorianCalendar.div(date, 86400000L) + 1856304;
    }

    public static MesoamericanLongCountCalendar getInstaceFromTime(long time) {
        return new MesoamericanLongCountCalendar(time);
    }

    public MesoamericanLongCountCalendar(int baktun, int katun, int tun, int winal, int kin) {
        if (baktun < 0 || baktun >= 13) {
            throw new IllegalArgumentException(String.valueOf(baktun));
        }
        if (katun < 0 || katun >= 20) {
            throw new IllegalArgumentException(String.valueOf(katun));
        }
        if (tun < 0 || tun >= 20) {
            throw new IllegalArgumentException(String.valueOf(tun));
        }
        if (winal < 0 || winal >= 18) {
            throw new IllegalArgumentException(String.valueOf(winal));
        }
        if (kin < 0 || kin >= 20) {
            throw new IllegalArgumentException(String.valueOf(kin));
        }
        this.days = kin;
        this.days += winal * 20;
        this.days += tun * 360;
        this.days += katun * 7200;
        this.days += baktun * 144000;
    }

    @Override
    public long getDate() {
        return (long)(this.days - 1856304) * 86400000L;
    }

    @Override
    public int getDaysFromEpoch() {
        return this.days;
    }

    public int getKin() {
        return SimpleGregorianCalendar.mod(this.days, 20);
    }

    public int getWinal() {
        return SimpleGregorianCalendar.mod(this.days, 360) / 20;
    }

    public int getTun() {
        return SimpleGregorianCalendar.mod(this.days, 7200) / 360;
    }

    public int getKatun() {
        return SimpleGregorianCalendar.mod(this.days, 144000) / 7200;
    }

    public int getBaktun() {
        return SimpleGregorianCalendar.mod(this.days, 1872000) / 144000;
    }

    @Override
    public MesoamericanLongCountCalendar after(int days) {
        return new MesoamericanLongCountCalendar((long)(this.days + days - 1856304) * 86400000L);
    }

    public String toString() {
        int k = this.days;
        int b = (k %= 1872000) / 144000;
        int a = (k %= 144000) / 7200;
        int t = (k %= 7200) / 360;
        int w = (k %= 360) / 20;
        return String.valueOf(b) + "." + a + "." + t + "." + w + "." + (k %= 20);
    }
}

