/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.calendar;

import net.morilib.calendar.AbstractDay;
import net.morilib.calendar.SimpleGregorianCalendar;
import net.morilib.calendar.SimpleJulianCalendar;
import net.morilib.calendar.WeekSolarCalendar;

public class AnnoDomini
extends AbstractDay
implements WeekSolarCalendar {
    private static final int DAYS_TO_UNIX_EPOCH = 719162;
    private static final int AD010101_JULIAN = 16439;
    private static final long DAY_MILLISECS = 86400000L;
    private static final SimpleGregorianCalendar GREGORIAN_EPOCH = new SimpleGregorianCalendar(1752, 9, 14);
    private static final int GREGORIAN_EPOCH_DAYS = GREGORIAN_EPOCH.getDaysFromEpoch();
    private static final int LAST_JULIAN_DAYS = GREGORIAN_EPOCH_DAYS - 1;
    private static final SimpleJulianCalendar LAST_JULIAN = new SimpleJulianCalendar(LAST_JULIAN_DAYS + 16439);
    private WeekSolarCalendar cal;

    public AnnoDomini(int days) {
        this.cal = days < GREGORIAN_EPOCH_DAYS ? new SimpleJulianCalendar(days + 16439) : new SimpleGregorianCalendar(days);
    }

    public static AnnoDomini getInstaceFromTime(long time) {
        int t = (int)SimpleGregorianCalendar.div(time, 86400000L);
        return new AnnoDomini(t + 719162);
    }

    public AnnoDomini(int year, int month, int day) {
        if (year < GREGORIAN_EPOCH.getYear()) {
            this.cal = new SimpleJulianCalendar(year, month, day);
        } else if (year > GREGORIAN_EPOCH.getYear()) {
            this.cal = new SimpleGregorianCalendar(year, month, day);
        } else if (month < GREGORIAN_EPOCH.getMonth()) {
            this.cal = new SimpleJulianCalendar(year, month, day);
        } else if (month > GREGORIAN_EPOCH.getMonth()) {
            this.cal = new SimpleGregorianCalendar(year, month, day);
        } else if (day <= LAST_JULIAN.getDayOfMonth()) {
            this.cal = new SimpleJulianCalendar(year, month, day);
        } else if (day >= GREGORIAN_EPOCH.getDayOfMonth()) {
            this.cal = new SimpleGregorianCalendar(year, month, day);
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public WeekSolarCalendar after(int days) {
        return new AnnoDomini(this.getDaysFromEpoch() + days);
    }

    @Override
    public int getDayOfWeek() {
        return this.cal.getDayOfWeek();
    }

    @Override
    public int getDayOfMonth() {
        return this.cal.getDayOfMonth();
    }

    @Override
    public int getDayOfYear() {
        return this.cal.getDayOfYear();
    }

    @Override
    public int getMaximumDaysOfMonth() {
        if (this.cal.getYear() == GREGORIAN_EPOCH.getYear() && this.cal.getMonth() == GREGORIAN_EPOCH.getMonth()) {
            return GREGORIAN_EPOCH.getMaximumDaysOfMonth();
        }
        return this.cal.getMaximumDaysOfMonth();
    }

    @Override
    public int getMaximumDaysOfYear() {
        return this.cal.getMaximumDaysOfYear();
    }

    @Override
    public int getMonth() {
        return this.cal.getMonth();
    }

    @Override
    public int getYear() {
        return this.cal.getYear();
    }

    @Override
    public boolean isLeapYear() {
        return this.cal.isLeapYear();
    }

    @Override
    public long getDate() {
        return this.cal.getDate();
    }

    @Override
    public int getDaysFromEpoch() {
        return this.getDaysFromUnixEpoch() + 719162;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        int y = this.getYear();
        if (y < 0) {
            y = -y;
            b.append("BC");
        }
        b.append(y).append("/").append(this.getMonth());
        b.append("/").append(this.getDayOfMonth());
        return b.toString();
    }
}

