/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.calendar;

import net.morilib.calendar.Day;
import net.morilib.calendar.SimpleGregorianCalendar;

public abstract class AbstractDay
implements Day {
    private static final long DAY_MILLISECS = 86400000L;

    @Override
    public int getDaysFromUnixEpoch() {
        return (int)SimpleGregorianCalendar.div(this.getDate(), 86400000L);
    }

    @Override
    public int interval(Day c) {
        return this.getDaysFromUnixEpoch() - c.getDaysFromUnixEpoch();
    }

    @Override
    public int compareTo(Day o) {
        long y;
        long x = this.getDate();
        return x < (y = o.getDate()) ? -1 : (x > y ? 1 : 0);
    }

    @Override
    public int getJulianDay() {
        return this.getDaysFromUnixEpoch() + 2440588;
    }

    @Override
    public int getModifiedJulianDay() {
        return this.getDaysFromUnixEpoch() + 40587;
    }

    @Override
    public int getLilianDay() {
        return this.getDaysFromUnixEpoch() + 2440588 - 2299161;
    }
}

