/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.trie;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.morilib.automata.DFAState;
import net.morilib.automata.trie.Trie;
import net.morilib.automata.trie.TrieNode;

public class TrieValueMatcher<T, A> {
    private Trie<T, A> trie;
    private TrieNode<T, A> node;
    private Map<TrieNode<T, A>, Map<T, TrieNode<T, A>>> fail;
    private Iterator<T> itr;
    private T pushback;
    private boolean ispushback = false;

    public TrieValueMatcher(Trie<T, A> trie, Iterator<T> itr) {
        this.trie = trie;
        this.itr = itr;
        this.node = trie.getInitialState();
        this.initfail(trie);
    }

    public TrieValueMatcher(Trie<T, A> trie, T ... ts) {
        this(trie, Arrays.asList(ts).iterator());
    }

    static <T, A> Map<T, TrieNode<T, A>> getFailureEdges(Trie<T, A> trie, List<T> lst) {
        Map<Object, Object> m = new HashMap();
        int i = lst.size() - 1;
        while (i > 0) {
            block3: {
                DFAState n = trie.getInitialState();
                int j = i;
                while (j < lst.size()) {
                    T c = lst.get(j);
                    if (!((TrieNode)n.go((Object)c)).isDead()) {
                        n = n.go((Object)c);
                        ++j;
                        continue;
                    }
                    break block3;
                }
                m = n.getEdges();
            }
            --i;
        }
        return m;
    }

    static <T, A> Map<T, Integer> getFailureBacks(Trie<T, A> trie, List<T> lst) {
        HashMap<T, Integer> m = new HashMap<T, Integer>();
        int i = lst.size() - 1;
        while (i > 0) {
            block4: {
                DFAState n = trie.getInitialState();
                int j = i;
                while (j < lst.size()) {
                    T c = lst.get(j);
                    if (!((TrieNode)n.go((Object)c)).isDead()) {
                        n = n.go((Object)c);
                        ++j;
                        continue;
                    }
                    break block4;
                }
                for (T t : n.getEdges().keySet()) {
                    m.put(t, i);
                }
            }
            --i;
        }
        return m;
    }

    static <T, A> void gennode(Trie<T, A> trie, Map<TrieNode<T, A>, Map<T, TrieNode<T, A>>> nodes, Map<TrieNode<T, A>, Map<T, Integer>> backs, TrieNode<T, A> n, List<T> lst) {
        for (T t : n.getEdges().keySet()) {
            lst.add(t);
            TrieValueMatcher.gennode(trie, nodes, backs, n.go((Object)t), lst);
            lst.remove(lst.size() - 1);
        }
        nodes.put(n, TrieValueMatcher.getFailureEdges(trie, lst));
        backs.put(n, TrieValueMatcher.getFailureBacks(trie, lst));
    }

    static <T, A> void gennode(Trie<T, A> trie, Map<TrieNode<T, A>, Map<T, TrieNode<T, A>>> nodes, TrieNode<T, A> n, List<T> lst) {
        for (T t : n.getEdges().keySet()) {
            lst.add(t);
            TrieValueMatcher.gennode(trie, nodes, n.go((Object)t), lst);
            lst.remove(lst.size() - 1);
        }
        nodes.put(n, TrieValueMatcher.getFailureEdges(trie, lst));
    }

    private void initfail(Trie<T, A> trie) {
        TrieNode<T, A> init = trie.getInitialState();
        ArrayList<T> lst = new ArrayList<T>();
        this.fail = new HashMap<TrieNode<T, A>, Map<T, TrieNode<T, A>>>();
        for (T t : init.getEdges().keySet()) {
            lst.add(t);
            TrieValueMatcher.gennode(trie, this.fail, init.go((Object)t), lst);
            lst.remove(lst.size() - 1);
        }
    }

    private T next() {
        if (this.ispushback) {
            this.ispushback = false;
            return this.pushback;
        }
        return this.itr.next();
    }

    private boolean hasNext() {
        return this.itr.hasNext() || this.ispushback;
    }

    public A nextValue() {
        A acc = null;
        while (this.hasNext()) {
            T c = this.next();
            DFAState n = this.node.go((Object)c);
            if (((TrieNode)n).isDead()) {
                TrieNode<T, A> m;
                Map<T, TrieNode<T, A>> x = this.fail.get(this.node);
                this.node = this.node.isAccepted() || x == null ? this.trie.getInitialState() : ((m = x.get(c)) == null ? this.trie.getInitialState() : m);
                if (!((TrieNode)this.node.go((Object)c)).isDead()) {
                    this.ispushback = true;
                    this.pushback = c;
                }
                if (acc == null) continue;
                return acc;
            }
            if (((TrieNode)n).isAccepted()) {
                acc = ((TrieNode)n).getAccepted().iterator().next();
                this.node = n;
                continue;
            }
            this.node = n;
        }
        return acc;
    }
}

