/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.trie;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.morilib.automata.trie.Trie;
import net.morilib.automata.trie.TrieNode;

public class TrieTransducer<T>
implements Iterator<T> {
    Trie<T, T> trie;
    List<T> buf1;
    List<T> buf2;
    TrieNode<T, T> node;
    TrieNode<T, T> prev;
    St stat = St.TRIE;
    Iterator<T> iter;

    protected TrieTransducer(Trie<T, T> trie, Iterator<T> iter) {
        this.trie = trie;
        this.node = trie.getInitialState();
        this.buf1 = new LinkedList<T>();
        this.buf2 = new LinkedList<T>();
        this.iter = iter;
    }

    private T nextSource() {
        return this.iter.next();
    }

    private boolean hasNextSource() {
        return this.iter.hasNext();
    }

    private T read() {
        return this.buf1.isEmpty() ? this.nextSource() : this.buf1.remove(0);
    }

    @Override
    public boolean hasNext() {
        return !this.buf1.isEmpty() || this.hasNextSource();
    }

    @Override
    public T next() {
        switch (this.stat) {
            case TRIE: {
                if (!this.hasNext()) {
                    if (this.prev != null) {
                        T t = this.prev.getState();
                        this.prev = null;
                        return t;
                    }
                    if (this.buf1.isEmpty()) {
                        return null;
                    }
                    this.stat = St.BUF;
                } else {
                    T t = this.read();
                    this.node = this.node.go((Object)t);
                    if (!this.node.isDead()) {
                        this.buf2.add(t);
                        if (this.node.isAccepted()) {
                            this.buf2.clear();
                            this.prev = this.node;
                        }
                        return this.next();
                    }
                    this.buf1.clear();
                    this.buf1.addAll(this.buf2);
                    this.buf2.clear();
                    this.buf2.add(t);
                    if (this.prev != null) {
                        this.buf1.addAll(this.buf2);
                        this.buf2.clear();
                        t = this.prev.getState();
                        this.prev = null;
                        this.node = this.trie.getInitialState();
                        return t;
                    }
                    if (this.buf1.isEmpty()) {
                        this.node = this.trie.getInitialState();
                        return t;
                    }
                    this.stat = St.BUF;
                    return this.next();
                }
            }
            case BUF: {
                if (!this.buf1.isEmpty()) {
                    return this.read();
                }
                if (this.hasNext()) {
                    this.buf1.addAll(this.buf2);
                    this.buf2.clear();
                    this.stat = St.TRIE;
                    this.node = this.trie.getInitialState();
                    this.prev = null;
                    return this.next();
                }
                return null;
            }
        }
        throw new RuntimeException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static enum St {
        TRIE,
        BUF;

    }
}

