/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.trie;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.morilib.automata.DFAState;

public abstract class TrieNode<T, A>
implements DFAState<T, A, Void> {
    protected boolean accepted;

    protected TrieNode(boolean accepted) {
        this.accepted = accepted;
    }

    public abstract TrieNode<T, A> go(T var1);

    @Override
    public boolean isAccepted() {
        return this.accepted;
    }

    @Override
    public Set<A> getAccepted() {
        if (this.accepted) {
            return Collections.singleton(this.getState());
        }
        return Collections.emptySet();
    }

    public TrieNode<T, A> goInt(int x) {
        throw new UnsupportedOperationException();
    }

    public TrieNode<T, A> goChar(char x) {
        throw new UnsupportedOperationException();
    }

    public abstract A getState();

    public int getStateInt() {
        throw new UnsupportedOperationException();
    }

    public long getStateLong() {
        return this.getStateInt();
    }

    public byte getStateByte() {
        return (byte)this.getStateInt();
    }

    public short getStateShort() {
        return (short)this.getStateInt();
    }

    public char getStateChar() {
        throw new UnsupportedOperationException();
    }

    public boolean getStateBoolean() {
        throw new UnsupportedOperationException();
    }

    public float getStateFloat() {
        return this.getStateInt();
    }

    public double getStateDouble() {
        return this.getStateDouble();
    }

    public abstract Map<T, TrieNode<T, A>> getEdges();

    public abstract boolean willFail(T var1);

    public boolean willFail(int x) {
        throw new UnsupportedOperationException();
    }

    public boolean willFail(char x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDead() {
        return false;
    }

    @Override
    public boolean isInitialState() {
        return false;
    }
}

