/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.trie;

import net.morilib.automata.DFAState;
import net.morilib.automata.trie.IntegerTrie;

public class IntegerTrieBuilder<A> {
    private int nodeNo = 1;
    private IntegerTrie<A> trie = new IntegerTrie();

    public IntegerTrie.Node<A> getInitialState() {
        return this.trie.getInitialState();
    }

    IntegerTrie.Node<A> nlink(IntegerTrie.Node<A> n, int x) {
        IntegerTrie.Node<Object> m = new IntegerTrie.Node<Object>(this.nodeNo++, null, false);
        n.edges.put(x, m);
        return m;
    }

    public IntegerTrieBuilder<A> append(String s, A value) {
        DFAState n = this.trie.getInitialState();
        if (value == null) {
            throw new NullPointerException();
        }
        int i = 0;
        while (i < s.length()) {
            int c = s.codePointAt(i);
            n = ((IntegerTrie.Node)n.goInt(c)).isDead() ? this.nlink((IntegerTrie.Node<A>)n, c) : n.goInt(c);
            i += c > 65535 ? 2 : 1;
        }
        n.accepted = true;
        n.value = value;
        this.trie.map.put(value, s);
        return this;
    }

    public IntegerTrie<A> get() {
        return new IntegerTrie<A>(this.trie);
    }
}

