/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.nfa;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.morilib.automata.NFAState;
import net.morilib.automata.nfa.NFAObject;
import net.morilib.automata.nfa.NFAs;

public final class GenericNFAMatcher<T, A> {
    private NFAObject<T, A, ?> nfa;
    private Set<A> result = null;
    private List<T> matched = null;

    public GenericNFAMatcher(NFAObject<T, A, ?> nfa) {
        this.nfa = nfa;
    }

    private Set<NFAState> getInitialStates() {
        return NFAs.getEpsilonReachable(this.nfa, this.nfa.getInitialStates());
    }

    public boolean match(T ... ts) {
        Set<NFAState> s;
        ArrayList<T> matches = new ArrayList<T>();
        Set<NFAState> t = s = this.getInitialStates();
        int i = 0;
        while (i < ts.length) {
            T a = ts[i];
            matches.add(a);
            t = NFAs.getStates(this.nfa, s, a);
            s = NFAs.getEpsilonReachable(this.nfa, t);
            if (s.isEmpty()) {
                return false;
            }
            ++i;
        }
        if (this.nfa.isFinalAny(s)) {
            this.matched = matches;
            this.result = NFAs.getAccept(this.nfa, s);
            return true;
        }
        this.matched = null;
        this.result = null;
        return false;
    }

    public Set<A> getResult() {
        return this.result;
    }

    public List<T> getMatched() {
        return this.matched != null ? new ArrayList<T>(this.matched) : null;
    }
}

