/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.lr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morilib.automata.lr.ContextFreeGrammar;
import net.morilib.automata.lr.ContextFreeRule;
import net.morilib.automata.lr.GrammarSymbol;
import net.morilib.automata.lr.LR0Items;
import net.morilib.automata.lr.LR1Table;
import net.morilib.automata.lr.Nonterminal;
import net.morilib.automata.lr.Terminal;
import net.morilib.util.ObjectArray;

public class SLR1Table
implements LR1Table {
    private LR0Items goTo;
    private Map<Set<LR0Items.Item>, Integer> stateIDMap = new HashMap<Set<LR0Items.Item>, Integer>();
    List<Map<GrammarSymbol, LR1Table.Action>> actionTable;
    List<Map<Nonterminal, Integer>> goToTable;
    int initialStateID;
    List<LR1Table.Conflict> conflicts;

    public SLR1Table(LR0Items goTo) {
        this.goTo = goTo;
        this.computeTable();
    }

    private void numberingStates(Collection<Set<LR0Items.Item>> states) {
        int stateid = 0;
        for (Set<LR0Items.Item> o : states) {
            this.stateIDMap.put(o, stateid++);
        }
    }

    private <T, S> List<Map<T, S>> allocateMap(int size) {
        ObjectArray<Map<T, S>> res = new ObjectArray<Map<T, S>>(size);
        int i = 0;
        while (i < size) {
            res.set(i, new HashMap());
            ++i;
        }
        return res;
    }

    void computeTable() {
        Collection<Set<LR0Items.Item>> states = this.goTo.getAllStates();
        ContextFreeGrammar grammar = this.goTo.getGrammar();
        this.conflicts = new ArrayList<LR1Table.Conflict>();
        this.numberingStates(states);
        this.actionTable = this.allocateMap(states.size());
        this.goToTable = this.allocateMap(states.size());
        for (Set<LR0Items.Item> items : states) {
            int stateid = this.stateIDMap.get(items);
            Map<GrammarSymbol, LR1Table.Action> ctable = this.actionTable.get(stateid);
            if (this.goTo.isInitialState(items)) {
                this.initialStateID = stateid;
            }
            for (LR0Items.Item item : items) {
                if (item.isReduceState()) {
                    ContextFreeRule rule = item.getRule();
                    if (rule.equals(grammar.getAugmentRule())) {
                        ctable.put(ContextFreeGrammar.ENDMARKER, LR1Table.Action.newAccept());
                        continue;
                    }
                    Set<Terminal> follow = grammar.follow(rule.getLeftSymbol());
                    for (Terminal k : follow) {
                        LR1Table.Conflict cnf;
                        LR1Table.Action act = ctable.get(k);
                        if (act == null) {
                            ctable.put(k, LR1Table.Action.newReduce(rule));
                            continue;
                        }
                        if (!act.isShift()) {
                            cnf = LR1Table.Conflict.newReduceReduce(rule, act.getReduceRule());
                            this.conflicts.add(cnf);
                            continue;
                        }
                        cnf = LR1Table.Conflict.newShiftReduce(k, rule);
                        this.conflicts.add(cnf);
                    }
                    continue;
                }
                GrammarSymbol symbol = item.getDirectedSymbol();
                Set<LR0Items.Item> nextst = this.goTo.goTo(items, symbol);
                int nextid = this.stateIDMap.get(nextst);
                if (symbol instanceof Terminal) {
                    LR1Table.Action act = ctable.get(symbol);
                    if (act == null) {
                        ctable.put(symbol, LR1Table.Action.newShift(nextid));
                        continue;
                    }
                    if (act.isShift()) continue;
                    LR1Table.Conflict cnf = LR1Table.Conflict.newShiftReduce(symbol, act.getReduceRule());
                    this.conflicts.add(cnf);
                    continue;
                }
                if (!(symbol instanceof Nonterminal)) continue;
                this.goToTable.get(stateid).put((Nonterminal)symbol, nextid);
            }
        }
    }

    @Override
    public LR1Table.Action action(int stateID, Terminal terminal) {
        return this.actionTable.get(stateID).get(terminal);
    }

    @Override
    public int goTo(int stateID, Nonterminal nonterminal) {
        return this.goToTable.get(stateID).get(nonterminal);
    }

    @Override
    public int getInitialStateID() {
        return this.initialStateID;
    }

    @Override
    public Collection<LR1Table.Conflict> getConflicts() {
        return Collections.unmodifiableCollection(this.conflicts);
    }
}

