/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata;

import java.util.EnumSet;
import java.util.NoSuchElementException;
import net.morilib.automata.BoundOnewayHead;
import net.morilib.automata.TextBound;

public final class CharSequenceHead
implements BoundOnewayHead<Integer> {
    private CharSequence seq;
    private int ptr = 0;
    private int befc = -1;

    public CharSequenceHead(CharSequence seq) {
        this.seq = seq;
    }

    @Override
    public EnumSet<TextBound> getBounds() {
        EnumSet<TextBound> res = EnumSet.noneOf(TextBound.class);
        if (this.befc == -1) {
            res.add(TextBound.BEGIN_INPUT);
            res.add(TextBound.BEGIN_LINE);
        } else if (this.befc == 10) {
            res.add(TextBound.BEGIN_LINE);
        }
        if (this.ptr < this.seq.length()) {
            char cc = this.seq.charAt(this.ptr);
            if (cc == '\n') {
                res.add(TextBound.END_LINE);
                if (this.ptr + 1 >= this.seq.length()) {
                    res.add(TextBound.END_INPUT_WITHOUT_LINE);
                }
            }
            if (Character.isWhitespace(this.befc) && !Character.isWhitespace((int)cc)) {
                res.add(TextBound.NOT_WORD);
            }
            if (!Character.isWhitespace(this.befc) && Character.isWhitespace((int)cc)) {
                res.add(TextBound.WORD);
            }
        } else {
            res.add(TextBound.END_LINE);
            res.add(TextBound.END_INPUT);
        }
        return res;
    }

    @Override
    public boolean hasNext() {
        return this.ptr < this.seq.length();
    }

    @Override
    public Integer read() {
        return this.readInt();
    }

    @Override
    public int readInt() {
        if (this.hasNext()) {
            char c = this.seq.charAt(this.ptr++);
            this.befc = c;
            return c;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void unread() {
        if (this.ptr > 0) {
            this.befc = --this.ptr > 0 ? (int)this.seq.charAt(this.ptr - 1) : -1;
        }
    }
}

