/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.lite.subr;

import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.ILispVector;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispSmallInt;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2009
 */
public class VectorRef extends BinaryArgs {

	@Override
	protected Datum execute(
			Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
		if(!(c2a instanceof LispSmallInt)) {
			throw mesg.getError("err.require.smallint", c2a);
		}

		int idx = ((LispSmallInt)c2a).getExactSmallInt();
		if(idx < 0) {
			throw mesg.getError("err.vector.outofrange", c2a);
		}

		if(c1a instanceof ILispVector) {
			ILispVector v = (ILispVector)c1a;

			if(idx >= v.size()) {
				throw mesg.getError("err.vector.outofrange", c2a);
			}
			return v.get(idx);
		} else {
			throw mesg.getError("err.require.vector", c1a);
		}
	}

}
