/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.lite.subr;

import java.util.List;

import net.morilib.lisp.lite.Cons;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispCharacter;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispString;
import net.morilib.lisp.lite.LispUtils;
import net.morilib.lisp.lite.Nil;

public class ListToString extends UnaryArgs {

	@Override
	protected Datum execute(
			Datum c1a, Environment env, LispMessage mesg) {
		if(c1a != Nil.NIL && !(c1a instanceof Cons)) {
			throw mesg.getError("err.list", c1a);
			//throw new LispException("list required");
		}
		
		List<Datum> lst = LispUtils.consToList(c1a, mesg);
		StringBuilder bld = new StringBuilder();
		
		for(int i = 0; i < lst.size(); i++) {
			if(lst.get(i) instanceof LispCharacter) {
				bld.append(((LispCharacter)lst.get(i)).getCharacter());
			} else {
				throw mesg.getError("err.require.char", lst.get(i));
				//throw new LispException("character required");
			}
		}
		
		return new LispString(bld.toString());
	}

}
