/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.lite.subr;

import net.morilib.lisp.lite.Cons;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.Subr;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2009
 */
public abstract class BinaryArgs extends Subr {

	/**
	 * 
	 */
	public BinaryArgs() {
		// do nothing
	}

	/**
	 * 
	 * @param name
	 */
	public BinaryArgs(String name) {
		symbolName = name;
	}

	/**
	 * 
	 * @param c1a
	 * @param c2a
	 * @param env
	 * @param mesg
	 * @return
	 */
	protected abstract Datum execute(
			Datum c1a, Datum c2a, Environment env, LispMessage mesg);

	/* (non-Javadoc)
	 * @see net.morilib.lisp.Subr#eval(net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
	 */
	public Datum eval(
			Datum body,
			Environment env,
			LispMessage mesg) {
		if(body instanceof Cons) {
			Cons c1 = (Cons)body;

			Datum c1a = c1.getCar();
			Datum c1d = c1.getCdr();
			if(c1d instanceof Cons) {
				Datum c2a = ((Cons)c1d).getCar();

				return execute(c1a, c2a, env, mesg);
			} else {
				throw mesg.getError("err.argument", symbolName);
				//throw new LispException("wrong number of arguments");
			}
		} else {
			throw mesg.getError("err.argument", symbolName);
			//throw new LispException("wrong number of arguments");
		}
	}

}
