/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.lite;

public abstract class Settable extends NamableDatum {
	
	//
	private Datum setter = Undef.UNDEF;
	
	
	public Settable() {
		super(null);
	}
	
	
	public Settable(String name) {
		super(name);
	}
	
	
	/*package*/ void setSetter(Datum setter) {
		if(setter == null) {
			throw new NullPointerException();
		}
		this.setter = setter;
	}
	
	
	public Datum getSetter() {
		return setter;
	}
	
}
