/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.lite.subr;

import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispDouble;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispNumber;
import net.morilib.lisp.lite.LispReal;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2009
 */
public class Magnitude extends UnaryArgs {

	/* (non-Javadoc)
	 * @see net.morilib.lisp.subr.UnaryArgs#execute(net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
	 */
	@Override
	protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
		if(c1a instanceof LispNumber) {
			LispNumber n = (LispNumber)c1a;

			if(n.isReal()) {
				LispReal r = (LispReal)n;

				return (r.signum() < 0) ? r.uminus() : r;
			} else {
				double r = n.getRealDouble();
				double i = n.getImagDouble();

				return new LispDouble(Math.hypot(r, i));
			}
		} else {
			throw mesg.getError("err.require.number", c1a);
		}
	}

}
