/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.lite.datetime;

import java.util.List;

import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispBoolean;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispUtils;
import net.morilib.lisp.lite.Subr;

public abstract class TimeCompare extends Subr {

	/**
	 * 
	 * @param c1a
	 * @param c2a
	 * @return
	 */
	protected abstract boolean compare(LispTime c1a, LispTime c2a);

	/* (non-Javadoc)
	 * @see net.morilib.lisp.Subr#eval(net.morilib.lisp.Datum, net.morilib.lisp.Environment)
	 */
	public Datum eval(
			Datum body,
			Environment env,
			LispMessage mesg) {
		List<Datum> lst = LispUtils.consToList(body, mesg);

		if(lst.size() < 2) {
			throw mesg.getError("err.argument", body);
		} else if(!(lst.get(0) instanceof LispTime)) {
			throw mesg.getError("err.require.char", lst.get(0));
		}

		LispTime prev = (LispTime)lst.get(0);
		for(int i = 1; i < lst.size(); i++) {
			Datum d = lst.get(i);

			if(d instanceof LispTime) {
				LispTime td = (LispTime)d;

				if(!prev.getTimeType().equals(td.getTimeType())) {
					throw mesg.getError(
							"err.srfi19.differenttimetype");
				} else if(compare(prev, td)) {
					prev = td;
				} else {
					return LispBoolean.FALSE;
				}
			} else {
				throw mesg.getError("err.srfi19.require.time", d);
			}
		}
		return LispBoolean.TRUE;
	}

}
