/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.lite.condition;

import net.morilib.lisp.lite.Cons;
import net.morilib.lisp.lite.ConsIterator;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.Subr;
import net.morilib.lisp.lite.subr.SubrUtils;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2011/09/03
 */
public class MakeCondition extends Subr {

	/* (non-Javadoc)
	 * @see net.morilib.lisp.Subr#eval(net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
	 */
	@Override
	public Datum eval(Datum body, Environment env, LispMessage mesg) {
		ConsIterator itr = new ConsIterator(body);
		Datum d = SubrUtils.nextIf(itr, mesg, body);
		LispSimpleCondition r;
		String s;
		Datum x, z;

		if(d instanceof LispConditionType) {
			r = new LispSimpleCondition((LispConditionType)d);
			while(itr.hasNext()) {
				z = SubrUtils.nextIf(itr, mesg, body);
				if(z instanceof Cons) {
					s = SubrUtils.getSymbolName(
							((Cons)z).getCar(), mesg);
					x = SubrUtils.cadr(z, mesg);
				} else {
					s = SubrUtils.getSymbolName(z, mesg);
					x = SubrUtils.nextIf(itr, mesg, body);
				}

				if(!r.setField(s, x)) {
					throw mesg.getError(
							"err.condition.field.undefined", s);
				}
			}
			SubrUtils.checkTerminated(itr, body, mesg);
			return r;
		} else {
			throw mesg.getError(
					"err.condition.require.conditiontype", d);
		}
	}

}
