/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.lite;

import java.io.File;
import java.io.IOException;

import net.morilib.lisp.lite.ConsIterator;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.subr.SubrUtils;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2011/04/24
 */
public final class LispFiles {

	//
	/*package*/ static String chdir = null;

	//
	private LispFiles() {}

	/**
	 * 
	 * @param env
	 * @param s
	 * @return
	 * @throws IOException
	 */
	public static File getFile(
			Environment env, String s) throws IOException {
		File  f = new File(s.replaceFirst("^~/",
				System.getProperty("user.home") + "/"));

		if(f.isAbsolute()) {
			return f;
		} else if(chdir != null) {
			return new File(chdir, s).getCanonicalFile();
		} else {
			return new File(
					System.getProperty("user.dir"),
					s).getCanonicalFile();
		}
	}

	/**
	 * 
	 * @param env
	 * @param d
	 * @param mesg
	 * @return
	 * @throws IOException 
	 */
	public static File getFile(
			Environment env, Datum d,
			LispMessage mesg) throws IOException {
		return getFile(env, SubrUtils.getString(d, mesg));
	}

	/**
	 * @param itr
	 * @param mesg
	 * @param body
	 * @return
	 * @throws IOException 
	 */
	public static File nextFile(ConsIterator itr, Environment env,
			LispMessage mesg, Datum body) throws IOException {
		return getFile(env, SubrUtils.nextIf(itr, mesg, body), mesg);
	}

	/**
	 * 
	 * @param env
	 * @return
	 */
	public static File pwd(Environment env) {
		if(chdir != null) {
			return new File(chdir);
		} else {
			return new File(System.getProperty("user.dir"));
		}
	}

}
