/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite.datetime;

import java.math.BigDecimal;
import java.util.Date;
import net.morilib.lang.number.Integer2;
import net.morilib.lang.number.Rational;

public class JulianDay
extends Date {
    private static final long serialVersionUID = -2229179274862330981L;
    private static final long HOURS = 24L;
    private static final long MINUTES = 60L;
    private static final long SECONDS = 60L;
    private static final long MILLISEC = 1000L;
    private static final long DAY_MILLISEC = 86400000L;
    private static final Integer2 DAY_MILLISEC_2 = Integer2.valueOf(86400000L);
    private static final Rational DAY_MILLISEC_R = Rational.valueOf(DAY_MILLISEC_2, Integer2.ONE);
    private static final long MAX_DAYS = 106751991167L;
    private static final long MIN_DAYS = -106751991167L;
    private static final Rational MAX_DAYS_R = Rational.valueOf(Integer2.valueOf(106751991167L), Integer2.ONE);
    private static final Rational MIN_DAYS_R = Rational.valueOf(Integer2.valueOf(-106751991167L), Integer2.ONE);
    private static final int JULIAN_DAY_OF_UNIX_EPOCH = 2440587;
    private static final Rational JULIAN_DAY_OF_UNIX_EPOCH_R = Rational.valueOf(4881175, 2);
    private static final long JULIAN_TIME_OF_UNIX_EPOCH = 210866760000000L;
    private static final Integer2 JULIAN_TIME_OF_UNIX_EPOCH_2 = Integer2.valueOf(210866760000000L);
    private static final Rational MODIFIED_JULIAN_DAY_EPOCH_R = Rational.valueOf(4800001, 2);

    public JulianDay(long time) {
        super(time);
    }

    public JulianDay() {
    }

    public static JulianDay day(int day) {
        long d = (long)(day - 2440587) * 86400000L;
        return new JulianDay(d + 43200000L);
    }

    private static long toTime(Rational day) {
        Rational d2 = day.subtract(JULIAN_DAY_OF_UNIX_EPOCH_R);
        if (d2.compareTo(MAX_DAYS_R) > 0) {
            return Long.MAX_VALUE;
        }
        if (d2.compareTo(MIN_DAYS_R) < 0) {
            return Long.MIN_VALUE;
        }
        d2 = d2.multiply(DAY_MILLISEC_R);
        return d2.longFloor();
    }

    public static JulianDay day(BigDecimal day) {
        return new JulianDay(JulianDay.toTime(Rational.valueOf(day)));
    }

    public static JulianDay day(Rational r) {
        return new JulianDay(JulianDay.toTime(r));
    }

    public static JulianDay day(double day) {
        return new JulianDay(JulianDay.toTime(Rational.valueOf(day)));
    }

    public Rational getJulianDay() {
        Integer2 l = Integer2.valueOf(this.getTime());
        l = l.add(JULIAN_TIME_OF_UNIX_EPOCH_2);
        return Rational.valueOf(l, DAY_MILLISEC_2);
    }

    public void setJulianDay(BigDecimal day) {
        this.setTime(JulianDay.toTime(Rational.valueOf(day)));
    }

    public void setJulianDay(Rational r) {
        this.setTime(JulianDay.toTime(r));
    }

    public void setJulianDay(double day) {
        this.setTime(JulianDay.toTime(Rational.valueOf(day)));
    }

    public Rational getModifiedJulianDay() {
        return this.getJulianDay().subtract(MODIFIED_JULIAN_DAY_EPOCH_R);
    }

    public void setModifiedJulianDay(BigDecimal day) {
        this.setModifiedJulianDay(Rational.valueOf(day));
    }

    public void setModifiedJulianDay(Rational r) {
        this.setJulianDay(r.add(MODIFIED_JULIAN_DAY_EPOCH_R));
    }

    public void setModifiedJulianDay(double day) {
        this.setModifiedJulianDay(Rational.valueOf(day));
    }
}

