/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import java.util.ArrayList;
import java.util.List;
import net.morilib.lisp.lite.CodeExecutor;
import net.morilib.lisp.lite.CompiledCode;
import net.morilib.lisp.lite.Cons;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.IntStack;
import net.morilib.lisp.lite.LispCompiler;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispUtils;
import net.morilib.lisp.lite.Promise;
import net.morilib.lisp.lite.Syntax;
import net.morilib.lisp.lite.subr.MakeCons;

public class SynConsStream
extends Syntax {
    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
        List<Datum> lst = LispUtils.consToList(body, mesg);
        CompiledCode.Builder nbuild = new CompiledCode.Builder();
        if (lst.size() != 2) {
            throw mesg.getError("err.argument");
        }
        comp.compile(lst.get(1), env, nbuild, callsym, false, symlist, exec, memento, syncased);
        nbuild.addReturnOp();
        Promise prms = new Promise(nbuild.getCodeRef());
        build.addPush(new MakeCons());
        build.addBeginList();
        comp.compile(lst.get(0), env, build, callsym, false, symlist, exec, memento, syncased);
        build.addAppendList();
        build.addNewPromise(prms);
        build.addAppendList();
        build.addEndList();
        build.addCall();
    }

    @Override
    Datum replaceLocalVals(Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, boolean toplv, int ttype) {
        List<Datum> lst = LispUtils.consToList(body, mesg);
        ArrayList<Datum> res = new ArrayList<Datum>();
        if (lst.size() != 2) {
            throw mesg.getError("err.argument");
        }
        res.add(comp.replaceLocalVals(lst.get(0), env, ienv, false, ttype));
        res.add(comp.replaceLocalVals(lst.get(1), env, ienv, false, ttype));
        return LispUtils.listToCons(res);
    }

    @Override
    public String toString() {
        return "Syntax:cons-stream";
    }
}

