/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import java.util.ArrayList;
import java.util.List;
import net.morilib.lisp.lite.CodeExecutor;
import net.morilib.lisp.lite.CompiledCode;
import net.morilib.lisp.lite.Cons;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.IntStack;
import net.morilib.lisp.lite.LispBoolean;
import net.morilib.lisp.lite.LispCompiler;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispUtils;
import net.morilib.lisp.lite.Nil;
import net.morilib.lisp.lite.Syntax;

public class SynAnd
extends Syntax {
    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
        Datum p = body;
        int last = build.allocLabel();
        build.addPush(LispBoolean.TRUE);
        while (p instanceof Cons) {
            Cons c = (Cons)p;
            build.addPop();
            comp.compile(c.getCar(), env, build, callsym, istail && c.getCdr() == Nil.NIL, symlist, exec, memento, syncased);
            build.addJmpUnless(last);
            p = c.getCdr();
        }
        if (p != Nil.NIL) {
            throw mesg.getError("err.list");
        }
        build.setCurrentAddressToLabel(last);
    }

    @Override
    Datum replaceLocalVals(Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, boolean toplv, int ttype) {
        List<Datum> lst = LispUtils.consToList(body, mesg);
        ArrayList<Datum> res = new ArrayList<Datum>();
        int i = 0;
        while (i < lst.size()) {
            res.add(comp.replaceLocalVals(lst.get(i), env, ienv, false, ttype));
            ++i;
        }
        return LispUtils.listToCons(res);
    }
}

