/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import java.util.HashMap;
import java.util.Map;
import net.morilib.lisp.lite.Atom;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispInteger;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispString;
import net.morilib.lisp.lite.LispUtils;
import net.morilib.lisp.lite.SymbolName;
import net.morilib.lisp.lite.subr.SubrUtils;
import net.morilib.lisp.lite.subr.UnaryArgs;

public final class Symbol
extends Atom
implements SymbolName {
    static final Namespace DEFAULT_NAMESPACE = new Namespace();
    static final int NO_FOLD_CASE = 0;
    static final int UPPER_FOLD_CASE = 1;
    static final int LOWER_FOLD_CASE = 2;
    public static final Symbol QUOTE = DEFAULT_NAMESPACE.getSymbol("quote");
    public static final Symbol QUASIQUOTE = DEFAULT_NAMESPACE.getSymbol("quasiquote");
    public static final Symbol UNQUOTE = DEFAULT_NAMESPACE.getSymbol("unquote");
    public static final Symbol UNQUOTE_SPLICING = DEFAULT_NAMESPACE.getSymbol("unquote-splicing");
    static int foldCase = 0;
    private static Namespace namespace = DEFAULT_NAMESPACE;
    private static long macroid = 0L;
    private String name;
    private Symbol replace = null;
    private boolean replaced = false;
    private Symbol macroSymbol = null;
    private Namespace ns = null;

    private Symbol(String name) {
        this.name = name;
    }

    private Symbol(String name, Namespace ns) {
        this.name = name;
        this.ns = ns;
    }

    public static Symbol getSymbol(String name) {
        switch (foldCase) {
            case 0: {
                return namespace.getSymbol(name);
            }
            case 1: 
            case 2: {
                return namespace.getSymbol(name.toLowerCase());
            }
        }
        throw new RuntimeException();
    }

    public static Symbol getSymbolWithoutFoldCase(String name) {
        return namespace.getSymbol(name);
    }

    static Symbol newAndMark(Map<Symbol, Symbol> box, Symbol sym, boolean mark) {
        Symbol res;
        if (sym == null) {
            throw new NullPointerException();
        }
        if (mark) {
            res = box.get(sym);
            if (res == null) {
                res = new Symbol(null);
                res.replace = sym;
                res.replaced = true;
                res.macroSymbol = sym;
                box.put(sym, res);
            }
        } else if (!sym.replaced) {
            res = sym;
        } else {
            res = sym.replace;
            if (res == null) {
                throw new NullPointerException();
            }
        }
        return res;
    }

    public static Symbol gensym() {
        Symbol res = new Symbol(null);
        return res;
    }

    public static Symbol encloseSymbol(Symbol sym) {
        Symbol res = new Symbol(null);
        res.macroSymbol = sym.macroSymbol;
        return res;
    }

    public static Symbol getMacroSymbol(Symbol sym) {
        Symbol x = sym.getSymbol();
        return namespace.getSymbol(String.valueOf(x.name) + "#:" + macroid);
    }

    public static Symbol getMacroSymbol(Symbol sym, long id) {
        Symbol x = sym.getSymbol();
        return namespace.getSymbol(String.valueOf(x.name) + "#:" + id);
    }

    public boolean isEqv(Atom a) {
        return this.equals(a);
    }

    @Override
    public String getName() {
        return this.name == null ? "#:" + this.hashCode() : this.name;
    }

    public boolean isGenerated() {
        return this.name == null;
    }

    public boolean isReplaced() {
        return this.replace != null;
    }

    @Override
    public LispString toLispString() {
        return new LispString(this.getName());
    }

    public boolean isNormal() {
        String s = this.getName();
        int i = 0;
        while (i < s.length()) {
            if (LispUtils.isReservedCharacter(s.charAt(i))) {
                return false;
            }
            if (foldCase != 0 && Character.isUpperCase(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String print() {
        if (!this.isNormal()) {
            return "|" + this.getName() + "|";
        }
        if (foldCase == 0) {
            return this.getName();
        }
        if (foldCase == 2) {
            return this.getName().toLowerCase();
        }
        if (foldCase == 1) {
            return this.getName().toUpperCase();
        }
        throw new RuntimeException();
    }

    @Override
    public String getResult() {
        return this.print();
    }

    Symbol getEnclosedSymbol() {
        Symbol sym = this;
        while (sym.macroSymbol != null) {
            sym = sym.macroSymbol;
        }
        return sym;
    }

    public boolean isMacroBound() {
        return this.name != null && this.name.indexOf("#:") >= 0;
    }

    public long getMacroId() {
        int x = this.name.indexOf("#:");
        return x < 0 ? (long)x : Long.parseLong(this.name.substring(x + 2));
    }

    @Override
    public String toString() {
        return "Symbol:" + this.getName() + ":" + System.identityHashCode(this);
    }

    @Override
    public boolean isTypeSymbol() {
        return true;
    }

    @Override
    public Symbol getSymbol() {
        int x = this.name == null ? -1 : this.name.indexOf("#:");
        return x < 0 ? this : Symbol.getSymbol(this.name.substring(0, x));
    }

    public Namespace getNamespace() {
        return this.ns;
    }

    /* synthetic */ Symbol(String string, Namespace namespace, Symbol symbol) {
        this(string, namespace);
    }

    public static class MacroIdAdd
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            macroid = macroid + (long)SubrUtils.getSmallInt(c1a, mesg);
            if (macroid < 0L) {
                macroid = Long.MAX_VALUE + macroid + 1L;
            }
            return LispInteger.valueOf(macroid);
        }
    }

    public static class Namespace {
        private Map<String, Symbol> flyweight = new HashMap<String, Symbol>();

        Namespace() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Symbol getSymbol(String name) {
            Symbol res;
            if (name == null) {
                throw new NullPointerException("Symbol");
            }
            Namespace namespace = this;
            synchronized (namespace) {
                res = this.flyweight.get(name);
                if (res == null) {
                    res = new Symbol(name, this, null);
                    this.flyweight.put(name, res);
                }
            }
            return res;
        }
    }
}

