/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morilib.lisp.lite.Cons;
import net.morilib.lisp.lite.ConsIterator;
import net.morilib.lisp.lite.ConsListBuilder;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispBoolean;
import net.morilib.lisp.lite.LispException;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispUtils;
import net.morilib.lisp.lite.LispVector;
import net.morilib.lisp.lite.Nil;
import net.morilib.lisp.lite.PatternDepthException;
import net.morilib.lisp.lite.PatternDepthIndex;
import net.morilib.lisp.lite.PatternDepthMap;
import net.morilib.lisp.lite.PatternEllipsisException;
import net.morilib.lisp.lite.PatternIntEllipsis;
import net.morilib.lisp.lite.Scheme;
import net.morilib.lisp.lite.Subr;
import net.morilib.lisp.lite.Symbol;
import net.morilib.lisp.lite.SymbolName;
import net.morilib.lisp.lite.SymbolScope;
import net.morilib.lisp.lite.SynLambda;
import net.morilib.lisp.lite.SynLetType;
import net.morilib.lisp.lite.SynQuasisyntax;
import net.morilib.lisp.lite.SynSyntax;
import net.morilib.lisp.lite.SynSyntaxCase;
import net.morilib.lisp.lite.SyntaxUtils;
import net.morilib.lisp.lite.UserSyntax;
import net.morilib.lisp.lite.exlib.Gensym;
import net.morilib.lisp.lite.subr.BinaryArgs;
import net.morilib.lisp.lite.subr.UnaryArgs;
import net.morilib.util.NullSet;

class PatternMatch {
    private static final Datum ELLIPSIS = Symbol.getSymbol("...");
    private static final Datum UNDERBAR = Symbol.getSymbol("_");
    private static final int PATTERN = 0;
    private static final int TEMPLATE = 1;
    private static final IsSynCase IS_SYN_CASE = new IsSynCase();
    private static final IsSynQuot IS_SYN_QUOT = new IsSynQuot();
    private static final IsWithSyn IS_WITH_SYN = new IsWithSyn();
    private static final IsSynQQuo IS_SYN_QQUT = new IsSynQQuo();
    private static final AddUSyn ADD_U_SYN = new AddUSyn();
    private static final AddLtWrap ADD_LT_WRAP = new AddLtWrap();
    private static final EllipsisC ELLIPSIS_C = new EllipsisC();
    private static final Scheme AUX_S = new Scheme(Scheme.newRnRSEnv(5), LispMessage.getInstance());
    private static final Scheme AUX_S2;

    static {
        AUX_S.set("syncase?", IS_SYN_CASE);
        AUX_S.set("synquot?", IS_SYN_QUOT);
        AUX_S.set("withsyn?", IS_WITH_SYN);
        AUX_S.set("synqquo?", IS_SYN_QQUT);
        AUX_S.set("addusyn", ADD_U_SYN);
        AUX_S.set("ltwrap", ADD_LT_WRAP);
        AUX_S.set("get...", ELLIPSIS_C);
        AUX_S.set("gensym", new Gensym());
        AUX_S.exec("(define (mapv f vec)  (let ((v1 (make-vector (vector-length vec))))    (let loop ((i (vector-length vec)))      (cond ((zero? i) v1)            (else              (vector-set!                v1                (- i 1)                (f (vector-ref vec (- i 1))))              (loop (- i 1)))))))");
        AUX_S.exec("(define (flat*-aux x y)  (cond ((null? x) y)        ((pair? x)          (append            (flat*-aux (car x) '())            (flat*-aux (cdr x) y)))        ((vector? x)          (let lp2 ((i (vector-length x)) (rs y))            (cond ((zero? i) rs)                  (else                    (lp2 (- i 1)                         (append                           (flat*-aux                             (vector-ref x (- i 1))                             '())                           rs))))))        (else (cons x y))))");
        AUX_S.exec("(define (flat* x)  (flat*-aux x '()))");
        AUX_S.exec("(define (remnsym x)  (cond ((null? x) '())        ((and (pair? x) (symbol? (car x)))          (cons (car x) (remnsym (cdr x))))        ((pair? x) (remnsym (cdr x)))        (else x)))");
        AUX_S.exec("(define (cpy x)  (cond ((null? x) '())        (else (cons x (cpy (cdr x))))))");
        AUX_S.exec("(define (properize x)  (cond ((null? x) '())        ((pair? x)          (cons (car x) (properize (cdr x))))        (else (cons x '()))))");
        AUX_S.exec("(define (coll x) (properize (car x)))");
        AUX_S.exec("(define (unsyn? x)  (or (eq? x 'unsyntax) (eq? x 'unsyntax-splicing)))");
        AUX_S.exec("(define (repls x usyn)  (let loop ((x x) (q #f) (prms '()))    (letrec ((f1               (lambda (x prms)                 (append                   (remnsym (flat* (caddr x)))                   (remnsym (flat*                     (map coll (cdddr x))))                   prms)))             (f2               (lambda (x prms)                 (append                   (remnsym (flat*                     (map coll (cadr x))))                   prms))))      (cond ((null? x) '())            ((eq? x '_) x)            ((eq? x (get...)) (get...))            ((and (pair? x) (syncase? (car x)))              (cons (car x)                    (loop (cdr x) q (f1 x prms))))            ((and (pair? x) (withsyn? (car x)))              (cons (car x)                    (loop (cdr x) q (f2 x prms))))            ((and (pair? x) (synquot? (car x)))              (cons (car x)                    (loop (cdr x) #t prms)))            ((and (pair? x)                  (or (not q) (integer? q))                  (synqquo? (car x)))              (cons (car x)                    (loop (cdr x)                          (if q (+ q 1) 0)                          prms)))            ((and (pair? x) (unsyn? (car x)))              (cond ((zero? q) x)                    ((integer? q)                       (cons                         (car x)                         (loop (cdr x)                               (- q 1)                               prms)))                    (else (error                            (get-default-message                              'err.unsyntax.malform                              '())))))            ((and (pair? x))              (cons (loop (car x) q prms)                    (loop (cdr x) q prms)))            ((vector? x)              (mapv (lambda (x) (loop x q prms)) x))            ((and q (symbol? x) (not (memq x prms)))              (addusyn x usyn))            (else x)))))");
        AUX_S.exec("(define (letren x) (lren0 x '() #f))");
        AUX_S.exec("(define (lren0 x as lv)  (cond ((and (pair? x) (eq? 'syntax (car x)))          (cons (car x)                (lren0 (cdr x) as #t)))        ((and (pair? x) (eq? 'quasisyntax (car x)))          (cons (car x)                (lren0 (cdr x) as                       (if lv lv 0))))        ((and (pair? x) (eq? 'unsyntax (car x)))          (cons (car x)                (lren0 (cdr x) as                       (if (> lv 0) (- lv 1) #f))))        ((and (pair? x)              (eq? 'unsyntax-splicing (car x)))          (cons (car x)                (lren0 (cdr x) as                       (if (> lv 0) (- lv 1) #f))))        ((and (not lv)              (pair? x)              (memq (car x) '(let letrec)))          (if (symbol? (cadr x))              (chletn x                      as                      (cons                        (cons (cadr x) (gensym))                        (append                          (makeasc (caddr x))                          as))                      lv)              (chlet  x                      as                      (cons (makeasc (cadr x)) as)                      lv)))        ((and (not lv)              (pair? x)              (memq (car x) '(let* letrec*)))          (chlet* x                  as                  lv))        ((and (not lv)              (pair? x)              (memq (car x) '(lambda)))          (let ((as2 (append (makeascl (cadr x)) as)))            (cons (car x)             (cons (lren0 (cadr x) as2 lv)              (lren0 (cddr x) as2 lv)))))        ((pair? x)          (cons (lren0 (car x) as lv)                (lren0 (cdr x) as lv)))        ((vector? x)          (mapv (lambda (x) (lren0 x as lv)) x))        ((and (not lv) (assq x as))          (cdr (assq x as)))        (else x)))");
        AUX_S.exec("(define (ext-var x)  (remnsym (map car x)))");
        AUX_S.exec("(define (makeasc x)  (cond ((null? x) '())        (else (cons (cons (caar x) (gensym))                    (makeasc (cdr x))))))");
        AUX_S.exec("(define (makeascl x)  (cond ((null? x) '())        (else (cons (cons (car x) (gensym))                    (makeascl (cdr x))))))");
        AUX_S.exec("(define (chlet x a0 as lv)  (cons (car x)        (cons (map (lambda (x)                     (cons (assqif (car x) as)                           (lren0 (cdr x) a0 lv)))                   (cadr x))              (lren0 (cddr x) as lv))))");
        AUX_S.exec("(define (chlet*-aux x a0 lv)  (cond ((null? x) (values '() a0))        (else          (let ((a1 (cons                      (cons (caar x) (gensym)) a0)))            (call-with-values              (lambda () (chlet*-aux (cdr x) a1 lv))              (lambda (rs a2)                (values                  (cons                    (cons (assqif (caar x) a1)                          (lren0 (cdar x) a0 lv))                    rs)                  a2)))))))");
        AUX_S.exec("(define (chlet* x a0 lv)  (cons (car x)        (call-with-values          (lambda () (chlet*-aux (cadr x) a0 lv))          (lambda (rs as)            (cons rs                  (lren0 (cddr x) as lv))))))");
        AUX_S.exec("(define (chletn x a0 as lv)  (cons (car x)        (cons (cdr (assq (cadr x) as))              (cons (map (lambda (x)                           (cons (assqif (car x) as)                                 (lren0                                   (cdr x) a0 lv)))                         (caddr x))                    (lren0 (cdddr x) as lv)))))");
        AUX_S.exec("(define (assqif x as)  (if (assq x as) (cdr (assq x as)) x))");
        AUX_S2 = new Scheme(Scheme.newRnRSEnv(5), LispMessage.getInstance());
        AUX_S2.set("gensym", new Gensym());
        AUX_S2.set("samescp?", new EqWithSyn());
        AUX_S2.set("remvscp", new RmWithSyn());
        AUX_S2.exec("(define (mapv f vec)  (let ((v1 (make-vector (vector-length vec))))    (let loop ((i (vector-length vec)))      (cond ((zero? i) v1)            (else              (vector-set!                v1                (- i 1)                (f (vector-ref vec (- i 1))))              (loop (- i 1)))))))");
        AUX_S2.exec("(define (asss x lis)  (cond ((null? lis) #f)        ((not (pair? (car lis)))          (error (get-default-message            'err.require.pair)))        ((samescp? (caar lis) x) (car lis))        (else (asss x (cdr lis)))))");
        AUX_S2.exec("(define (letren x) (lren0 x '() #f))");
        AUX_S2.exec("(define (lren0 x as lv)  (cond (lv          (cond ((and (pair? x)                     (eq? 'unsyntax (remvscp (car x))))                  (cons (car x)                    (lren0 (cdr x) as                           (if (> lv 0) (- lv 1) #f))))                ((and (pair? x)                     (eq? 'unsyntax-splicing (remvscp (car x))))                  (cons (car x)                    (lren0 (cdr x) as                           (if (> lv 0) (- lv 1) #f))))                ((pair? x)                  (cons (lren0 (car x) as lv)                        (lren0 (cdr x) as lv)))                ((vector? x)                  (mapv (lambda (x) (lren0 x as lv)) x))                ((and lv (asss x as))                  (cdr (asss x as)))                (else x)))        ((and (pair? x)              (eq? 'syntax (remvscp (car x))))          (cons (car x)                (cdr x)))        ((and (pair? x)              (eq? 'quasisyntax (remvscp (car x))))          (cons (car x)                (lren0 (cdr x) as                       (if lv lv 0))))        ((and (pair? x)              (eq? 'unsyntax (remvscp (car x))))          (cons (car x)                (lren0 (cdr x) as                       (if (> lv 0) (- lv 1) #f))))        ((and (pair? x)              (eq? 'unsyntax-splicing (remvscp (car x))))          (cons (car x)                (lren0 (cdr x) as                       (if (> lv 0) (- lv 1) #f))))        ((and lv              (pair? x)              (memq (remvscp (car x)) '(let letrec)))          (if (symbol? (cadr x))              (chletn x                      as                      (cons                       (cons (cadr x) (gensym))                       (append                        (makeasc (caddr x))                        as))                      lv)              (chlet  x                      as                      (append (makeasc (cadr x)) as)                      lv)))        ((and lv              (pair? x)              (memq (remvscp (car x)) '(let* letrec*)))          (chlet* x                  as                  (append (makeasc (cadr x)) as)                  lv))        ((and lv              (pair? x)              (memq (remvscp (car x)) '(lambda)))          (let ((as2 (append (makeascl (cadr x)) as)))            (cons (car x)             (cons (lren0 (cadr x) as2 lv)              (lren0 (cddr x) as2 lv)))))        ((pair? x)          (cons (lren0 (car x) as lv)                (lren0 (cdr x) as lv)))        ((vector? x)          (mapv (lambda (x) (lren0 x as lv)) x))        ((and lv (asss x as))          (cdr (asss x as)))        (else x)))");
        AUX_S2.exec("(define (makeasc x)  (cond ((null? x) '())        (else (cons (cons (caar x) (gensym))                    (makeasc (cdr x))))))");
        AUX_S2.exec("(define (makeascl x)  (cond ((null? x) '())        (else (cons (cons (car x) (gensym))                    (makeascl (cdr x))))))");
        AUX_S2.exec("(define (chlet x a0 as lv)  (cons (car x)        (cons (map (lambda (x)                     (cons (asssif (car x) as)                           (lren0 (cdr x) a0 lv)))                   (cadr x))              (lren0 (cddr x) as lv))))");
        AUX_S2.exec("(define (chlet*-aux x a0 lv)  (cond ((null? x) '())        (else          (cons            (cons (remvscp (caar x))                  (lren0 (cdar x) a0 lv))            (chlet*-aux              (cdr x)              (cons                (cons (caar x) (remvscp (caar x)))                a0)              lv)))))");
        AUX_S2.exec("(define (chlet* x a0 as lv)  (cons (car x)        (cons (chlet*-aux (cadr x) a0 lv)              (lren0 (cddr x) as lv))))");
        AUX_S2.exec("(define (chletn x a0 as lv)  (cons (car x)        (cons (asssif (cadr x) as)              (cons (map (lambda (x)                          (cons (asssif (car x) as)                                (lren0                                 (cdr x) a0 lv)))                         (caddr x))                    (lren0 (cdddr x) as lv)))))");
        AUX_S2.exec("(define (asssif x as)  (if (asss x as) (cdr (asss x as)) x))");
    }

    PatternMatch() {
    }

    private static boolean isEllipsis(Datum d) {
        if (d instanceof SymbolName) {
            Symbol smb = ((SymbolName)((Object)d)).getSymbol();
            return ELLIPSIS.equals(smb);
        }
        return false;
    }

    private static Datum chkRest(Datum c2x, PatternDepthMap mp, int typ, Set<Symbol> st, Set<Symbol> reserve) throws PatternEllipsisException {
        Cons res;
        Datum c2z = c2x;
        Cons rp = res = null;
        while (c2z instanceof Cons) {
            Datum c2a = ((Cons)c2z).getCar();
            Cons rx = new Cons();
            if (rp == null) {
                res = rx;
            } else {
                rp.setCdr(rx);
            }
            rp = rx;
            if (ELLIPSIS.equals(c2a)) {
                throw new LispException("bad ellipsis");
            }
            rp.setCar(PatternMatch.compilePattern1(c2a, mp, typ, st, reserve));
            c2z = ((Cons)c2z).getCdr();
        }
        if (c2z instanceof Symbol) {
            st.add((Symbol)c2z);
        }
        rp.setCdr(c2z);
        return res;
    }

    private static Datum chkRestVec(List<Datum> v2x, PatternDepthMap mp, int typ, Set<Symbol> st, Set<Symbol> reserve) throws PatternEllipsisException {
        ArrayList<Datum> res = new ArrayList<Datum>();
        for (Datum v2a : v2x) {
            if (PatternMatch.isEllipsis(v2a)) {
                throw new LispException("bad ellipsis");
            }
            res.add(PatternMatch.compilePattern1(v2a, mp, typ, st, reserve));
        }
        return LispUtils.listToCons(res);
    }

    private static Datum compilePattern1(Datum src, PatternDepthMap mp, int typ, Set<Symbol> st, Set<Symbol> reserve) throws PatternEllipsisException {
        Datum res;
        block30: {
            Datum d = src;
            res = null;
            Cons rp = null;
            while (d instanceof Cons) {
                Cons c2;
                Cons c = (Cons)d;
                Cons n = new Cons();
                if (PatternMatch.isEllipsis(c.getCar())) {
                    throw new PatternEllipsisException();
                }
                Datum car = PatternMatch.compilePattern1(c.getCar(), mp, typ, st, reserve);
                if (c.getCdr() instanceof Cons && PatternMatch.isEllipsis((c2 = (Cons)c.getCdr()).getCar())) {
                    PatternIntEllipsis n2;
                    if (c.getCar() instanceof Symbol && reserve.contains((Symbol)c.getCar())) {
                        throw new PatternEllipsisException();
                    }
                    if (typ == 0) {
                        if (c2.getCdr() instanceof Cons) {
                            Datum xa = PatternMatch.chkRest(c2.getCdr(), mp, typ, st, reserve);
                            n2 = new PatternIntEllipsis(car, xa);
                        } else {
                            if (c2.getCdr() instanceof Symbol) {
                                st.add((Symbol)c2.getCdr());
                            }
                            n2 = new PatternIntEllipsis(car, c2.getCdr());
                        }
                    } else if (typ == 1) {
                        Datum cdr2 = PatternMatch.compilePattern1(c2.getCdr(), mp, typ, st, reserve);
                        n2 = new PatternIntEllipsis(car, cdr2);
                    } else {
                        throw new RuntimeException();
                    }
                    if (rp == null) {
                        res = n2;
                    } else {
                        rp.setCdr(n2);
                    }
                    break block30;
                }
                n.setCar(car);
                if (rp == null) {
                    rp = n;
                    res = rp;
                } else {
                    rp.setCdr(n);
                    rp = n;
                }
                d = c.getCdr();
            }
            if (d instanceof LispVector) {
                LispVector v = (LispVector)d;
                ArrayList<Datum> rv = new ArrayList<Datum>();
                int i = 0;
                while (i < v.size()) {
                    Datum v1 = PatternMatch.compilePattern1(v.get(i), mp, typ, st, reserve);
                    if (i < v.size() - 1 && PatternMatch.isEllipsis(v.get(i + 1))) {
                        if (v.get(i) instanceof Symbol && reserve.contains((Symbol)v.get(i))) {
                            throw new PatternEllipsisException(((Symbol)v.get(i)).getName());
                        }
                        if (typ == 0) {
                            List<Datum> vv = v.getList().subList(i + 2, v.size());
                            Datum vr = PatternMatch.chkRestVec(vv, mp, typ, st, reserve);
                            rv.add(new PatternIntEllipsis(v1, vr, true));
                        } else if (typ == 1) {
                            rv.add(new PatternIntEllipsis(v1, Nil.NIL, true));
                        } else {
                            throw new RuntimeException();
                        }
                        ++i;
                    } else {
                        rv.add(v1);
                    }
                    ++i;
                }
                res = new LispVector(rv);
            } else {
                if (d instanceof Symbol) {
                    st.add((Symbol)d);
                } else if (d instanceof SymbolScope) {
                    SymbolScope ssp = (SymbolScope)d;
                    st.add(ssp.getSymbol());
                }
                if (rp == null) {
                    res = d;
                } else {
                    rp.setCdr(d);
                }
            }
        }
        return res;
    }

    public static Datum compilePattern(Datum d, PatternDepthMap mp, Set<Symbol> st, Set<Symbol> reserve) throws PatternEllipsisException {
        return PatternMatch.compilePattern1(d, mp, 0, st, reserve);
    }

    public static Datum compileTemplate(Datum d, PatternDepthMap mp) {
        Set<Symbol> sz = NullSet.getInstance();
        Set<Symbol> em = Collections.emptySet();
        try {
            return PatternMatch.compilePattern1(d, mp, 1, sz, em);
        }
        catch (PatternEllipsisException e) {
            throw new RuntimeException("Internal error");
        }
    }

    private static void searchLevel0(Datum in, int lev, Map<Symbol, Integer> res, Set<Symbol> st) {
        Datum sp = in;
        while (true) {
            if (sp instanceof Cons) {
                Cons spc = (Cons)sp;
                PatternMatch.searchLevel0(spc.getCar(), lev, res, st);
                sp = spc.getCdr();
                continue;
            }
            if (sp instanceof LispVector) {
                LispVector v = (LispVector)sp;
                int i = 0;
                while (i < v.size()) {
                    PatternMatch.searchLevel0(v.get(i), lev, res, st);
                    ++i;
                }
                return;
            }
            if (!(sp instanceof PatternIntEllipsis)) break;
            PatternIntEllipsis si = (PatternIntEllipsis)sp;
            PatternMatch.searchLevel0(si.getEllipsisList(), lev + 1, res, st);
            sp = si.getCdr();
        }
        if (sp instanceof Symbol && st.contains(sp)) {
            Symbol sy = (Symbol)sp;
            res.put(sy, lev);
            return;
        }
    }

    public static void validateLevel(Datum pat, Datum tpl, Set<Symbol> st) throws PatternDepthException {
        HashMap<Symbol, Integer> p0 = new HashMap<Symbol, Integer>();
        HashMap<Symbol, Integer> t0 = new HashMap<Symbol, Integer>();
        PatternMatch.searchLevel0(pat, 0, p0, st);
        PatternMatch.searchLevel0(tpl, 0, t0, st);
        for (Map.Entry d : p0.entrySet()) {
            int ddepth;
            if (!t0.containsKey(d.getKey()) || (ddepth = ((Integer)t0.get(d.getKey())).intValue()) == (Integer)d.getValue()) continue;
            throw new PatternDepthException(((Symbol)d.getKey()).getName());
        }
    }

    private static void collectParam1(Datum src, Set<Symbol> col, Set<Symbol> reserved) {
        Datum sp = src;
        while (true) {
            if (sp instanceof Cons) {
                Cons spc = (Cons)sp;
                PatternMatch.collectParam1(spc.getCar(), col, reserved);
                sp = spc.getCdr();
                continue;
            }
            if (sp instanceof LispVector) {
                LispVector v = (LispVector)sp;
                int i = 0;
                while (i < v.size()) {
                    PatternMatch.collectParam1(v.get(i), col, reserved);
                    ++i;
                }
                return;
            }
            if (!(sp instanceof PatternIntEllipsis)) break;
            PatternIntEllipsis si = (PatternIntEllipsis)sp;
            PatternMatch.collectParam1(si.getEllipsisList(), col, reserved);
            sp = si.getCdr();
        }
        if (sp instanceof SymbolName) {
            Symbol smb = ((SymbolName)((Object)sp)).getSymbol();
            if (!reserved.contains(smb)) {
                col.add(smb);
            }
            return;
        }
    }

    private static Set<Symbol> collectParam1(Datum src, Set<Symbol> reserved) {
        HashSet<Symbol> col = new HashSet<Symbol>();
        PatternMatch.collectParam1(src, col, reserved);
        return col;
    }

    private static boolean match(Datum src, Datum dest, PatternDepthMap mp, PatternDepthIndex index, Set<Symbol> reserved) {
        Datum sp = src;
        Datum dp = dest;
        while (sp instanceof Cons) {
            Cons spc = (Cons)sp;
            if (dp instanceof Cons) {
                Cons dpc = (Cons)dp;
                boolean bl = PatternMatch.match(spc.getCar(), dpc.getCar(), mp, index, reserved);
                if (bl) {
                    sp = spc.getCdr();
                    dp = dpc.getCdr();
                    continue;
                }
                return false;
            }
            return false;
        }
        if (sp instanceof LispVector) {
            LispVector vs = (LispVector)sp;
            if (!(dp instanceof LispVector)) {
                return false;
            }
            LispVector vd = (LispVector)dp;
            int i = 0;
            while (i < vs.size()) {
                Datum dd = vs.get(i);
                if (dd instanceof PatternIntEllipsis) {
                    PatternIntEllipsis si = (PatternIntEllipsis)dd;
                    PatternDepthIndex nind = index.addDepthNew();
                    List<Datum> vv = LispUtils.consToListIgnoreDot(si.getCdr());
                    int j = i;
                    while (j < vd.size() - vv.size()) {
                        boolean mtr = PatternMatch.match(si.getEllipsisList(), vd.get(j), mp, nind, reserved);
                        if (!mtr) {
                            return false;
                        }
                        nind = nind.incNew();
                        ++j;
                    }
                    Set<Symbol> col = PatternMatch.collectParam1(si.getEllipsisList(), reserved);
                    int rep = nind.pop();
                    mp.setRepetaion(col, nind, rep);
                    int k = 0;
                    while (j < vd.size()) {
                        boolean mtr = PatternMatch.match(vv.get(k), vd.get(j), mp, index, reserved);
                        if (!mtr) {
                            return false;
                        }
                        ++j;
                        ++k;
                    }
                    return true;
                }
                if (i >= vd.size()) {
                    return false;
                }
                boolean bl = PatternMatch.match(vs.get(i), vd.get(i), mp, index, reserved);
                if (!bl) {
                    return false;
                }
                ++i;
            }
            return i == vd.size();
        }
        if (sp instanceof PatternIntEllipsis) {
            PatternIntEllipsis si = (PatternIntEllipsis)sp;
            Datum pt = dp;
            PatternDepthIndex nind = index.addDepthNew();
            if (PatternMatch.match(si.getCdr(), pt, mp, index, reserved)) {
                Set<Symbol> col = PatternMatch.collectParam1(si.getEllipsisList(), reserved);
                int rep = nind.pop();
                mp.setRepetaion(col, nind, rep);
                return true;
            }
            while (pt instanceof Cons) {
                Cons ptc = (Cons)pt;
                boolean mtr = PatternMatch.match(si.getEllipsisList(), ptc.getCar(), mp, nind, reserved);
                if (!mtr) {
                    return false;
                }
                pt = ptc.getCdr();
                nind = nind.incNew();
                boolean rx = PatternMatch.match(si.getCdr(), ptc.getCdr(), mp, index, reserved);
                if (!rx) continue;
                Set<Symbol> col = PatternMatch.collectParam1(si.getEllipsisList(), reserved);
                int rep = nind.pop();
                mp.setRepetaion(col, nind, rep);
                return true;
            }
            Set<Symbol> col = PatternMatch.collectParam1(si.getEllipsisList(), reserved);
            int rep = nind.pop();
            mp.setRepetaion(col, nind, rep);
            return PatternMatch.match(si.getCdr(), pt, mp, index, reserved);
        }
        if (sp instanceof Symbol && !reserved.contains(sp)) {
            mp.put((Symbol)sp, index, dp);
            return true;
        }
        if (sp instanceof SymbolScope) {
            SymbolScope ssp = (SymbolScope)sp;
            mp.put(ssp.getSymbol(), index, dp);
            return true;
        }
        if (sp.equals(UNDERBAR)) {
            return true;
        }
        return sp.isEqv(dp);
    }

    public static boolean match(Datum src, Datum dest, PatternDepthMap mp, Set<Symbol> reserved) {
        return PatternMatch.match(src, dest, mp, new PatternDepthIndex(), reserved);
    }

    private static void collectParam2(Datum src, Set<Symbol> col, PatternDepthMap mp) {
        Datum sp = src;
        while (true) {
            if (sp instanceof Cons) {
                Cons spc = (Cons)sp;
                PatternMatch.collectParam2(spc.getCar(), col, mp);
                sp = spc.getCdr();
                continue;
            }
            if (sp instanceof LispVector) {
                LispVector v = (LispVector)sp;
                int i = 0;
                while (i < v.size()) {
                    PatternMatch.collectParam2(v.get(i), col, mp);
                    ++i;
                }
                return;
            }
            if (!(sp instanceof PatternIntEllipsis)) break;
            PatternIntEllipsis si = (PatternIntEllipsis)sp;
            PatternMatch.collectParam2(si.getEllipsisList(), col, mp);
            sp = si.getCdr();
        }
        if (sp instanceof Symbol) {
            if (mp.contains((Symbol)sp)) {
                col.add((Symbol)sp);
            }
            return;
        }
        if (sp instanceof ExWrap) {
            Symbol sy;
            Datum dd = ((ExWrap)sp).getWrapee();
            if (dd instanceof SymbolName && mp.contains(sy = ((SymbolName)((Object)dd)).getSymbol())) {
                col.add(sy);
            }
            return;
        }
    }

    private static Set<Symbol> collectParam2(Datum src, PatternDepthMap mp) {
        HashSet<Symbol> col = new HashSet<Symbol>();
        PatternMatch.collectParam2(src, col, mp);
        return col;
    }

    private static boolean checkEllipsis(Datum d, PatternDepthMap args) {
        if (d instanceof Cons) {
            ConsIterator itr = new ConsIterator(d);
            boolean res = false;
            while (itr.hasNext()) {
                Datum d0 = itr.next();
                boolean bl = res = res || PatternMatch.checkEllipsis(d0, args);
            }
            return res || PatternMatch.checkEllipsis(itr.getTerminal(), args);
        }
        if (d instanceof PatternIntEllipsis) {
            PatternIntEllipsis e0 = (PatternIntEllipsis)d;
            boolean res = PatternMatch.checkEllipsis(e0.getEllipsisList(), args);
            return res && PatternMatch.checkEllipsis(e0.getCdr(), args);
        }
        if (d instanceof SymbolName) {
            return args.contains(((SymbolName)((Object)d)).getSymbol());
        }
        return true;
    }

    private static Datum expand1(Datum templ, PatternDepthMap args, PatternDepthIndex index, UserSyntax usyn, Map<Symbol, Symbol> box, Environment env, int level, Symbol.Namespace nsp, boolean syncase) throws PatternDepthException {
        Datum wpe;
        Datum dt;
        Datum dt2;
        Datum sp = templ;
        ConsListBuilder bld1 = new ConsListBuilder();
        while (sp instanceof Cons) {
            Datum car;
            Cons spc = (Cons)sp;
            Cons n = new Cons();
            if (spc.getCar() instanceof SymbolName) {
                Symbol sy2 = ((SymbolName)((Object)spc.getCar())).getSymbol();
                Datum dd2 = env.findDatum(sy2);
                if (dd2 instanceof SynLetType) {
                    sp = spc.getCdr();
                } else if (dd2 instanceof SynLambda) {
                    sp = spc.getCdr();
                } else if (dd2 instanceof SynSyntaxCase) {
                    sp = level != 0 ? spc.getCdr() : spc.getCdr();
                } else if (dd2 instanceof SynSyntax) {
                    level = -1;
                    sp = spc.getCdr();
                } else if (dd2 instanceof SynQuasisyntax) {
                    level = level == -1 ? -1 : level + 1;
                    sp = spc.getCdr();
                } else if (SynQuasisyntax.UNSYNTAX.equals(sy2)) {
                    level = level > 0 ? level - 1 : level;
                    sp = spc.getCdr();
                } else if (SynQuasisyntax.UNSYNTAX_SPLICING.equals(sy2)) {
                    level = level > 0 ? level - 1 : level;
                    sp = spc.getCdr();
                } else {
                    sp = spc.getCdr();
                }
                car = PatternMatch.expand1(spc.getCar(), args, index, usyn, box, env, level, nsp, syncase);
                bld1.append(car);
                continue;
            }
            car = PatternMatch.expand1(spc.getCar(), args, index, usyn, box, env, level, nsp, syncase);
            if (car == null) {
                return null;
            }
            n.setCar(car);
            bld1.appendCons(n);
            sp = spc.getCdr();
        }
        if (sp instanceof LispVector) {
            LispVector ve = (LispVector)sp;
            ArrayList<Datum> vr = new ArrayList<Datum>();
            int j = 0;
            while (j < ve.size()) {
                Datum dd = ve.get(j);
                if (dd instanceof PatternIntEllipsis) {
                    PatternIntEllipsis si = (PatternIntEllipsis)dd;
                    if (!PatternMatch.checkEllipsis(si.getEllipsisList(), args)) {
                        Datum car = PatternMatch.expand1(si.getEllipsisList(), args, index, usyn, box, env, level, nsp, syncase);
                        vr.add(car);
                        vr.add(ELLIPSIS);
                    }
                    Set<Symbol> params = PatternMatch.collectParam2(si.getEllipsisList(), args);
                    int rep = args.getRepetaion(params, index);
                    index.addDepth();
                    int i = 0;
                    while (i < rep) {
                        Datum rpt = PatternMatch.expand1(si.getEllipsisList(), args, index, usyn, box, env, level, nsp, syncase);
                        if (rpt == null) {
                            int v = index.pop();
                            if (v > 0) break;
                            return null;
                        }
                        vr.add(rpt);
                        ++i;
                        index.inc();
                    }
                    index.pop();
                } else {
                    Datum d3 = PatternMatch.expand1(ve.get(j), args, index, usyn, box, env, level, nsp, syncase);
                    if (d3 == null) {
                        return null;
                    }
                    vr.add(d3);
                }
                ++j;
            }
            return new LispVector(vr);
        }
        if (sp instanceof PatternIntEllipsis) {
            PatternIntEllipsis si = (PatternIntEllipsis)sp;
            ConsListBuilder bld2 = new ConsListBuilder();
            if (!PatternMatch.checkEllipsis(si.getEllipsisList(), args)) {
                Datum ddz = PatternMatch.gtWrap(si.getEllipsisList());
                Datum car = PatternMatch.expand1(ddz, args, index, usyn, box, env, level, nsp, syncase);
                bld2.append(car);
                bld2.append(ELLIPSIS);
                Datum cdr = PatternMatch.expand1(si.getCdr(), args, index, usyn, box, env, level, nsp, syncase);
                return bld1.get(bld2.get(cdr));
            }
            Set<Symbol> params = PatternMatch.collectParam2(si.getEllipsisList(), args);
            int rep = args.getRepetaion(params, index);
            index.addDepth();
            int i = 0;
            while (i < rep) {
                Cons n = new Cons();
                Datum rpt = PatternMatch.expand1(si.getEllipsisList(), args, index, usyn, box, env, level, nsp, syncase);
                if (rpt == null) {
                    int v = index.pop();
                    if (v > 0) break;
                    return null;
                }
                n.setCar(rpt);
                bld2.appendCons(n);
                ++i;
                index.inc();
            }
            index.pop();
            Datum cdr = PatternMatch.expand1(si.getCdr(), args, index, usyn, box, env, level, nsp, syncase);
            if (cdr == null) {
                return null;
            }
            return bld1.get(bld2.get(cdr));
        }
        if (sp instanceof SymbolScope) {
            SymbolScope ssp = (SymbolScope)sp;
            Symbol ss = ssp.getSymbol();
            if (args.contains(ss)) {
                dt2 = args.get(ss, index);
                dt2 = PatternMatch.markReplace(box, dt2, true);
                return bld1.get(dt2);
            }
            return bld1.get(sp);
        }
        if (sp instanceof Symbol) {
            Symbol sy1 = (Symbol)sp;
            if (usyn.getReservedSet().contains(sy1)) {
                return sy1;
            }
            if (args.contains(sy1)) {
                dt = args.get(sy1, index);
                dt = PatternMatch.markReplace(box, dt, true);
                return bld1.get(dt);
            }
            if (sy1.isGenerated()) {
                return bld1.get(sy1);
            }
            if (index.depth() == 0) {
                Symbol s2 = nsp.getSymbol(sy1.getName());
                return bld1.get(syncase ? sy1 : s2);
            }
            IndSym isym = new IndSym(nsp.getSymbol(sy1.getName()), index.copy());
            return bld1.get(isym);
        }
        if (sp instanceof ExWrap) {
            wpe = ((ExWrap)sp).getWrapee();
            if (wpe instanceof SymbolName) {
                Symbol smb = ((SymbolName)((Object)wpe)).getSymbol();
                if (args.contains(smb)) {
                    dt2 = args.get(smb, index);
                    dt2 = PatternMatch.markReplace(box, dt2, true);
                    return bld1.get(dt2);
                }
                if (index.depth() == 0) {
                    Symbol s2 = nsp.getSymbol(smb.getName());
                    return bld1.get(syncase ? smb : s2);
                }
                IndSym isym = new IndSym(nsp.getSymbol(smb.getName()), index.copy());
                return bld1.get(isym);
            }
            return bld1.get(wpe);
        }
        if (sp instanceof IndSym) {
            IndSym ism = (IndSym)sp;
            dt = args.get(ism.getWrapee(), ism.getIndex());
            dt = PatternMatch.markReplace(box, dt, true);
            return bld1.get(dt);
        }
        if (sp instanceof LtWrap) {
            wpe = ((LtWrap)sp).getWrapee();
            return bld1.get(wpe);
        }
        return bld1.get(sp);
    }

    public static Datum expand(Datum templ, PatternDepthMap args, UserSyntax usyn, Map<Symbol, Symbol> box, Environment env, boolean syncase) throws PatternDepthException {
        Datum res = PatternMatch.expand1(templ, args, new PatternDepthIndex(), usyn, box, env, 0, new Symbol.Namespace(), syncase);
        if (res == null) {
            throw new LispException("syntax expansion has failed");
        }
        return res;
    }

    public static Datum appendScope(Datum src, PatternDepthMap args, UserSyntax usyn) {
        Datum sp = src;
        ConsListBuilder bld1 = new ConsListBuilder();
        while (sp instanceof Cons) {
            Cons spc = (Cons)sp;
            Cons app = new Cons();
            app.setCar(PatternMatch.appendScope(spc.getCar(), args, usyn));
            bld1.appendCons(app);
            sp = spc.getCdr();
        }
        if (sp instanceof LispVector) {
            LispVector v = (LispVector)sp;
            ArrayList<Datum> vr = new ArrayList<Datum>();
            int i = 0;
            while (i < v.size()) {
                vr.add(PatternMatch.appendScope(v.get(i), args, usyn));
                ++i;
            }
            return new LispVector(vr);
        }
        if (sp instanceof Symbol) {
            Symbol sy1 = (Symbol)sp;
            if (sy1.isReplaced()) {
                return bld1.get(sy1);
            }
            if (sy1.isGenerated()) {
                return bld1.get(sy1);
            }
            return bld1.get(new SymbolScope(sy1, usyn));
        }
        if (sp instanceof SyntaxUtils.SafeWrap) {
            return ((SyntaxUtils.SafeWrap)((Object)sp)).getWrapee();
        }
        return bld1.get(sp);
    }

    public static Datum appendScopeCase(Datum src, UserSyntax usyn) {
        Datum re0 = AUX_S.call("letren", src);
        Datum re2 = AUX_S2.call("letren", re0);
        Datum res = AUX_S.call("repls", re2, usyn);
        return res;
    }

    public static Datum removeScope(Datum src) {
        Datum sp = src;
        ConsListBuilder bld1 = new ConsListBuilder();
        while (sp instanceof Cons) {
            Cons spc = (Cons)sp;
            Cons app = new Cons();
            app.setCar(PatternMatch.removeScope(spc.getCar()));
            bld1.appendCons(app);
            sp = spc.getCdr();
        }
        if (sp instanceof LispVector) {
            LispVector v = (LispVector)sp;
            ArrayList<Datum> vr = new ArrayList<Datum>();
            int i = 0;
            while (i < v.size()) {
                vr.add(PatternMatch.removeScope(v.get(i)));
                ++i;
            }
            return new LispVector(vr);
        }
        if (sp instanceof SymbolScope) {
            return bld1.get(((SymbolScope)sp).getSymbol());
        }
        return bld1.get(sp);
    }

    public static Datum markReplace(Map<Symbol, Symbol> box, Datum src, boolean mark) {
        Datum sp = src;
        ConsListBuilder bld1 = new ConsListBuilder();
        while (sp instanceof Cons) {
            Cons spc = (Cons)sp;
            Cons app = new Cons();
            app.setCar(PatternMatch.markReplace(box, spc.getCar(), mark));
            bld1.appendCons(app);
            sp = spc.getCdr();
        }
        if (sp instanceof LispVector) {
            LispVector v = (LispVector)sp;
            ArrayList<Datum> vr = new ArrayList<Datum>();
            int i = 0;
            while (i < v.size()) {
                vr.add(PatternMatch.markReplace(box, v.get(i), mark));
                ++i;
            }
            return new LispVector(vr);
        }
        if (sp instanceof Symbol) {
            Symbol mk = Symbol.newAndMark(box, (Symbol)sp, mark);
            return bld1.get(mk);
        }
        return bld1.get(sp);
    }

    public static Datum gtWrap(Datum src) {
        Datum sp = src;
        ConsListBuilder bld1 = new ConsListBuilder();
        while (sp instanceof Cons) {
            Cons spc = (Cons)sp;
            Cons app = new Cons();
            app.setCar(PatternMatch.gtWrap(spc.getCar()));
            bld1.appendCons(app);
            sp = spc.getCdr();
        }
        if (sp instanceof LispVector) {
            LispVector v = (LispVector)sp;
            ArrayList<Datum> vr = new ArrayList<Datum>();
            int i = 0;
            while (i < v.size()) {
                vr.add(PatternMatch.gtWrap(v.get(i)));
                ++i;
            }
            return new LispVector(vr);
        }
        if (sp instanceof Symbol) {
            return bld1.get(new GtWrap((Symbol)sp));
        }
        return bld1.get(sp);
    }

    public static Datum gtUnwrap(Datum src) {
        Datum sp = src;
        ConsListBuilder bld1 = new ConsListBuilder();
        while (sp instanceof Cons) {
            Cons spc = (Cons)sp;
            Cons app = new Cons();
            app.setCar(PatternMatch.gtUnwrap(spc.getCar()));
            bld1.appendCons(app);
            sp = spc.getCdr();
        }
        if (sp instanceof LispVector) {
            LispVector v = (LispVector)sp;
            ArrayList<Datum> vr = new ArrayList<Datum>();
            int i = 0;
            while (i < v.size()) {
                vr.add(PatternMatch.gtUnwrap(v.get(i)));
                ++i;
            }
            return new LispVector(vr);
        }
        if (sp instanceof GtWrap) {
            return bld1.get(((GtWrap)sp).getWrapee());
        }
        if (sp instanceof IndSym) {
            return ((IndSym)sp).wrapee;
        }
        return bld1.get(sp);
    }

    private static class AddLtWrap
    extends UnaryArgs {
        private AddLtWrap() {
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return c1a instanceof LtWrap ? c1a : new LtWrap(c1a);
        }
    }

    private static class AddUSyn
    extends BinaryArgs {
        private AddUSyn() {
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof Symbol)) {
                throw mesg.getError("err.require.symbol");
            }
            if (!(c2a instanceof UserSyntax)) {
                throw mesg.getError("err.require.usersyntax");
            }
            return new SymbolScope((Symbol)c1a, (UserSyntax)c2a);
        }
    }

    private static class EllipsisC
    extends Subr {
        private EllipsisC() {
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            return ELLIPSIS;
        }
    }

    private static class EqWithSyn
    extends BinaryArgs {
        private EqWithSyn() {
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (c1a instanceof SymbolScope && c2a instanceof SymbolScope) {
                SymbolScope s1 = (SymbolScope)c1a;
                SymbolScope s2 = (SymbolScope)c2a;
                return LispBoolean.getInstance(s1.getSymbol().equals(s2.getSymbol()) && s1.isSameScope(s2));
            }
            if (c1a instanceof Symbol && c2a instanceof Symbol) {
                Symbol s1 = (Symbol)c1a;
                Symbol s2 = (Symbol)c2a;
                return LispBoolean.getInstance(s1.equals(s2));
            }
            return LispBoolean.FALSE;
        }
    }

    private static class ExWrap
    extends Datum {
        private Datum wrapee;

        private ExWrap(Datum w) {
            this.wrapee = w;
        }

        public Datum getWrapee() {
            return this.wrapee;
        }

        @Override
        public String toString() {
            return "w(" + this.wrapee + ")";
        }
    }

    private static class GtWrap
    extends Datum
    implements SyntaxUtils.SafeWrap {
        private Datum wrapee;

        private GtWrap(Datum w) {
            this.wrapee = w;
        }

        @Override
        public Datum getWrapee() {
            return this.wrapee;
        }

        @Override
        public String toString() {
            return "g(" + this.wrapee + ")";
        }
    }

    static class IndSym
    extends Datum {
        private Symbol wrapee;
        private PatternDepthIndex index;

        private IndSym(Symbol w, PatternDepthIndex ind) {
            this.wrapee = w;
            this.index = ind;
        }

        public Symbol getWrapee() {
            return this.wrapee;
        }

        public PatternDepthIndex getIndex() {
            return this.index;
        }

        @Override
        public String toString() {
            return this.wrapee + "(" + this.index + ")";
        }
    }

    private static class IsSynCase
    extends UnaryArgs {
        private IsSynCase() {
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof SymbolName) {
                Symbol s = ((SymbolName)((Object)c1a)).getSymbol();
                return LispBoolean.getInstance(SynSyntaxCase.SYNTAX_CASE.equals(s));
            }
            return LispBoolean.FALSE;
        }
    }

    private static class IsSynQQuo
    extends UnaryArgs {
        private IsSynQQuo() {
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof SymbolName) {
                Symbol s = ((SymbolName)((Object)c1a)).getSymbol();
                return LispBoolean.getInstance(SynQuasisyntax.QUASISYNTAX.equals(s));
            }
            return LispBoolean.FALSE;
        }
    }

    private static class IsSynQuot
    extends UnaryArgs {
        private IsSynQuot() {
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof SymbolName) {
                Symbol s = ((SymbolName)((Object)c1a)).getSymbol();
                return LispBoolean.getInstance(SynSyntax.SYNTAX.equals(s));
            }
            return LispBoolean.FALSE;
        }
    }

    private static class IsWithSyn
    extends UnaryArgs {
        private IsWithSyn() {
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof SymbolName) {
                Symbol s = ((SymbolName)((Object)c1a)).getSymbol();
                return LispBoolean.getInstance(SynSyntax.WITH_SYNTAX.equals(s));
            }
            return LispBoolean.FALSE;
        }
    }

    private static class LtWrap
    extends Datum {
        private Datum wrapee;

        private LtWrap(Datum w) {
            this.wrapee = w;
        }

        public Datum getWrapee() {
            return this.wrapee;
        }

        @Override
        public String toString() {
            return "l(" + this.wrapee + ")";
        }
    }

    private static class RmWithSyn
    extends UnaryArgs {
        private RmWithSyn() {
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof SymbolScope) {
                SymbolScope s1 = (SymbolScope)c1a;
                return s1.getSymbol();
            }
            return c1a;
        }
    }
}

