/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.morilib.lang.number.Rational;
import net.morilib.lisp.lite.Cons;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.InputPort;
import net.morilib.lisp.lite.LispBoolean;
import net.morilib.lisp.lite.LispCharacter;
import net.morilib.lisp.lite.LispComplex;
import net.morilib.lisp.lite.LispDouble;
import net.morilib.lisp.lite.LispInteger;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispNumber;
import net.morilib.lisp.lite.LispRational;
import net.morilib.lisp.lite.LispReal;
import net.morilib.lisp.lite.LispString;
import net.morilib.lisp.lite.LispUtils;
import net.morilib.lisp.lite.LispVector;
import net.morilib.lisp.lite.Nil;
import net.morilib.lisp.lite.ReadUnreadable;
import net.morilib.lisp.lite.RegexPattern;
import net.morilib.lisp.lite.Symbol;

public class Parser {
    private static final Datum _VOID = new Datum(){};
    private static final Symbol _DOT = Symbol.getSymbol(".");
    private static final int EOF = -1;
    private static final int I_BIT = 1;
    private static final int L_BIT = 4;
    private LispMessage message;
    private ReadUnreadable rd = null;
    private State state;
    private StringBuilder buf = new StringBuilder();
    private StringBuilder buf2 = new StringBuilder();
    private StringBuilder buf3 = new StringBuilder();
    private StringBuilder[] bufi = new StringBuilder[8];
    private Stack<Datum> resultStack = new Stack();
    private Stack<State> stateStack = new Stack();
    private Stack<Cons> consStack = new Stack();
    private Stack<List<Datum>> vectorStack = new Stack();
    private Stack<Integer> parenStack = new Stack();
    private boolean prefixed = false;
    private Exact exactness = Exact.DEFAULT;
    private int radix = -1;
    private boolean signed = false;
    private boolean readBefore = false;
    private boolean consoleMode;
    private static final Pattern PTN_B0 = Pattern.compile("((\\+|-)?[0-9]+)?((\\+|-)?[0-9]+)");
    private Pattern REGEX_PAT = Pattern.compile("/(.*)/([iuc]*)");

    Parser(LispMessage msg) {
        this.message = msg;
        this.consoleMode = true;
        this.clear();
    }

    Parser(Environment env, LispMessage msg) {
        this.message = msg;
        this.consoleMode = true;
        this.clear();
    }

    Parser(InputPort read, LispMessage msg) {
        this.message = msg;
        this.consoleMode = false;
        this.rd = read;
        this.clear();
    }

    public Parser() {
        this(LispMessage.getInstance());
    }

    public Parser(Locale lc) {
        this(LispMessage.getInstance(lc));
    }

    public Parser(ReadUnreadable rd) {
        this.rd = rd;
    }

    public static List<Datum> readSExpression(Reader rd) throws IOException {
        LispMessage msg = LispMessage.getInstance();
        Parser p = new Parser(new InputPort(rd, msg), msg);
        while (p.parse() && !p.state.equals((Object)State.END_OF_FILE)) {
        }
        return p.getData();
    }

    private void clearBuf() {
        this.buf = new StringBuilder();
        this.buf2 = new StringBuilder();
        this.buf3 = new StringBuilder();
        this.prefixed = false;
        this.exactness = Exact.DEFAULT;
        this.radix = -1;
        this.signed = false;
        Arrays.fill(this.bufi, null);
    }

    private int read() throws IOException {
        int res = this.rd.getc();
        if (res < 0) {
            return -1;
        }
        this.readBefore = true;
        return res;
    }

    private int readNext2() throws IOException {
        int res;
        while ((res = this.rd.getc()) >= 0) {
            this.readBefore = true;
            if (Character.isWhitespace(res)) continue;
            return res;
        }
        return -1;
    }

    private int readNext() throws IOException {
        this.clearBuf();
        return this.readNext2();
    }

    private void appendBuf(int c) {
        this.buf.appendCodePoint(c);
    }

    private void appendBuf2(int c) {
        this.buf2.append((char)c);
        this.buf3.append((char)c);
    }

    private String getToken() {
        String res = this.buf.toString();
        return res;
    }

    private String getToken2() {
        String res = this.buf2.toString();
        return res;
    }

    private static double parseDouble(String str) {
        if ("+inf.0".equals(str)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-inf.0".equals(str)) {
            return Double.NEGATIVE_INFINITY;
        }
        if ("+nan.0".equals(str)) {
            return Double.NaN;
        }
        if ("-nan.0".equals(str)) {
            return Double.NaN;
        }
        return Double.parseDouble(str);
    }

    private static BigInteger getValueByBigInt(String str, int r) {
        return new BigInteger(str.replaceFirst("^\\+", ""), r);
    }

    private boolean isExpsym(int r) {
        return r == 101 || r == 69 || r == 115 || r == 83 || r == 102 || r == 70 || r == 100 || r == 68 || r == 108 || r == 76;
    }

    private boolean isDigit09az(int r) {
        return r >= 48 && r <= 57 || this.radix == 16 && (r >= 65 && r <= 70 || r >= 97 && r <= 102);
    }

    private boolean isDigit09(int r) {
        return r >= 48 && r <= 57;
    }

    private boolean isImaginary(int r) {
        return r == 105 || r == 106 || r == 107 || r == 111;
    }

    private int getImaginaryNo(int r) {
        switch (r) {
            case 105: {
                return 1;
            }
            case 106: {
                return 2;
            }
            case 107: {
                return 3;
            }
            case 111: {
                return 4;
            }
        }
        throw new RuntimeException();
    }

    private static String reverseNumFormat(Exact exactness, int radix) {
        String res = "";
        if (Exact.EXACT.equals((Object)exactness)) {
            res = String.valueOf(res) + "#e";
        } else if (Exact.INEXACT.equals((Object)exactness)) {
            res = String.valueOf(res) + "#i";
        }
        if (radix == 2) {
            res = String.valueOf(res) + "#b";
        } else if (radix == 8) {
            res = String.valueOf(res) + "#o";
        } else if (radix == 10) {
            res = String.valueOf(res) + "#d";
        } else if (radix == 16) {
            res = String.valueOf(res) + "#x";
        }
        return res;
    }

    private String reverseNumFormat() {
        return Parser.reverseNumFormat(this.exactness, this.radix);
    }

    private State symbolNum() {
        if (this.prefixed) {
            throw this.message.getReadError("err.read.format.numeric");
        }
        return State.SYMBOL;
    }

    private State symbol2Num() {
        if (this.prefixed) {
            throw this.message.getReadError("err.read.format.numeric");
        }
        return State.SYMBOL2;
    }

    private State popStateSymbolNum() {
        if (this.prefixed) {
            throw this.message.getReadError("err.read.format.numeric", String.valueOf(this.reverseNumFormat()) + this.getToken() + this.getToken2());
        }
        this.pushMaybeSymbol(this.getSymbol());
        return this.popStateStack();
    }

    private LispNumber getInteger() {
        String str = this.getToken();
        int r = this.radix < 0 ? 10 : this.radix;
        Exact ex = this.exactness;
        this.clearBuf();
        try {
            BigInteger val = Parser.getValueByBigInt(str, r);
            LispReal atom = Exact.INEXACT.equals((Object)ex) ? new LispDouble(val.doubleValue()) : LispInteger.valueOf(val);
            return atom;
        }
        catch (NumberFormatException e) {
            throw this.message.getReadError("err.read.format.numeric", String.valueOf(Parser.reverseNumFormat(ex, this.radix)) + str);
        }
    }

    private static String chopsign(String s) {
        return "+-".indexOf(s.charAt(s.length() - 1)) < 0 ? s : s.substring(0, s.length() - 1);
    }

    public static LispReal parseContinuedFraction(String str, int r, Exact ex) {
        String[] spt = str.split("/");
        Matcher mt0 = PTN_B0.matcher(spt[0]);
        if (!mt0.matches()) {
            throw new RuntimeException();
        }
        String s0 = mt0.group(1);
        String s1 = mt0.group(3);
        Rational b0 = s0 == null || s0.equals("") ? Rational.ZERO : Rational.valueOf(new BigInteger(s0));
        Rational a1 = Rational.valueOf(Parser.getValueByBigInt(s1, r));
        int sg = spt[1].charAt(spt[1].length() - 1) == '+' ? 1 : -1;
        Rational b1 = Rational.valueOf(Parser.getValueByBigInt(Parser.chopsign(spt[1]), r));
        Rational d = b1.invert();
        Rational dh = a1.divide(b1);
        Rational h = b0.add(dh);
        int i = 2;
        while (i < spt.length) {
            Rational b = Rational.valueOf(Parser.getValueByBigInt(Parser.chopsign(spt[i]), r));
            d = b.multiply(sg).add(d).invert();
            dh = dh.multiply(b.multiply(d).subtract(Rational.ONE));
            h = h.add(dh);
            sg = spt[i].charAt(spt[i].length() - 1) == '+' ? 1 : -1;
            ++i;
        }
        return Exact.INEXACT.equals((Object)ex) ? new LispDouble(h.doubleValue()) : LispRational.valueOf(h);
    }

    private static LispReal getSimpleRational(String str, int r, Exact ex, LispMessage message) {
        String[] nd = str.split("/");
        try {
            BigInteger num = Parser.getValueByBigInt(nd[0], r);
            BigInteger den = Parser.getValueByBigInt(nd[1], r);
            if (Exact.INEXACT.equals((Object)ex)) {
                double numd = num.doubleValue();
                double dend = den.doubleValue();
                return new LispDouble(numd / dend);
            }
            return LispRational.newRational(num, den);
        }
        catch (NumberFormatException e) {
            throw message.getReadError("err.read.format.numeric", String.valueOf(Parser.reverseNumFormat(ex, r)) + str);
        }
    }

    private LispReal getRational(String str) {
        int r = this.radix < 0 ? 10 : this.radix;
        Exact ex = this.exactness;
        if (str.indexOf("+/") >= 0 || str.indexOf("-/") >= 0) {
            return Parser.parseContinuedFraction(str, r, ex);
        }
        return Parser.getSimpleRational(str, r, ex, this.message);
    }

    private LispReal getRational() {
        String tok = this.getToken();
        LispReal r = this.getRational(tok);
        this.clearBuf();
        return r;
    }

    private static LispReal computeCycle(String fix, String cyc, int fixd) {
        BigDecimal d1 = new BigDecimal(BigInteger.ONE, -cyc.length());
        d1 = d1.subtract(BigDecimal.ONE);
        BigInteger i1 = new BigInteger(cyc);
        LispReal r1 = LispRational.newRational(i1, d1.toBigInteger());
        BigDecimal d2 = new BigDecimal(BigInteger.ONE, fixd);
        r1 = r1.multiply(LispUtils.bigDecimalToRational(d2));
        BigDecimal d3 = new BigDecimal(fix);
        r1 = r1.add(LispUtils.bigDecimalToRational(d3));
        return r1;
    }

    private static LispReal getCycle(String str) {
        int p = str.indexOf(46);
        int l = str.indexOf(123);
        String cyc = str.substring(l + 1);
        cyc = cyc.replaceAll("}", "");
        str = String.valueOf(str.substring(0, l)) + "0";
        return Parser.computeCycle(str, cyc, l - p - 1);
    }

    private static String findLastLongestRepeat(CharSequence c) {
        int len = c.length() - 1;
        int max = c.length() / 2;
        char[] cs = new char[max];
        int i = max;
        while (i > 0) {
            block4: {
                int j = 0;
                while (j < i) {
                    if (c.charAt(len - j) == c.charAt(len - j - i)) {
                        cs[max - j - 1] = c.charAt(len - j);
                        ++j;
                        continue;
                    }
                    break block4;
                }
                String s = new String(cs, max - i, i);
                String t = Parser.findLastLongestRepeat(s);
                if (t == null) {
                    return s;
                }
                return t;
            }
            --i;
        }
        return null;
    }

    private LispReal getEllipseN(String str) {
        String fix;
        String s = str.substring(0, str.length() - 1);
        String cyc = Parser.findLastLongestRepeat(s);
        if (cyc != null) {
            fix = s.replaceAll(cyc, "");
        } else {
            cyc = s.substring(s.length() - 1);
            fix = s.substring(0, s.length() - 1);
        }
        return Parser.computeCycle(String.valueOf(fix) + "0", cyc, fix.length() - str.indexOf(46) - 1);
    }

    private LispReal getDouble(String str) {
        int r = this.radix < 0 ? 10 : this.radix;
        Exact ex = this.exactness;
        if (r != 10) {
            throw this.message.getReadError("err.read.notsupported.radix10", String.valueOf(Parser.reverseNumFormat(ex, r)) + str);
        }
        if (str.contains("{")) {
            return Exact.INEXACT.equals((Object)ex) ? Parser.getCycle(str).toInexact() : Parser.getCycle(str);
        }
        if (str.endsWith(".")) {
            return Exact.INEXACT.equals((Object)ex) ? this.getEllipseN(str).toInexact() : this.getEllipseN(str);
        }
        if (Exact.EXACT.equals((Object)ex)) {
            return LispUtils.bigDecimalToRational(new BigDecimal(str));
        }
        if ("+inf.0".equals(str)) {
            return LispDouble.POSITIVE_INFINITY;
        }
        if ("-inf.0".equals(str)) {
            return LispDouble.NEGATIVE_INFINITY;
        }
        if ("+nan.0".equals(str)) {
            return LispDouble.NaN;
        }
        if ("-nan.0".equals(str)) {
            return LispDouble.NaN;
        }
        if (str.indexOf(100) >= 0) {
            return new LispDouble(Parser.parseDouble(str.replace('d', 'e')));
        }
        if (str.indexOf(108) >= 0) {
            return new LispDouble(Parser.parseDouble(str.replace('l', 'e')));
        }
        return new LispDouble(Parser.parseDouble(str));
    }

    private LispReal getDouble() {
        LispReal n = this.getDouble(this.getToken());
        this.clearBuf();
        return n;
    }

    private LispNumber getImaginary(int imgn) {
        LispReal im;
        String gtok1 = this.getToken();
        int rx = this.radix < 0 ? 10 : this.radix;
        Exact ex = this.exactness;
        String iii = gtok1.replaceFirst("[ijko][ijk]?$", "");
        this.clearBuf();
        if (rx > 0 && rx != 10) {
            throw this.message.getReadError("err.read.notsupported.radix10", String.valueOf(Parser.reverseNumFormat(ex, rx)) + gtok1);
        }
        if ("+".equals(iii)) {
            im = !Exact.INEXACT.equals((Object)ex) ? LispInteger.ONE : new LispDouble(1.0);
        } else if ("-".equals(iii)) {
            im = !Exact.INEXACT.equals((Object)ex) ? LispInteger.ONE.uminus() : new LispDouble(-1.0);
        } else if (iii.indexOf(47) >= 0) {
            im = this.getRational(iii);
        } else if (!Exact.INEXACT.equals((Object)ex) && iii.matches("^[-+]?[0-9]+$")) {
            iii = iii.replaceFirst("^\\+", "");
            im = LispInteger.valueOf(Parser.getValueByBigInt(iii, rx));
        } else {
            im = this.getDouble(iii);
        }
        switch (imgn) {
            case 1: {
                return LispComplex.newComplex(LispInteger.ZERO, im);
            }
        }
        throw new RuntimeException("" + imgn);
    }

    private LispNumber getComplex() {
        String gtok1 = this.getToken();
        int rx = this.radix < 0 ? 10 : this.radix;
        Exact ex = this.exactness;
        LispReal[] im = new LispReal[8];
        if (rx > 0 && rx != 10) {
            throw this.message.getReadError("err.read.notsupported.radix10");
        }
        LispReal re = gtok1.indexOf(47) >= 0 ? this.getRational(gtok1) : (!Exact.INEXACT.equals((Object)ex) && gtok1.matches("^[-+]?[0-9]+$") ? LispInteger.valueOf(Parser.getValueByBigInt(gtok1, rx)) : this.getDouble(gtok1));
        int i = 1;
        while (i < 2) {
            if (this.bufi[i] == null) {
                im[i] = LispInteger.ZERO;
            } else {
                String iii = this.bufi[i].toString().replaceFirst("[ijko][ijk]?$", "");
                if ("+".equals(iii)) {
                    im[i] = !Exact.INEXACT.equals((Object)ex) ? LispInteger.ONE : new LispDouble(1.0);
                } else if ("-".equals(iii)) {
                    im[i] = !Exact.INEXACT.equals((Object)ex) ? LispInteger.ONE.uminus() : new LispDouble(-1.0);
                } else if (iii.indexOf(47) >= 0) {
                    im[i] = this.getRational(iii);
                } else if (!Exact.INEXACT.equals((Object)ex) && iii.matches("^[-+]?[0-9]+$")) {
                    iii = iii.replaceFirst("^\\+", "");
                    im[i] = LispInteger.valueOf(Parser.getValueByBigInt(iii, rx));
                } else {
                    im[i] = this.getDouble(iii);
                }
            }
            ++i;
        }
        this.clearBuf();
        return LispComplex.newComplex(re, im[1]);
    }

    private LispNumber getPolar() {
        String str = this.getToken();
        int rx = this.radix < 0 ? 10 : this.radix;
        Exact ex = this.exactness;
        this.clearBuf();
        if (rx > 0 && rx != 10) {
            throw this.message.getReadError("err.read.notsupported.radix10", String.valueOf(Parser.reverseNumFormat(ex, rx)) + str);
        }
        String[] ra = str.split("@");
        LispReal r = LispNumber.parse(ra[0], rx).getReal();
        LispReal a = LispNumber.parse(ra[1], rx).getReal();
        return LispComplex.newPolar(r.getRealDouble(), a.getRealDouble());
    }

    private Datum getRegex() {
        String tok = this.getToken();
        Matcher mch = this.REGEX_PAT.matcher(tok);
        mch.find();
        String re = mch.group(1);
        String fl = mch.group(2);
        try {
            return new RegexPattern(re, fl);
        }
        catch (PatternSyntaxException e) {
            throw this.message.getReadError("err.read.regex.syntax", re);
        }
    }

    private void pushResult(Datum d) {
        this.resultStack.push(d);
    }

    private void pushMaybeSymbol(Datum sym) {
        this.pushResult(sym);
    }

    private int getByCharCode(String str) {
        try {
            int c = Integer.parseInt(str, 16);
            if (c < 0 || c > 0x10FFFF) {
                throw this.message.getReadError("err.read.character.code", str);
            }
            if (Character.isHighSurrogate((char)c) || Character.isLowSurrogate((char)c)) {
                throw this.message.getReadError("err.read.character.code", str);
            }
            return c;
        }
        catch (NumberFormatException e) {
            throw this.message.getReadError("err.read.character.code", str);
        }
    }

    private LispCharacter getCharacter() {
        String str = this.getToken();
        this.clearBuf();
        if (str.length() <= 0) {
            throw this.message.getReadError("err.read.character.unknown", str);
        }
        if (str.length() == 1) {
            return new LispCharacter(str.charAt(0));
        }
        if (str.charAt(0) == 'u' || str.charAt(0) == 'x' || str.charAt(0) == 'U' || str.charAt(0) == 'X') {
            return LispCharacter.valueOf(this.getByCharCode(str.substring(1)));
        }
        LispCharacter r = LispCharacter.getByName(str);
        if (r == null) {
            throw this.message.getReadError("err.read.character.unknown", str);
        }
        return r;
    }

    private LispString getString() {
        String str = this.getToken();
        this.clearBuf();
        return new LispString(str);
    }

    private Datum getSymbol() {
        String str = String.valueOf(this.getToken()) + this.buf3.toString();
        this.clearBuf();
        if ("+nan.0".equals(str)) {
            return LispDouble.NaN;
        }
        return Symbol.getSymbol(str);
    }

    private Symbol getQuote() {
        String str = this.getToken();
        this.clearBuf();
        if ("'".equals(str)) {
            return Symbol.QUOTE;
        }
        if ("`".equals(str)) {
            return Symbol.QUASIQUOTE;
        }
        if (",".equals(str)) {
            return Symbol.UNQUOTE;
        }
        if (",@".equals(str)) {
            return Symbol.UNQUOTE_SPLICING;
        }
        throw new RuntimeException("unknown quote:" + str);
    }

    private State popStateStack() {
        State poped;
        while (true) {
            Datum dd;
            if (this.stateStack.empty()) {
                return State.INIT;
            }
            poped = this.stateStack.pop();
            if (State.QUOTE.equals((Object)poped)) {
                Datum c31 = this.resultStack.pop();
                Cons c32 = this.consStack.pop();
                if (c31 == _VOID) {
                    this.stateStack.push(poped);
                    this.consStack.push(c32);
                    return State.INIT;
                }
                c32.setCar(c31);
                continue;
            }
            if (State.S_EXP_COMMENT.equals((Object)poped)) {
                dd = this.resultStack.pop();
                if (_DOT.equals(dd)) {
                    throw this.message.getReadError("err.read.dot");
                }
                this.pushResult(_VOID);
                continue;
            }
            if (State.S_EXP_MACRO.equals((Object)poped)) {
                dd = this.resultStack.pop();
                Datum mt = this.resultStack.pop();
                Datum sy = this.resultStack.pop();
                Datum aa = LispUtils.list(sy, mt, LispUtils.list(Symbol.getSymbol("quote"), dd));
                while (this.stateStack.peek().equals((Object)State.QUOTE)) {
                    Datum c31 = this.resultStack.pop();
                    Cons c32 = this.consStack.pop();
                    this.stateStack.pop();
                    if (c31 != _VOID) continue;
                    this.stateStack.push(poped);
                    this.consStack.push(c32);
                    return State.INIT;
                }
                this.pushResult(aa);
                continue;
            }
            if (!State.S_EXP_QUOTE.equals((Object)poped)) break;
            dd = this.resultStack.pop();
            Datum sy = this.resultStack.pop();
            Cons re = new Cons(sy, new Cons(dd, Nil.NIL));
            this.pushResult(re);
        }
        return poped;
    }

    private void checkParenthesis(int r) {
        int p = this.parenStack.pop();
        if (!(p == 40 && r == 41 || p == 91 && r == 93 || p == 123 && r == 125 || p == 60 && r == 62)) {
            throw this.message.getReadError("err.read.parenthesis.mismatch");
        }
    }

    private boolean parenthesis(int r) {
        int p;
        int n = p = this.parenStack.isEmpty() ? -1 : this.parenStack.peek();
        return r == 41 || r == 93 || p == 123 && r == 125 || p == 60 && r == 62;
    }

    private void processHashBang(String s) {
        if (s.equals("r6rs")) {
            this.message.warn("warn.r6rs.notsupport");
        } else if (!s.equals("schluessel")) {
            if (s.equals("no-fold-case")) {
                Symbol.foldCase = 0;
            } else if (s.equals("fold-case")) {
                Symbol.foldCase = 2;
            } else if (s.equals("upper-fold-case")) {
                Symbol.foldCase = 1;
            } else if (s.equals("lower-fold-case")) {
                Symbol.foldCase = 2;
            } else {
                this.message.warn("warn.unknown.hashbang");
            }
        }
    }

    public boolean readParse(String exp) throws IOException {
        this.read(exp);
        return this.parse();
    }

    public void read(String read) throws IOException {
        if (this.rd != null) {
            this.rd.close();
        }
        this.rd = new InputPort(new StringReader(read), this.message);
    }

    public Datum getDatum() {
        while (!this.resultStack.empty() && this.resultStack.get(0) == _VOID) {
            this.resultStack.remove(0);
        }
        if (this.stateStack.empty() && !this.resultStack.empty()) {
            return (Datum)this.resultStack.get(0);
        }
        return null;
    }

    public List<Datum> getData() {
        return Collections.unmodifiableList(this.resultStack);
    }

    public boolean isReadBefore() {
        return this.readBefore;
    }

    private boolean isStackOK() {
        return this.stateStack.empty() || this.stateStack.size() == 1 && this.stateStack.peek().equals((Object)State.INIT);
    }

    public void clear() {
        this.resultStack.clear();
        this.stateStack.clear();
        this.consStack.clear();
        this.clearBuf();
        this.stateStack.push(State.INIT);
        this.state = State.INIT;
        this.readBefore = false;
    }

    public boolean isEOF() {
        return this.state != null && this.state.equals((Object)State.END_OF_FILE);
    }

    public boolean parse() throws IOException {
        int r;
        int reg0 = 0;
        if (this.rd == null) {
            throw new IllegalStateException();
        }
        if (this.stateStack.empty() && State.INIT.equals((Object)this.state)) {
            this.stateStack.push(State.INIT);
        }
        if (State.STRING.equals((Object)this.state) || State.STRING_NEWLINE.equals((Object)this.state) || State.STRING_NEWLINE2.equals((Object)this.state)) {
            r = this.read();
        } else {
            this.readBefore = false;
            r = this.readNext();
        }
        block95: while (true) {
            if (!this.consoleMode && this.readBefore && this.stateStack.empty()) {
                if (r >= 0) {
                    this.rd.unread((char)r);
                }
                return true;
            }
            switch (this.state) {
                case INIT: {
                    if (r == 40 || r == 91) {
                        this.parenStack.push(r);
                        this.state = State.LIST;
                        r = this.readNext();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        throw this.message.getReadError("err.read.closeparenthesis");
                    }
                    if (r == 39 || r == 96 || r == 44) {
                        this.appendBuf(r);
                        this.state = State.QUOTE;
                        r = this.readNext2();
                        continue block95;
                    }
                    if (r == 45 || r == 43) {
                        this.appendBuf(r);
                        this.state = State.HEAD_SIGN;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 34) {
                        this.state = State.STRING;
                        r = this.read();
                        continue block95;
                    }
                    if (this.isDigit09(r)) {
                        this.appendBuf(r);
                        this.state = State.NUMBER;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 35) {
                        this.state = State.SHARP_SYNTAX_I;
                        r = this.read();
                        continue block95;
                    }
                    if (r == -1) {
                        this.state = State.END_OF_FILE;
                        return this.isStackOK();
                    }
                    if (r == 46) {
                        this.appendBuf(r);
                        this.state = State.FLOAT_NUMBER;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 59) {
                        this.stateStack.push(this.state);
                        this.state = State.COMMENT;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 124) {
                        this.state = State.SYMBOLQUOTE;
                        r = this.read();
                        continue block95;
                    }
                    this.appendBuf(r);
                    this.state = State.SYMBOL;
                    r = this.read();
                    continue block95;
                }
                case NUMBER_PREFIX: {
                    if (r == -1) {
                        throw this.message.getReadError("err.read.sharp.unknown");
                    }
                    if (r == 35) {
                        r = this.read();
                        if (r == 101 || r == 69) {
                            if (!Exact.DEFAULT.equals((Object)this.exactness)) {
                                throw this.message.getReadError("err.read.numberprefix");
                            }
                            this.exactness = Exact.EXACT;
                            this.state = State.NUMBER_PREFIX;
                        } else if (r == 105 || r == 73) {
                            if (!Exact.DEFAULT.equals((Object)this.exactness)) {
                                throw this.message.getReadError("err.read.numberprefix");
                            }
                            this.exactness = Exact.INEXACT;
                            this.state = State.NUMBER_PREFIX;
                        } else if (r == 98 || r == 66) {
                            if (this.radix > 0) {
                                throw this.message.getReadError("err.read.numberprefix");
                            }
                            this.radix = 2;
                            this.state = State.NUMBER_PREFIX;
                        } else if (r == 111 || r == 79) {
                            if (this.radix > 0) {
                                throw this.message.getReadError("err.read.numberprefix");
                            }
                            this.radix = 8;
                            this.state = State.NUMBER_PREFIX;
                        } else if (r == 100 || r == 68) {
                            if (this.radix > 0) {
                                throw this.message.getReadError("err.read.numberprefix");
                            }
                            this.radix = 10;
                            this.state = State.NUMBER_PREFIX;
                        } else if (r == 120 || r == 88) {
                            if (this.radix > 0) {
                                throw this.message.getReadError("err.read.numberprefix");
                            }
                            this.radix = 16;
                            this.state = State.NUMBER_PREFIX;
                        }
                        r = this.read();
                        continue block95;
                    }
                    if (r == 45 || r == 43) {
                        this.appendBuf(r);
                        this.state = State.HEAD_SIGN;
                        r = this.read();
                        continue block95;
                    }
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        this.state = State.NUMBER;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 46) {
                        this.appendBuf(r);
                        this.state = State.FLOAT_NUMBER;
                        r = this.read();
                        continue block95;
                    }
                    if (this.isImaginary(r)) {
                        this.appendBuf(r);
                        this.state = State.COMPLEX_I;
                        r = this.read();
                        continue block95;
                    }
                    throw this.message.getReadError("err.read.numberprefix");
                }
                case HEAD_SIGN: {
                    this.signed = true;
                    if (this.isDigit09az(r)) {
                        this.state = State.NUMBER;
                        continue block95;
                    }
                    if (r == 46) {
                        this.appendBuf(r);
                        this.state = State.FLOAT_NUMBER;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 105) {
                        this.appendBuf(r);
                        this.state = State.INF_I;
                        r = this.read();
                        continue block95;
                    }
                    if (this.isImaginary(r)) {
                        this.appendBuf(r);
                        this.state = State.COMPLEX_I;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case NUMBER: {
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        r = this.read();
                        continue block95;
                    }
                    if (r == 46) {
                        this.appendBuf(r);
                        this.state = State.FLOAT_NUMBER;
                        r = this.read();
                        continue block95;
                    }
                    if (this.isExpsym(r)) {
                        this.state = State.FLOAT_NUMBER_E;
                        if (r == 100) {
                            r = this.read();
                            if (r == 102 || r == 70) {
                                this.appendBuf(35);
                                r = this.read();
                                continue block95;
                            }
                            if (r == 100 || r == 68) {
                                this.appendBuf(38);
                                r = this.read();
                                continue block95;
                            }
                            this.appendBuf(100);
                            continue block95;
                        }
                        this.appendBuf(Character.toLowerCase(r));
                        r = this.read();
                        continue block95;
                    }
                    if (r == 40 || r == 91 || r == 91) {
                        this.pushResult(this.getInteger());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.pushResult(this.getInteger());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.pushResult(this.getInteger());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 59) {
                        this.pushResult(this.getInteger());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (r == -1) {
                        this.pushResult(this.getInteger());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 47) {
                        this.appendBuf(r);
                        this.state = State.RATIONAL_NUMBER;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 43 || r == 45) {
                        this.appendBuf2(r);
                        this.state = State.HEAD_SIGN_COMPLEX;
                        r = this.read();
                        continue block95;
                    }
                    if (this.isImaginary(r)) {
                        this.appendBuf(r);
                        this.state = State.COMPLEX_I;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 64) {
                        this.appendBuf(r);
                        this.state = State.INIT_POLAR;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case FLOAT_NUMBER: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (this.isDigit09az(r)) {
                        this.state = State.FLOAT_NUMBER_D;
                        continue block95;
                    }
                    if (r == 123) {
                        this.appendBuf(r);
                        r = this.read();
                        this.state = State.FLOAT_NUMBER_CYCLE;
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case FLOAT_NUMBER_D: {
                    if (r == -1) {
                        this.pushResult(this.getDouble());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.pushResult(this.getDouble());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.pushResult(this.getDouble());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (r == 59) {
                        this.pushResult(this.getDouble());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.pushResult(this.getDouble());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        r = this.read();
                        continue block95;
                    }
                    if (this.isExpsym(r)) {
                        this.state = State.FLOAT_NUMBER_E;
                        if (r == 100) {
                            r = this.read();
                            if (r == 102 || r == 70) {
                                this.appendBuf(35);
                                r = this.read();
                                continue block95;
                            }
                            if (r == 100 || r == 68) {
                                this.appendBuf(38);
                                r = this.read();
                                continue block95;
                            }
                            this.appendBuf(100);
                            continue block95;
                        }
                        this.appendBuf(Character.toLowerCase(r));
                        r = this.read();
                        continue block95;
                    }
                    if (r == 43 || r == 45) {
                        this.appendBuf2(r);
                        this.state = State.HEAD_SIGN_COMPLEX;
                        r = this.read();
                        continue block95;
                    }
                    if (this.isImaginary(r)) {
                        this.appendBuf(r);
                        this.state = State.COMPLEX_I;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 64) {
                        this.appendBuf(r);
                        this.state = State.INIT_POLAR;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 123) {
                        this.appendBuf(r);
                        r = this.read();
                        this.state = State.FLOAT_NUMBER_CYCLE;
                        continue block95;
                    }
                    if (r == 46) {
                        this.appendBuf(r);
                        r = this.read();
                        this.state = State.FLOAT_NUMBER_ELLIPSE1;
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case FLOAT_NUMBER_CYCLE: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91 || this.parenthesis(r) || r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        r = this.read();
                        continue block95;
                    }
                    if (r == 125) {
                        this.appendBuf(r);
                        this.pushResult(this.getDouble());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case FLOAT_NUMBER_ELLIPSE1: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91 || this.parenthesis(r) || r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 46) {
                        r = this.read();
                        this.state = State.FLOAT_NUMBER_ELLIPSE2;
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case FLOAT_NUMBER_ELLIPSE2: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91 || this.parenthesis(r) || r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 46) {
                        this.pushResult(this.getDouble());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case FLOAT_NUMBER_E: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 43 || r == 45) {
                        this.appendBuf(r);
                        this.state = State.FLOAT_NUMBER_E_SIGN;
                        r = this.read();
                        continue block95;
                    }
                    if (this.isDigit09az(r)) {
                        this.state = State.FLOAT_NUMBER_E_D;
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case FLOAT_NUMBER_E_SIGN: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (this.isDigit09az(r)) {
                        this.state = State.FLOAT_NUMBER_E_D;
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case FLOAT_NUMBER_E_D: {
                    if (r == -1) {
                        this.pushResult(this.getDouble());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.pushResult(this.getDouble());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.pushResult(this.getDouble());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (r == 59) {
                        this.pushResult(this.getDouble());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.pushResult(this.getDouble());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        r = this.read();
                        continue block95;
                    }
                    if (r == 43 || r == 45) {
                        this.appendBuf2(r);
                        this.state = State.HEAD_SIGN_COMPLEX;
                        r = this.read();
                        continue block95;
                    }
                    if (this.isImaginary(r)) {
                        this.appendBuf(r);
                        this.state = State.COMPLEX_I;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 64) {
                        this.appendBuf(r);
                        this.state = State.INIT_POLAR;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case RATIONAL_NUMBER: {
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        r = this.read();
                        this.state = State.RATIONAL_NUMBER_2;
                        continue block95;
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case RATIONAL_NUMBER_2: {
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        r = this.read();
                        continue block95;
                    }
                    if (r == 40 || r == 91) {
                        this.pushResult(this.getRational());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.pushResult(this.getRational());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (r == 59) {
                        this.pushResult(this.getRational());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.pushResult(this.getRational());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == -1) {
                        this.pushResult(this.getRational());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 43 || r == 45) {
                        reg0 = r;
                        this.state = State.CONTINUED_FRACTION;
                        r = this.read();
                        continue block95;
                    }
                    if (this.isImaginary(r)) {
                        this.appendBuf(r);
                        this.state = State.COMPLEX_I;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 64) {
                        this.appendBuf(r);
                        this.state = State.INIT_POLAR;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case CONTINUED_FRACTION: {
                    if (r == 47) {
                        this.appendBuf(reg0);
                        this.appendBuf(r);
                        this.state = State.RATIONAL_NUMBER;
                        r = this.read();
                        continue block95;
                    }
                    this.appendBuf2(reg0);
                    this.state = State.HEAD_SIGN_COMPLEX;
                    continue block95;
                }
                case INIT_POLAR: {
                    if (r == 45 || r == 43) {
                        this.appendBuf(r);
                        this.state = State.HEAD_SIGN_POLAR;
                        r = this.read();
                        continue block95;
                    }
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        this.state = State.NUMBER_POLAR;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 46) {
                        this.appendBuf(r);
                        this.state = State.FLOAT_NUMBER_POLAR;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case HEAD_SIGN_POLAR: {
                    if (this.isDigit09az(r)) {
                        this.state = State.NUMBER_POLAR;
                        continue block95;
                    }
                    if (r == 46) {
                        this.appendBuf(r);
                        this.state = State.FLOAT_NUMBER_POLAR;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case NUMBER_POLAR: {
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        r = this.read();
                        continue block95;
                    }
                    if (r == 46) {
                        this.appendBuf(r);
                        this.state = State.FLOAT_NUMBER_POLAR;
                        r = this.read();
                        continue block95;
                    }
                    if (this.isExpsym(r)) {
                        this.state = State.FLOAT_NUMBER_E_POLAR;
                        if (r == 100) {
                            r = this.read();
                            if (r == 102 || r == 70) {
                                this.appendBuf(35);
                                r = this.read();
                                continue block95;
                            }
                            if (r == 100 || r == 68) {
                                this.appendBuf(38);
                                r = this.read();
                                continue block95;
                            }
                            this.appendBuf(100);
                            continue block95;
                        }
                        this.appendBuf(Character.toLowerCase(r));
                        r = this.read();
                        continue block95;
                    }
                    if (r == 40 || r == 91) {
                        this.pushResult(this.getPolar());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.pushResult(this.getPolar());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (r == 59) {
                        this.pushResult(this.getPolar());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.pushResult(this.getPolar());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == -1) {
                        this.pushResult(this.getPolar());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 47) {
                        this.appendBuf(r);
                        this.state = State.RATIONAL_NUMBER_POLAR;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case FLOAT_NUMBER_POLAR: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (this.isDigit09az(r)) {
                        this.state = State.FLOAT_NUMBER_D_POLAR;
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case FLOAT_NUMBER_D_POLAR: {
                    if (r == -1) {
                        this.pushResult(this.getPolar());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.pushResult(this.getPolar());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.pushResult(this.getPolar());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (r == 59) {
                        this.pushResult(this.getPolar());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.pushResult(this.getPolar());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        r = this.read();
                        continue block95;
                    }
                    if (this.isExpsym(r)) {
                        this.state = State.FLOAT_NUMBER_E_POLAR;
                        if (r == 100) {
                            r = this.read();
                            if (r == 102 || r == 70) {
                                this.appendBuf(35);
                                r = this.read();
                                continue block95;
                            }
                            if (r == 100 || r == 68) {
                                this.appendBuf(38);
                                r = this.read();
                                continue block95;
                            }
                            this.appendBuf(100);
                            continue block95;
                        }
                        this.appendBuf(Character.toLowerCase(r));
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case FLOAT_NUMBER_E_POLAR: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 43 || r == 45) {
                        this.appendBuf(r);
                        this.state = State.FLOAT_NUMBER_E_SIGN_POLAR;
                        r = this.read();
                        continue block95;
                    }
                    if (this.isDigit09az(r)) {
                        this.state = State.FLOAT_NUMBER_E_D_POLAR;
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case FLOAT_NUMBER_E_SIGN_POLAR: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (this.isDigit09az(r)) {
                        this.state = State.FLOAT_NUMBER_E_D_POLAR;
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case FLOAT_NUMBER_E_D_POLAR: {
                    if (r == -1) {
                        this.pushResult(this.getPolar());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.pushResult(this.getPolar());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.pushResult(this.getPolar());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (r == 59) {
                        this.pushResult(this.getPolar());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.pushResult(this.getPolar());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case RATIONAL_NUMBER_POLAR: {
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        r = this.read();
                        this.state = State.RATIONAL_NUMBER_2_POLAR;
                        continue block95;
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case RATIONAL_NUMBER_2_POLAR: {
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        r = this.read();
                        continue block95;
                    }
                    if (r == 40 || r == 91) {
                        this.pushResult(this.getPolar());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.pushResult(this.getPolar());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (r == 59) {
                        this.pushResult(this.getPolar());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.pushResult(this.getPolar());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == -1) {
                        this.pushResult(this.getPolar());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case INF_I: {
                    int imgn = 1;
                    if (r == 111) {
                        imgn |= 4;
                        r = this.read();
                    }
                    if (r == -1) {
                        this.pushResult(this.getImaginary(imgn));
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.pushResult(this.getImaginary(imgn));
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.pushResult(this.getImaginary(imgn));
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (r == 59) {
                        this.pushResult(this.getImaginary(imgn));
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.pushResult(this.getImaginary(imgn));
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 110) {
                        this.appendBuf(r);
                        this.state = State.INF_N;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 43 || r == 45) {
                        this.bufi[1] = this.buf;
                        this.buf = new StringBuilder("0");
                        this.appendBuf2(r);
                        this.state = State.HEAD_SIGN_COMPLEX;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case INF_N: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 102) {
                        this.appendBuf(r);
                        this.state = State.INF_F;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case INF_F: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 46) {
                        this.appendBuf(r);
                        this.state = State.INF_DOT;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case INF_DOT: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 48) {
                        this.appendBuf(r);
                        this.state = State.INF_0;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case INF_0: {
                    if (r == -1) {
                        this.pushResult(this.getDouble());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.pushResult(this.getDouble());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.pushResult(this.getDouble());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (r == 59) {
                        this.pushResult(this.getDouble());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.pushResult(this.getDouble());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 43 || r == 45) {
                        this.appendBuf2(r);
                        this.state = State.HEAD_SIGN_COMPLEX;
                        r = this.read();
                        continue block95;
                    }
                    if (this.isImaginary(r)) {
                        this.appendBuf(r);
                        this.state = State.COMPLEX_I;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 64) {
                        this.appendBuf(r);
                        this.state = State.INIT_POLAR;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case COMPLEX_I: {
                    char r0 = this.buf.charAt(this.buf.length() - 1);
                    int imgn = this.getImaginaryNo(r0);
                    if (r == 111) {
                        if (r0 == 'o') {
                            this.state = this.symbolNum();
                            continue block95;
                        }
                        imgn |= 4;
                        r = this.read();
                    }
                    this.bufi[imgn] = this.buf;
                    if (r == 40 || r == 91) {
                        if (this.signed) {
                            this.pushResult(this.getImaginary(imgn));
                            this.state = this.popStateStack();
                            continue block95;
                        }
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        if (this.signed) {
                            this.pushResult(this.getImaginary(imgn));
                            this.state = this.popStateStack();
                            continue block95;
                        }
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        if (this.signed) {
                            this.pushResult(this.getImaginary(imgn));
                            this.state = this.popStateStack();
                            continue block95;
                        }
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        if (this.signed) {
                            this.pushResult(this.getImaginary(imgn));
                            this.state = this.popStateStack();
                        } else {
                            this.state = this.popStateSymbolNum();
                        }
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 43 || r == 45) {
                        this.buf = new StringBuilder("0");
                        this.appendBuf2(r);
                        this.state = State.HEAD_SIGN_COMPLEX;
                        r = this.read();
                        continue block95;
                    }
                    if (r == -1) {
                        if (this.signed) {
                            this.pushResult(this.getImaginary(imgn));
                            this.state = this.popStateStack();
                        } else {
                            this.state = this.popStateSymbolNum();
                        }
                        return this.stateStack.empty();
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case HEAD_SIGN_COMPLEX: {
                    if (this.isDigit09az(r)) {
                        this.state = State.NUMBER_COMPLEX;
                        continue block95;
                    }
                    if (r == 46) {
                        this.appendBuf2(r);
                        this.state = State.FLOAT_NUMBER_COMPLEX;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 105) {
                        this.appendBuf2(r);
                        this.state = State.INF_I_COMPLEX;
                        r = this.read();
                        continue block95;
                    }
                    if (this.isImaginary(r)) {
                        this.appendBuf2(r);
                        this.state = State.COMPLEX_I2;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbol2Num();
                    continue block95;
                }
                case NUMBER_COMPLEX: {
                    if (this.isDigit09az(r)) {
                        this.appendBuf2(r);
                        r = this.read();
                        continue block95;
                    }
                    if (r == 46) {
                        this.appendBuf2(r);
                        this.state = State.FLOAT_NUMBER_COMPLEX;
                        r = this.read();
                        continue block95;
                    }
                    if (this.isExpsym(r)) {
                        this.state = State.FLOAT_NUMBER_E_COMPLEX;
                        if (r == 100) {
                            r = this.read();
                            if (r == 102 || r == 70) {
                                this.appendBuf2(35);
                                r = this.read();
                                continue block95;
                            }
                            if (r == 100 || r == 68) {
                                this.appendBuf2(38);
                                r = this.read();
                                continue block95;
                            }
                            this.appendBuf2(100);
                            continue block95;
                        }
                        this.appendBuf2(Character.toLowerCase(r));
                        r = this.read();
                        continue block95;
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 47) {
                        this.appendBuf2(r);
                        this.state = State.RATIONAL_NUMBER_COMPLEX;
                        r = this.read();
                        continue block95;
                    }
                    if (this.isImaginary(r)) {
                        this.appendBuf2(r);
                        this.state = State.COMPLEX_I2;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbol2Num();
                    continue block95;
                }
                case FLOAT_NUMBER_COMPLEX: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (this.isDigit09az(r)) {
                        this.state = State.FLOAT_NUMBER_D_COMPLEX;
                        continue block95;
                    }
                    if (r == 123) {
                        this.appendBuf2(r);
                        r = this.read();
                        this.state = State.FLOAT_NUMBER_COMPLEX_CYCLE;
                        continue block95;
                    }
                    this.state = this.symbol2Num();
                    continue block95;
                }
                case FLOAT_NUMBER_D_COMPLEX: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (this.isDigit09az(r)) {
                        this.appendBuf2(r);
                        r = this.read();
                        continue block95;
                    }
                    if (this.isExpsym(r)) {
                        this.state = State.FLOAT_NUMBER_E_COMPLEX;
                        if (r == 100) {
                            r = this.read();
                            if (r == 102 || r == 70) {
                                this.appendBuf2(35);
                                r = this.read();
                                continue block95;
                            }
                            if (r == 100 || r == 68) {
                                this.appendBuf2(38);
                                r = this.read();
                                continue block95;
                            }
                            this.appendBuf2(100);
                            continue block95;
                        }
                        this.appendBuf2(Character.toLowerCase(r));
                        r = this.read();
                        continue block95;
                    }
                    if (this.isImaginary(r)) {
                        this.appendBuf2(r);
                        this.state = State.COMPLEX_I2;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 123) {
                        this.appendBuf2(r);
                        r = this.read();
                        this.state = State.FLOAT_NUMBER_COMPLEX_CYCLE;
                        continue block95;
                    }
                    if (r == 46) {
                        this.appendBuf2(r);
                        r = this.read();
                        this.state = State.FLOAT_NUMBER_COMPLEX_ELLIPSE1;
                        continue block95;
                    }
                    this.state = this.symbol2Num();
                    continue block95;
                }
                case FLOAT_NUMBER_COMPLEX_CYCLE: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (this.isDigit09az(r)) {
                        this.appendBuf2(r);
                        r = this.read();
                        continue block95;
                    }
                    if (r == 125) {
                        this.appendBuf2(r);
                        r = this.read();
                        this.state = State.FLOAT_NUMBER_COMPLEX_CYCLE2;
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case FLOAT_NUMBER_COMPLEX_CYCLE2: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91 || this.parenthesis(r) || r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (this.isImaginary(r)) {
                        this.appendBuf2(r);
                        this.state = State.COMPLEX_I2;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case FLOAT_NUMBER_COMPLEX_ELLIPSE1: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91 || this.parenthesis(r) || r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 46) {
                        r = this.read();
                        this.state = State.FLOAT_NUMBER_COMPLEX_ELLIPSE2;
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case FLOAT_NUMBER_COMPLEX_ELLIPSE2: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91 || this.parenthesis(r) || r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 46) {
                        r = this.read();
                        this.state = State.FLOAT_NUMBER_COMPLEX_ELLIPSE3;
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case FLOAT_NUMBER_COMPLEX_ELLIPSE3: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91 || this.parenthesis(r) || r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (this.isImaginary(r)) {
                        this.appendBuf2(r);
                        this.state = State.COMPLEX_I2;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbolNum();
                    continue block95;
                }
                case FLOAT_NUMBER_E_COMPLEX: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 43 || r == 45) {
                        this.appendBuf2(r);
                        this.state = State.FLOAT_NUMBER_E_SIGN_COMPLEX;
                        r = this.read();
                        continue block95;
                    }
                    if (this.isDigit09az(r)) {
                        this.state = State.FLOAT_NUMBER_E_D_COMPLEX;
                        continue block95;
                    }
                    this.state = this.symbol2Num();
                    continue block95;
                }
                case FLOAT_NUMBER_E_SIGN_COMPLEX: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (this.isDigit09az(r)) {
                        this.state = State.FLOAT_NUMBER_E_D_COMPLEX;
                        continue block95;
                    }
                    this.state = this.symbol2Num();
                    continue block95;
                }
                case FLOAT_NUMBER_E_D_COMPLEX: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (this.isDigit09az(r)) {
                        this.appendBuf2(r);
                        r = this.read();
                        continue block95;
                    }
                    if (this.isImaginary(r)) {
                        this.appendBuf2(r);
                        this.state = State.COMPLEX_I2;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbol2Num();
                    continue block95;
                }
                case RATIONAL_NUMBER_COMPLEX: {
                    if (this.isDigit09az(r)) {
                        this.appendBuf2(r);
                        r = this.read();
                        this.state = State.RATIONAL_NUMBER_2_COMPLEX;
                        continue block95;
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    this.state = this.symbol2Num();
                    continue block95;
                }
                case RATIONAL_NUMBER_2_COMPLEX: {
                    if (this.isDigit09az(r)) {
                        this.appendBuf2(r);
                        r = this.read();
                        continue block95;
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (this.isImaginary(r)) {
                        this.appendBuf2(r);
                        this.state = State.COMPLEX_I2;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 43 || r == 45) {
                        this.appendBuf2(r);
                        this.state = State.CONTINUED_FRACTION_COMPLEX;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbol2Num();
                    continue block95;
                }
                case CONTINUED_FRACTION_COMPLEX: {
                    if (r == 47) {
                        this.appendBuf2(r);
                        this.state = State.RATIONAL_NUMBER_COMPLEX;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbol2Num();
                    continue block95;
                }
                case INF_I_COMPLEX: {
                    int imgn = 1;
                    if (r == 111) {
                        imgn |= 4;
                        r = this.read();
                    }
                    if (this.bufi[imgn] != null) {
                        if (r == 110) {
                            this.appendBuf2(r);
                            this.state = State.INF_N_COMPLEX;
                            r = this.read();
                            continue block95;
                        }
                        this.state = this.symbol2Num();
                        continue block95;
                    }
                    if (r == -1) {
                        this.bufi[imgn] = this.buf2;
                        this.pushResult(this.getComplex());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.bufi[imgn] = this.buf2;
                        this.pushResult(this.getComplex());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.bufi[imgn] = this.buf2;
                        this.pushResult(this.getComplex());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (r == 59) {
                        this.bufi[imgn] = this.buf2;
                        this.pushResult(this.getComplex());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.bufi[imgn] = this.buf2;
                        this.pushResult(this.getComplex());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 110) {
                        this.appendBuf2(r);
                        this.state = State.INF_N_COMPLEX;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 43 || r == 45) {
                        this.bufi[imgn] = this.buf2;
                        this.buf2 = new StringBuilder();
                        this.appendBuf2(r);
                        this.state = State.HEAD_SIGN_COMPLEX;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbol2Num();
                    continue block95;
                }
                case INF_N_COMPLEX: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 102) {
                        this.appendBuf2(r);
                        this.state = State.INF_F_COMPLEX;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbol2Num();
                    continue block95;
                }
                case INF_F_COMPLEX: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 46) {
                        this.appendBuf2(r);
                        this.state = State.INF_DOT_COMPLEX;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbol2Num();
                    continue block95;
                }
                case INF_DOT_COMPLEX: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 48) {
                        this.appendBuf2(r);
                        this.state = State.INF_0_COMPLEX;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbol2Num();
                    continue block95;
                }
                case INF_0_COMPLEX: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        continue block95;
                    }
                    if (this.isImaginary(r)) {
                        this.appendBuf2(r);
                        this.state = State.COMPLEX_I2;
                        r = this.read();
                        continue block95;
                    }
                    this.state = this.symbol2Num();
                    continue block95;
                }
                case COMPLEX_I2: {
                    char r0 = this.buf2.charAt(this.buf2.length() - 1);
                    int imgn = this.getImaginaryNo(r0);
                    if (r == 111) {
                        if (r0 == 'o') {
                            this.state = this.symbol2Num();
                            continue block95;
                        }
                        imgn |= 4;
                        r = this.read();
                    }
                    if (this.bufi[imgn] != null) {
                        this.state = this.symbol2Num();
                        continue block95;
                    }
                    this.bufi[imgn] = this.buf2;
                    if (r == 40 || r == 91) {
                        this.pushResult(this.getComplex());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.pushResult(this.getComplex());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (r == 59) {
                        this.pushResult(this.getComplex());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.pushResult(this.getComplex());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 43 || r == 45) {
                        this.buf2 = new StringBuilder();
                        this.appendBuf2(r);
                        this.state = State.HEAD_SIGN_COMPLEX;
                        r = this.read();
                        continue block95;
                    }
                    if (r == -1) {
                        this.pushResult(this.getComplex());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    this.state = this.symbol2Num();
                    continue block95;
                }
                case STRING: {
                    if (r == -1) {
                        if (this.consoleMode) {
                            this.appendBuf(10);
                            return this.stateStack.empty();
                        }
                        throw this.message.getReadError("err.read.eof");
                    }
                    if (r == 34) {
                        this.pushResult(this.getString());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 92) {
                        this.state = State.STRING_ESCAPE;
                        r = this.read();
                        continue block95;
                    }
                    this.appendBuf(r);
                    r = this.read();
                    continue block95;
                }
                case STRING_ESCAPE: {
                    switch (r) {
                        case -1: {
                            if (this.consoleMode) {
                                this.state = State.STRING_NEWLINE2;
                                return this.stateStack.empty();
                            }
                            throw this.message.getReadError("err.read.eof");
                        }
                        case 97: {
                            this.appendBuf(7);
                            this.state = State.STRING;
                            r = this.read();
                            continue block95;
                        }
                        case 98: {
                            this.appendBuf(8);
                            this.state = State.STRING;
                            r = this.read();
                            continue block95;
                        }
                        case 116: {
                            this.appendBuf(9);
                            this.state = State.STRING;
                            r = this.read();
                            continue block95;
                        }
                        case 110: {
                            this.appendBuf(10);
                            this.state = State.STRING;
                            r = this.read();
                            continue block95;
                        }
                        case 118: {
                            this.appendBuf(11);
                            this.state = State.STRING;
                            r = this.read();
                            continue block95;
                        }
                        case 102: {
                            this.appendBuf(12);
                            this.state = State.STRING;
                            r = this.read();
                            continue block95;
                        }
                        case 114: {
                            this.appendBuf(13);
                            this.state = State.STRING;
                            r = this.read();
                            continue block95;
                        }
                        case 117: 
                        case 120: {
                            this.state = State.STRING_CODE;
                            r = this.read();
                            continue block95;
                        }
                        case 10: {
                            this.state = State.STRING_NEWLINE2;
                            r = this.read();
                            continue block95;
                        }
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = State.STRING_NEWLINE;
                        continue block95;
                    }
                    this.appendBuf(r);
                    this.state = State.STRING;
                    r = this.read();
                    continue block95;
                }
                case STRING_CODE: {
                    if (r >= 48 && r <= 57 || r >= 97 && r <= 102 || r >= 65 && r <= 70) {
                        this.buf2.append((char)r);
                        r = this.read();
                        continue block95;
                    }
                    if (r == 59) {
                        this.appendBuf(this.getByCharCode(this.getToken2()));
                        this.buf2 = new StringBuilder();
                        this.state = State.STRING;
                        r = this.read();
                        continue block95;
                    }
                    if (this.buf2.length() == 4 || this.buf2.length() == 8) {
                        this.appendBuf(this.getByCharCode(this.getToken2()));
                        this.buf2 = new StringBuilder();
                        this.state = State.STRING;
                        continue block95;
                    }
                    throw this.message.getReadError("err.read.string");
                }
                case STRING_NEWLINE: {
                    if (r == -1) {
                        if (this.consoleMode) {
                            this.state = State.STRING_NEWLINE2;
                            return this.stateStack.empty();
                        }
                        throw this.message.getReadError("err.read.eof");
                    }
                    if (Character.isWhitespace(r)) {
                        r = this.read();
                        continue block95;
                    }
                    if (r == 10) {
                        this.state = State.STRING_NEWLINE2;
                        r = this.read();
                        continue block95;
                    }
                    throw this.message.getReadError("err.read.string");
                }
                case STRING_NEWLINE2: {
                    if (r == -1) {
                        if (this.consoleMode) {
                            this.appendBuf(10);
                            this.state = State.STRING;
                            return this.stateStack.empty();
                        }
                        throw this.message.getReadError("err.read.eof");
                    }
                    if (Character.isWhitespace(r)) {
                        r = this.read();
                        continue block95;
                    }
                    this.state = State.STRING;
                    continue block95;
                }
                case SHARP_SYNTAX_I: {
                    if (r == -1) {
                        throw this.message.getReadError("err.read.sharp.unknown");
                    }
                    if (r == 116) {
                        this.pushResult(LispBoolean.TRUE);
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 102) {
                        this.pushResult(LispBoolean.FALSE);
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 40 || r == 123) {
                        this.parenStack.push(r);
                        this.state = State.VECTOR;
                        r = this.readNext();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        throw this.message.getReadError("err.read.sharp.unknown");
                    }
                    if (r == 59) {
                        this.state = State.S_EXP_COMMENT;
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 47) {
                        this.state = State.SHARP_SYNTAX_RE;
                        r = this.read();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        throw this.message.getReadError("err.read.sharp.unknown");
                    }
                    if (r == 124) {
                        this.stateStack.push(State.INIT);
                        this.state = State.BLOCK_COMMENT;
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 92) {
                        this.state = State.CHARACTER_EXP;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 101 || r == 69) {
                        this.prefixed = true;
                        this.exactness = Exact.EXACT;
                        this.state = State.NUMBER_PREFIX;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 105 || r == 73) {
                        this.prefixed = true;
                        this.exactness = Exact.INEXACT;
                        this.state = State.NUMBER_PREFIX;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 98 || r == 66) {
                        this.prefixed = true;
                        this.radix = 2;
                        this.state = State.NUMBER_PREFIX;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 111 || r == 79) {
                        this.prefixed = true;
                        this.radix = 8;
                        this.state = State.NUMBER_PREFIX;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 100 || r == 68) {
                        this.prefixed = true;
                        this.radix = 10;
                        this.state = State.NUMBER_PREFIX;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 120 || r == 88) {
                        this.prefixed = true;
                        this.radix = 16;
                        this.state = State.NUMBER_PREFIX;
                        r = this.read();
                        continue block95;
                    }
                    if (r == 33) {
                        this.state = State.SHARP_HASH_BANG;
                        r = this.read();
                        continue block95;
                    }
                    throw this.message.getReadError("err.read.sharp.unknown");
                }
                case SHARP_SYNTAX_RE: {
                    if (r == -1) {
                        this.pushResult(this.getRegex());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 47) {
                        this.appendBuf(r);
                        this.state = State.SHARP_SYNTAX_RE_F;
                        r = this.read();
                        continue block95;
                    }
                    this.appendBuf(r);
                    r = this.read();
                    continue block95;
                }
                case SHARP_SYNTAX_RE_F: {
                    if (r == -1) {
                        this.pushResult(this.getRegex());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.pushResult(this.getRegex());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.pushResult(this.getRegex());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (r == 59) {
                        this.pushResult(this.getRegex());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.pushResult(this.getRegex());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 92) {
                        throw this.message.getReadError("err.read.sharp.unknown");
                    }
                    this.appendBuf(r);
                    r = this.read();
                    continue block95;
                }
                case SHARP_HASH_BANG: {
                    if (r == -1) {
                        this.processHashBang(this.buf2.toString());
                        this.buf2 = new StringBuilder();
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 10) {
                        this.processHashBang(this.buf2.toString());
                        this.buf2 = new StringBuilder();
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    this.buf2.appendCodePoint(r);
                    r = this.read();
                    continue block95;
                }
                case CHARACTER_EXP: {
                    if (r == -1) {
                        throw this.message.getReadError("err.read.eol");
                    }
                    if (r == 59) {
                        throw this.message.getReadError("err.read.character.unknown");
                    }
                    this.appendBuf(r);
                    this.state = State.CHARACTER_EXP_NAME;
                    r = this.read();
                    continue block95;
                }
                case CHARACTER_EXP_NAME: {
                    if (r == 40 || r == 91) {
                        this.pushResult(this.getCharacter());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.pushResult(this.getCharacter());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (r == 59) {
                        this.pushResult(this.getCharacter());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.pushResult(this.getCharacter());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == -1) {
                        this.pushResult(this.getCharacter());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    this.appendBuf(r);
                    r = this.read();
                    continue block95;
                }
                case SYMBOL: {
                    if (r == 40 || r == 91) {
                        this.pushMaybeSymbol(this.getSymbol());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.pushMaybeSymbol(this.getSymbol());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (r == 59) {
                        this.pushMaybeSymbol(this.getSymbol());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.pushMaybeSymbol(this.getSymbol());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == -1) {
                        this.pushMaybeSymbol(this.getSymbol());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    this.appendBuf(r);
                    r = this.read();
                    continue block95;
                }
                case SYMBOL2: {
                    if (r == 40 || r == 91) {
                        this.pushMaybeSymbol(this.getSymbol());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.pushMaybeSymbol(this.getSymbol());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (r == 59) {
                        this.pushMaybeSymbol(this.getSymbol());
                        this.state = this.popStateStack();
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.pushMaybeSymbol(this.getSymbol());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == -1) {
                        this.pushMaybeSymbol(this.getSymbol());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    this.appendBuf2(r);
                    r = this.read();
                    continue block95;
                }
                case LIST: {
                    if (r == -1) {
                        return this.stateStack.empty();
                    }
                    if (r == 59) {
                        this.stateStack.push(this.state);
                        this.state = State.COMMENT;
                        r = this.read();
                        continue block95;
                    }
                    if (this.parenthesis(r)) {
                        this.checkParenthesis(r);
                        this.pushResult(Nil.NIL);
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    Cons n = new Cons(_VOID, Nil.NIL);
                    this.pushResult(n);
                    this.stateStack.push(State.LIST2);
                    this.consStack.push(n);
                    this.state = State.INIT;
                    continue block95;
                }
                case LIST2: {
                    if (r == -1) {
                        return this.stateStack.empty();
                    }
                    if (r == 59) {
                        this.stateStack.push(this.state);
                        this.state = State.COMMENT;
                        r = this.read();
                        continue block95;
                    }
                    Cons c1 = this.consStack.peek();
                    Datum d1 = this.resultStack.pop();
                    if (d1 != _VOID) {
                        c1.setCar(d1);
                    }
                    if (this.parenthesis(r)) {
                        Datum d2 = this.resultStack.pop();
                        this.checkParenthesis(r);
                        if (d2 instanceof Cons) {
                            Cons cd2 = (Cons)d2;
                            if (cd2.getCar() == _VOID) {
                                this.pushResult(Nil.NIL);
                            } else {
                                this.pushResult(d2);
                            }
                        } else {
                            throw new RuntimeException();
                        }
                        this.consStack.pop();
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 46) {
                        this.appendBuf(r);
                        this.state = State.LIST_DOT_INIT;
                        r = this.read();
                        continue block95;
                    }
                    if (d1 != _VOID) {
                        Cons n = new Cons();
                        c1.setCdr(n);
                        this.consStack.pop();
                        this.consStack.push(n);
                    }
                    this.stateStack.push(State.LIST2);
                    this.state = State.INIT;
                    continue block95;
                }
                case LIST_DOT_INIT: {
                    Cons n;
                    Cons c3 = this.consStack.peek();
                    if (c3.getCar() == _VOID) {
                        throw this.message.getReadError("err.read.list.invalid");
                    }
                    if (r == 40 || r == 91 || this.parenthesis(r) || r == -1) {
                        this.stateStack.push(State.LIST_DOT);
                        this.state = State.INIT;
                        this.clearBuf();
                        c3.setCdr(_VOID);
                        continue block95;
                    }
                    if (r == 59) {
                        this.stateStack.push(State.LIST_DOT);
                        this.stateStack.push(State.INIT);
                        this.state = State.COMMENT;
                        this.clearBuf();
                        c3.setCdr(_VOID);
                        continue block95;
                    }
                    if (Character.isWhitespace(r)) {
                        this.stateStack.push(State.LIST_DOT);
                        this.state = State.INIT;
                        r = this.readNext();
                        c3.setCdr(_VOID);
                        continue block95;
                    }
                    if (this.isDigit09(r)) {
                        n = new Cons();
                        c3.setCdr(n);
                        this.consStack.pop();
                        this.stateStack.push(State.LIST2);
                        this.consStack.push(n);
                        this.state = State.FLOAT_NUMBER_D;
                        continue block95;
                    }
                    n = new Cons();
                    c3.setCdr(n);
                    this.consStack.pop();
                    this.stateStack.push(State.LIST2);
                    this.consStack.push(n);
                    this.state = State.SYMBOL;
                    continue block95;
                }
                case LIST_DOT: {
                    if (r == -1) {
                        return this.stateStack.empty();
                    }
                    if (r == 59) {
                        this.stateStack.push(this.state);
                        this.state = State.COMMENT;
                        r = this.read();
                        continue block95;
                    }
                    Cons c2 = this.consStack.peek();
                    Datum d1 = this.resultStack.pop();
                    if (d1 != _VOID) {
                        c2.setCdr(d1);
                    }
                    if (this.parenthesis(r)) {
                        this.checkParenthesis(r);
                        if (c2.getCdr() == _VOID) {
                            throw this.message.getReadError("err.read.dot");
                        }
                        this.consStack.pop();
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (d1 == _VOID) {
                        this.stateStack.push(State.LIST_DOT);
                        this.state = State.INIT;
                        this.clearBuf();
                        continue block95;
                    }
                    throw this.message.getReadError("err.read.dot");
                }
                case QUOTE: {
                    Cons n1 = new Cons();
                    Cons n2 = new Cons();
                    if (r == 64) {
                        this.appendBuf(r);
                        r = this.readNext2();
                    }
                    n1.setCar(this.getQuote());
                    n1.setCdr(n2);
                    this.pushResult(n1);
                    this.consStack.push(n2);
                    this.stateStack.push(State.QUOTE);
                    this.state = State.INIT;
                    continue block95;
                }
                case VECTOR: {
                    if (r == -1) {
                        return this.stateStack.empty();
                    }
                    if (r == 41 || r == 125) {
                        this.checkParenthesis(r);
                        switch (r) {
                            case 41: {
                                this.pushResult(LispVector.EMPTY);
                            }
                        }
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 93) {
                        throw this.message.getReadError("err.read.parenthesis.mismatch");
                    }
                    if (r == 59) {
                        this.stateStack.push(this.state);
                        this.state = State.COMMENT;
                        r = this.read();
                        continue block95;
                    }
                    this.vectorStack.push(new ArrayList());
                    this.stateStack.push(State.VECTOR2);
                    this.state = State.INIT;
                    continue block95;
                }
                case VECTOR2: {
                    if (r == -1) {
                        return this.stateStack.empty();
                    }
                    if (r == 59) {
                        this.stateStack.push(this.state);
                        this.state = State.COMMENT;
                        r = this.read();
                        continue block95;
                    }
                    List<Datum> v1 = this.vectorStack.peek();
                    Datum d1 = this.resultStack.pop();
                    if (d1 != _VOID) {
                        v1.add(d1);
                    }
                    if (r == 41) {
                        this.checkParenthesis(r);
                        this.vectorStack.pop();
                        this.pushResult(new LispVector(v1));
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 93) {
                        throw this.message.getReadError("err.read.parenthesis.mismatch");
                    }
                    this.stateStack.push(State.VECTOR2);
                    this.state = State.INIT;
                    continue block95;
                }
                case COMMENT: {
                    if (r == -1) {
                        this.state = this.stateStack.pop();
                        continue block95;
                    }
                    if (r == 10) {
                        this.state = this.stateStack.pop();
                        r = this.readNext();
                        continue block95;
                    }
                    r = this.read();
                    continue block95;
                }
                case BLOCK_COMMENT: {
                    if (r == -1) {
                        return this.stateStack.empty();
                    }
                    if (r == 124) {
                        r = this.read();
                        if (r == 35) {
                            this.state = this.stateStack.pop();
                            r = this.readNext();
                            continue block95;
                        }
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 35) {
                        r = this.read();
                        if (r == 124) {
                            this.stateStack.push(State.BLOCK_COMMENT);
                            r = this.readNext();
                            continue block95;
                        }
                        r = this.readNext();
                        continue block95;
                    }
                    r = this.readNext();
                    continue block95;
                }
                case S_EXP_COMMENT: {
                    this.stateStack.push(State.S_EXP_COMMENT);
                    this.state = State.INIT;
                    continue block95;
                }
                case SYMBOLQUOTE: {
                    if (r == -1 || r == 40 || r == 91 || Character.isWhitespace(r)) {
                        this.pushResult(Symbol.getSymbolWithoutFoldCase("|"));
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    if (r == 124) {
                        this.appendBuf(r);
                        r = this.read();
                        this.state = State.SYMBOL;
                        continue block95;
                    }
                    this.state = State.SYMBOLQUOTE2;
                    continue block95;
                }
                case SYMBOLQUOTE2: {
                    if (r == -1) {
                        throw this.message.getReadError("err.read.eof");
                    }
                    if (r == 124) {
                        this.pushResult(Symbol.getSymbolWithoutFoldCase(this.getToken()));
                        this.state = this.popStateStack();
                        r = this.readNext();
                        continue block95;
                    }
                    this.appendBuf(r);
                    r = this.read();
                    continue block95;
                }
                case END_OF_FILE: {
                    throw this.message.getError("err.read.eof");
                }
            }
            break;
        }
        throw this.message.getReadError("err.read.list.invalid");
    }

    private static enum Exact {
        DEFAULT,
        EXACT,
        INEXACT;

    }

    private static enum State {
        INIT,
        NUMBER_PREFIX,
        HEAD_SIGN,
        NUMBER,
        FLOAT_NUMBER,
        FLOAT_NUMBER_D,
        FLOAT_NUMBER_CYCLE,
        FLOAT_NUMBER_ELLIPSE1,
        FLOAT_NUMBER_ELLIPSE2,
        FLOAT_NUMBER_E,
        FLOAT_NUMBER_E_SIGN,
        FLOAT_NUMBER_E_D,
        RATIONAL_NUMBER,
        RATIONAL_NUMBER_2,
        CONTINUED_FRACTION,
        INF_I,
        INF_N,
        INF_F,
        INF_DOT,
        INF_0,
        COMPLEX_I,
        INIT_POLAR,
        HEAD_SIGN_POLAR,
        NUMBER_POLAR,
        FLOAT_NUMBER_POLAR,
        FLOAT_NUMBER_D_POLAR,
        FLOAT_NUMBER_E_POLAR,
        FLOAT_NUMBER_E_SIGN_POLAR,
        FLOAT_NUMBER_E_D_POLAR,
        RATIONAL_NUMBER_POLAR,
        RATIONAL_NUMBER_2_POLAR,
        HEAD_SIGN_COMPLEX,
        NUMBER_COMPLEX,
        FLOAT_NUMBER_COMPLEX,
        FLOAT_NUMBER_COMPLEX_CYCLE,
        FLOAT_NUMBER_COMPLEX_CYCLE2,
        FLOAT_NUMBER_COMPLEX_ELLIPSE1,
        FLOAT_NUMBER_COMPLEX_ELLIPSE2,
        FLOAT_NUMBER_COMPLEX_ELLIPSE3,
        FLOAT_NUMBER_D_COMPLEX,
        FLOAT_NUMBER_E_COMPLEX,
        FLOAT_NUMBER_E_SIGN_COMPLEX,
        FLOAT_NUMBER_E_D_COMPLEX,
        RATIONAL_NUMBER_COMPLEX,
        RATIONAL_NUMBER_2_COMPLEX,
        CONTINUED_FRACTION_COMPLEX,
        INF_I_COMPLEX,
        INF_N_COMPLEX,
        INF_F_COMPLEX,
        INF_DOT_COMPLEX,
        INF_0_COMPLEX,
        COMPLEX_I2,
        STRING,
        STRING_ESCAPE,
        STRING_CODE,
        STRING_NEWLINE,
        STRING_NEWLINE2,
        SHARP_SYNTAX_I,
        SHARP_SYNTAX_RE,
        SHARP_SYNTAX_RE_F,
        SHARP_HASH_BANG,
        CHARACTER_EXP,
        CHARACTER_EXP_NAME,
        SYMBOL,
        SYMBOL2,
        LIST,
        LIST2,
        LIST_DOT_INIT,
        LIST_DOT,
        QUOTE,
        VECTOR,
        VECTOR2,
        COMMENT,
        BLOCK_COMMENT,
        S_EXP_COMMENT,
        S_EXP_MACRO,
        S_EXP_QUOTE,
        END_OF_FILE,
        SYMBOLQUOTE,
        SYMBOLQUOTE2;

    }
}

