/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.LispCharacter;
import net.morilib.lisp.lite.LispIOException;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispUtils;

public class OutputPort
extends Datum {
    private PrintStream lineWriter;
    private boolean standard;
    private boolean closed = false;
    private LispMessage msg;

    private OutputPort(OutputStream wr, boolean std, LispMessage msg) {
        this.lineWriter = wr instanceof PrintStream ? (PrintStream)wr : new PrintStream(wr);
        this.standard = std;
        this.msg = msg;
    }

    public OutputPort(PrintStream wr, LispMessage msg) {
        this(wr, false, msg);
    }

    public OutputPort(OutputStream wr, LispMessage msg) {
        this(wr, false, msg);
    }

    public OutputPort(File fname, LispMessage msg) {
        try {
            FileOutputStream wr = new FileOutputStream(fname);
            this.lineWriter = new PrintStream(wr);
            this.standard = false;
        }
        catch (FileNotFoundException e) {
            throw new LispIOException(e);
        }
    }

    public OutputPort(File fname, String encoding, LispMessage msg) throws UnsupportedEncodingException {
        try {
            FileOutputStream wr = new FileOutputStream(fname);
            this.lineWriter = new PrintStream((OutputStream)wr, true, encoding);
            this.standard = false;
        }
        catch (FileNotFoundException e) {
            throw new LispIOException(e);
        }
    }

    public static OutputPort getStandard(LispMessage msg) {
        return new OutputPort(System.out, true, msg);
    }

    public void writeChar(LispCharacter ch) {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.standard) {
            System.out.print(ch.getCharacter());
        } else {
            this.lineWriter.print(ch.getCharacter());
        }
    }

    public void write(Datum d) {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.standard) {
            System.out.print(LispUtils.getResultWithoutSS(d));
        } else {
            this.lineWriter.print(LispUtils.getResultWithoutSS(d));
        }
    }

    public void display(Datum d) {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.standard) {
            System.out.print(LispUtils.print(d));
        } else {
            this.lineWriter.print(LispUtils.print(d));
        }
    }

    public void writeWithSS(Datum d) {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.standard) {
            System.out.print(LispUtils.getResult(d));
        } else {
            this.lineWriter.print(LispUtils.getResult(d));
        }
    }

    public void newline() {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.standard) {
            System.out.println();
        } else {
            this.lineWriter.println();
        }
    }

    public void close() {
        if (!this.closed && !this.standard) {
            this.lineWriter.close();
            this.closed = true;
        }
    }

    public boolean isStandard() {
        return this.standard;
    }

    @Override
    public boolean isTypePort() {
        return true;
    }

    public Writer getWriter() {
        return new OutputStreamWriter(this.lineWriter);
    }

    public PrintStream getPrintStream() {
        return this.lineWriter;
    }

    public boolean hasPortPosition() {
        return false;
    }

    public Datum getPortPosition() {
        throw new UnsupportedOperationException();
    }

    public boolean hasSetPortPosition() {
        return false;
    }

    public void setPortPosition(Datum pos) {
        throw new UnsupportedOperationException();
    }

    public void flush() throws IOException {
        this.lineWriter.flush();
    }

    public void putChar(int c) throws IOException {
        this.writeChar(LispCharacter.valueOf(c));
    }

    public void putString(String s) throws IOException {
        this.lineWriter.print(s);
    }

    public void putString(String s, int start) throws IOException {
        this.lineWriter.print(s.substring(start));
    }

    public void putString(String s, int start, int end) throws IOException {
        this.lineWriter.print(s.substring(start, end));
    }

    public void putDatum(Datum d) throws IOException {
        this.writeWithSS(d);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<oport>");
    }
}

