/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.ILispVector;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispUtils;
import net.morilib.lisp.lite.Procedure;
import net.morilib.lisp.lite.Scheme;
import net.morilib.lisp.lite.Symbol;
import net.morilib.lisp.lite.Undef;
import net.morilib.lisp.lite.subr.BinaryArgs;
import net.morilib.lisp.lite.subr.IsEqual;
import net.morilib.lisp.lite.subr.SubrUtils;
import net.morilib.util.Iterators;
import net.morilib.util.Lists;

public class LispVector
extends Datum
implements ILispVector,
Serializable {
    private static final long serialVersionUID = 3364203058083838114L;
    private List<Datum> vec;
    private static final List<Datum> _EMPTY = Collections.emptyList();
    public static final LispVector EMPTY = new LispVector(_EMPTY);

    public LispVector(Collection<Datum> vec) {
        if (vec == null) {
            throw new NullPointerException();
        }
        this.vec = new ArrayList<Datum>(vec);
    }

    public LispVector(Datum ... data) {
        this(Arrays.asList(data));
    }

    public LispVector() {
        this(new ArrayList<Datum>());
    }

    public LispVector(LispVector vec) {
        if (vec == null) {
            throw new NullPointerException();
        }
        this.vec = new ArrayList<Datum>(vec.vec);
    }

    public LispVector(int size) {
        this(new ArrayList<Datum>(size));
    }

    @Override
    public Datum get(int index) {
        return this.vec.get(index);
    }

    void setS(int index, Datum d) {
        this.vec.set(index, d);
    }

    @Override
    public int size() {
        return this.vec.size();
    }

    public Datum toConsList() {
        return LispUtils.listToCons(this.vec);
    }

    @Override
    public String toString() {
        return LispUtils.getResult(this);
    }

    @Override
    public boolean isTypeVector() {
        return true;
    }

    @Override
    public List<Datum> getList() {
        return Collections.unmodifiableList(this.vec);
    }

    public Datum copySet(int index, Datum d) {
        return this.duplicate().set(index, d);
    }

    public Datum set(int index, Datum d) {
        this.setS(index, d);
        return this;
    }

    public Datum copy(int b, int e) {
        LispVector r = new LispVector();
        if (b < 0 || b >= this.size()) {
            throw new IndexOutOfBoundsException("" + b);
        }
        int i = b;
        while (i < e) {
            r.vec.add(this.get(i));
            ++i;
        }
        return r;
    }

    public Procedure equivalence() {
        return new IsEqual();
    }

    public Datum copyAdd(Datum d) {
        return this.duplicate().add(d);
    }

    public Datum add(Datum d) {
        this.vec.add(d);
        return this;
    }

    public Datum copyDelete(Datum d) {
        return this.duplicate().delete(d);
    }

    public Datum delete(Datum d) {
        int i = 0;
        while (i < this.vec.size()) {
            this.vec.remove(i);
            ++i;
        }
        return this;
    }

    public Datum copyDeleteAll(Datum d) {
        return this.duplicate().deleteAll(d);
    }

    public Datum deleteAll(Datum d) {
        this.vec.remove(d);
        return this;
    }

    public Symbol getCollectionName() {
        return Symbol.getSymbol("vector");
    }

    public boolean equivalence(Datum a, Datum b) {
        return LispUtils.equals(a, b);
    }

    public Datum prototype() {
        return new LispVector();
    }

    public Datum clear() {
        this.vec.clear();
        return this;
    }

    public LispVector duplicate() {
        return new LispVector(this);
    }

    public boolean contains(Datum d) {
        return this.vec.contains(d);
    }

    public Iterator<Datum> iterator() {
        return Iterators.unmodifiable(this.vec.iterator());
    }

    public int count(Datum c2a) {
        int r = 0;
        int i = 0;
        while (i < this.vec.size()) {
            if (LispUtils.equals(this.vec.get(i), c2a)) {
                ++r;
            }
            ++i;
        }
        return r;
    }

    public Datum toList() {
        return LispUtils.toCons(this.vec);
    }

    public Datum first() {
        if (this.vec.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.vec.get(0);
    }

    public Datum last() {
        if (this.vec.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.vec.get(this.vec.size() - 1);
    }

    public int rank() {
        return 1;
    }

    public int startIndex(int dim) {
        if (dim != 0) {
            throw new IndexOutOfBoundsException();
        }
        return 0;
    }

    public int endIndex(int dim) {
        if (dim != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.size();
    }

    public LispVector toVector() {
        return this;
    }

    public Datum getFromArray(int ... is) {
        if (is.length != 1) {
            throw new IndexOutOfBoundsException();
        }
        return this.vec.get(is[0]);
    }

    public void setToArray(Datum d, int ... is) {
        if (is.length != 1) {
            throw new IndexOutOfBoundsException();
        }
        this.vec.set(is[0], d);
    }

    public String getTypeSpecifier() {
        return null;
    }

    public void fill(Iterator<Datum> itr) {
        int i = 0;
        while (i < this.vec.size() && itr.hasNext()) {
            this.vec.set(i, itr.next());
            ++i;
        }
    }

    public LispVector add(LispVector y) {
        ArrayList<Datum> x = new ArrayList<Datum>(this.vec);
        x.addAll(y.vec);
        return new LispVector(x);
    }

    public boolean isSorted(Comparator<Datum> cmp) {
        return Lists.isSorted(this.vec, cmp);
    }

    public LispVector merge(LispVector m, Comparator<Datum> cmp) {
        LispVector r = new LispVector(this);
        r.mergeS(m, cmp);
        return r;
    }

    public LispVector mergeS(LispVector m, Comparator<Datum> cmp) {
        Lists.merge(this.vec, m.vec, cmp);
        return this;
    }

    public LispVector sort(Comparator<Datum> cmp) {
        LispVector r = new LispVector(this);
        r.sortS(cmp);
        return r;
    }

    public void sortS(Comparator<Datum> cmp) {
        Collections.sort(this.vec, cmp);
    }

    public static class VectorSortS
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, final Environment env, final LispMessage mesg) {
            final Procedure p = SubrUtils.getProcedure(c1a, mesg);
            Comparator<Datum> cmp = new Comparator<Datum>(){

                @Override
                public int compare(Datum o1, Datum o2) {
                    if (Scheme.callva(p, env, mesg, o1, o2).isTrue()) {
                        return -1;
                    }
                    if (Scheme.callva(p, env, mesg, o2, o1).isTrue()) {
                        return 1;
                    }
                    return 0;
                }
            };
            if (c2a instanceof LispVector) {
                Collections.sort(((LispVector)c2a).vec, cmp);
                return Undef.UNDEF;
            }
            throw mesg.getError("err.require.vector", c2a);
        }
    }
}

