/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.morilib.lisp.lite.Atom;
import net.morilib.lisp.lite.ConsIterator;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispCharacter;
import net.morilib.lisp.lite.LispInteger;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispUtils;
import net.morilib.lisp.lite.LispVector;
import net.morilib.lisp.lite.Procedure;
import net.morilib.lisp.lite.Subr;
import net.morilib.lisp.lite.Symbol;
import net.morilib.lisp.lite.Undef;
import net.morilib.lisp.lite.subr.CharEqual;
import net.morilib.lisp.lite.subr.SubrUtils;
import net.morilib.lisp.lite.subr.TernaryArgs;
import net.morilib.util.Iterators;
import net.morilib.util.Strings;

public final class LispString
extends Atom
implements Serializable {
    private static final long serialVersionUID = -2492989855710883745L;
    public static final LispString EMPTY = new LispString("");
    private String value;

    public LispString(String value) {
        if (value == null) {
            throw new NullPointerException("string is null");
        }
        this.value = value;
    }

    public LispString(LispString str) {
        if (str == null) {
            throw new NullPointerException();
        }
        this.value = str.value;
    }

    public static LispString valueOf(String s) {
        return new LispString(s);
    }

    public boolean isEqualTo(LispString a) {
        return this.value.equals(a.value);
    }

    @Override
    public String getString() {
        return this.value;
    }

    public void setString(String value) {
        this.value = value;
    }

    @Override
    public LispString toLispString() {
        return this;
    }

    @Override
    public String print() {
        return this.value;
    }

    @Override
    public String getResult() {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < this.value.length()) {
            char c = this.value.charAt(i);
            if (c == '\\') {
                b.append("\\\\");
            } else if (c == '\"') {
                b.append("\\\"");
            } else {
                b.append(c);
            }
            ++i;
        }
        return "\"" + b.toString() + "\"";
    }

    @Override
    public boolean isTypeString() {
        return true;
    }

    public Object toObject() {
        return this.value;
    }

    public LispString copy() {
        return new LispString(this);
    }

    public Procedure equivalence() {
        return new CharEqual();
    }

    public Datum copyAdd(Datum d) {
        return this.copy().add(d);
    }

    public Datum add(Datum d) {
        if (d instanceof LispCharacter) {
            this.value = String.valueOf(this.value) + Strings.newString(d.getCharacter());
            return this;
        }
        throw new ClassCastException("err.require.char");
    }

    public Datum copyDelete(Datum d) {
        return this.copy().delete(d);
    }

    public Datum delete(Datum d) {
        if (d instanceof LispCharacter) {
            StringBuilder b = new StringBuilder(this.value);
            int i = this.value.indexOf(d.getCharacter());
            if (i >= 0) {
                b.deleteCharAt(i);
            }
            this.value = b.toString();
            return this;
        }
        throw new ClassCastException("err.require.char");
    }

    public Datum copyDeleteAll(Datum d) {
        return this.copy().deleteAll(d);
    }

    public Datum deleteAll(Datum d) {
        if (d instanceof LispCharacter) {
            int i;
            StringBuilder b = new StringBuilder(this.value);
            while ((i = b.toString().indexOf(d.getCharacter())) >= 0) {
                b.deleteCharAt(i);
            }
            this.value = b.toString();
            return this;
        }
        throw new ClassCastException("err.require.char");
    }

    public Symbol getCollectionName() {
        return Symbol.getSymbol("string");
    }

    public int size() {
        return this.value.length();
    }

    public boolean equivalence(Datum a, Datum b) {
        if (a instanceof LispCharacter && b instanceof LispCharacter) {
            return a.getCharacter() == b.getCharacter();
        }
        throw new ClassCastException("err.require.char");
    }

    public Datum prototype() {
        return new LispString("");
    }

    public Datum clear() {
        this.value = "";
        return this;
    }

    public Datum duplicate() {
        return new LispString(this);
    }

    public boolean contains(Datum d) {
        if (d instanceof LispCharacter) {
            return this.value.indexOf(d.getCharacter()) >= 0;
        }
        throw new ClassCastException("err.require.char");
    }

    public Iterator<Datum> iterator() {
        final int[] i = new int[]{0};
        return new Iterator<Datum>(){

            @Override
            public boolean hasNext() {
                return i[0] < LispString.this.value.length();
            }

            @Override
            public Datum next() {
                int n = i[0];
                i[0] = n + 1;
                return new LispCharacter(LispString.this.value.charAt(n));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public LispCharacter get(int index) {
        return new LispCharacter(this.value.charAt(index));
    }

    public Datum copySet(int index, Datum d) {
        char[] cs = this.value.toCharArray();
        if (d instanceof LispCharacter) {
            cs[index] = d.getCharacter();
            return new LispString(new String(cs));
        }
        throw new ClassCastException("err.require.char");
    }

    public Datum set(int index, Datum d) {
        return this.copySet(index, d);
    }

    public Datum copy(int b, int e) {
        if (b >= this.value.length()) {
            throw new IndexOutOfBoundsException("" + b);
        }
        return new LispString(this.value.substring(b, e));
    }

    public int count(Datum c2a) {
        int r = 0;
        if (c2a instanceof LispCharacter) {
            char c = c2a.getCharacter();
            int i = 0;
            while (i < this.value.length()) {
                if (c == this.value.charAt(i)) {
                    ++r;
                }
                ++i;
            }
            return r;
        }
        throw new ClassCastException("err.require.char");
    }

    public Datum toList() {
        return LispUtils.stringToList(this.value);
    }

    public Datum first() {
        if (this.value.length() == 0) {
            throw new NoSuchElementException();
        }
        return LispCharacter.valueOf(this.value.charAt(0));
    }

    public Datum last() {
        if (this.value.length() == 0) {
            throw new NoSuchElementException();
        }
        return LispCharacter.valueOf(this.value.charAt(this.value.length() - 1));
    }

    public LispString add(LispString y) {
        return LispString.valueOf(String.valueOf(this.value) + y.value);
    }

    public static LispString toString(LispVector v, LispMessage mesg) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < v.size()) {
            b.appendCodePoint(SubrUtils.getCharacterCodePoint(v.get(i), mesg));
            ++i;
        }
        return new LispString(b.toString());
    }

    public static LispString toString(LispVector v) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < v.size()) {
            int c = ((LispCharacter)v.get(i)).getCharacterCodePoint();
            b.appendCodePoint(c);
            ++i;
        }
        return new LispString(b.toString());
    }

    public boolean equals(Object obj) {
        if (obj instanceof LispString) {
            return this.value.equals(((LispString)obj).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String toString() {
        return "\"" + this.value + "\"";
    }

    public static class StringCopyS
    extends Subr {
        protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
            String s = SubrUtils.getString(c3a, mesg);
            return this.execute(c1a, c2a, s, 0, s.length(), mesg);
        }

        protected Datum execute(Datum c1a, Datum c2a, String str, int b, int e, LispMessage mesg) {
            char[] t = SubrUtils.getString(c1a, mesg).toCharArray();
            char[] s = str.toCharArray();
            int ts = SubrUtils.getSmallInt(c2a, mesg);
            if (ts >= t.length) {
                throw mesg.getError("err.string.outofrange", c1a);
            }
            if (e - b > t.length - ts) {
                throw mesg.getError("err.string.outofrange");
            }
            System.arraycopy(s, b, t, ts, e - b);
            ((LispString)c1a).value = new String(t);
            return Undef.UNDEF;
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            int e;
            int b;
            String s;
            List<Datum> l = LispUtils.consToList(body, mesg);
            if (l.size() == 3) {
                return this.execute(l.get(0), l.get(1), l.get(2), env, mesg);
            }
            if (l.size() == 4) {
                s = SubrUtils.getString(l.get(2), mesg);
                b = SubrUtils.getSmallInt(l.get(3), mesg);
                e = s.length();
                if (b >= s.length()) {
                    throw mesg.getError("err.string.outofrange", l.get(3));
                }
            } else if (l.size() == 5) {
                s = SubrUtils.getString(l.get(2), mesg);
                b = SubrUtils.getSmallInt(l.get(3), mesg);
                e = SubrUtils.getSmallInt(l.get(4), mesg);
                if (b >= s.length()) {
                    throw mesg.getError("err.string.outofrange", l.get(3));
                }
                if (e > s.length()) {
                    throw mesg.getError("err.string.outofrange", l.get(4));
                }
                if (b > e) {
                    throw mesg.getError("err.range.invalid");
                }
            } else {
                throw mesg.getError("err.argument", body);
            }
            return this.execute(l.get(0), l.get(1), s, b, e, mesg);
        }
    }

    public static class StringDowncaseS
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d1 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, "err.argument", body);
            String s = SubrUtils.getString(d1, mesg);
            int b = SubrUtils.nextSmallInt((Iterator<Datum>)itr, 0, mesg);
            int e = SubrUtils.nextSmallInt((Iterator<Datum>)itr, s.length(), mesg);
            SubrUtils.checkTerminated(itr, body, mesg);
            ((LispString)d1).value = new String(Strings.toLowerCase(s.toCharArray(), b, e));
            return Undef.UNDEF;
        }
    }

    public static class StringFillS
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum c1a = Iterators.nextIf(itr, mesg.getError("err.argument", body));
            Datum c2a = Iterators.nextIf(itr, mesg.getError("err.argument", body));
            Datum c3a = Iterators.nextIf(itr, LispInteger.ZERO);
            Datum c4a = Iterators.nextIf(itr, null);
            char[] cs = SubrUtils.getString(c1a, mesg).toCharArray();
            char ch = SubrUtils.getCharacter(c2a, mesg);
            int e = cs.length;
            SubrUtils.checkTerminated(itr, body, mesg);
            int b = SubrUtils.getSmallInt(c3a, mesg);
            if (c4a != null) {
                e = SubrUtils.getSmallInt(c4a, mesg);
            }
            int i = b;
            while (i < e) {
                cs[i] = ch;
                ++i;
            }
            ((LispString)c1a).value = new String(cs);
            return Undef.UNDEF;
        }
    }

    public static class StringReverseS
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d1 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, "err.argument", body);
            String s = SubrUtils.getString(d1, mesg);
            int b = SubrUtils.nextSmallInt((Iterator<Datum>)itr, 0, mesg);
            int e = SubrUtils.nextSmallInt((Iterator<Datum>)itr, s.length(), mesg);
            SubrUtils.checkTerminated(itr, body, mesg);
            ((LispString)d1).value = new String(Strings.reverse(s.toCharArray(), b, e));
            return Undef.UNDEF;
        }
    }

    public static class StringSetS
    extends TernaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
            char[] cs = SubrUtils.getString(c1a, mesg).toCharArray();
            int i = SubrUtils.getSmallInt(c2a, mesg);
            char ch = SubrUtils.getCharacter(c3a, mesg);
            if (i < 0 || i >= cs.length) {
                throw mesg.getError("err.string.outofrange", c2a);
            }
            cs[i] = ch;
            ((LispString)c1a).value = new String(cs);
            return Undef.UNDEF;
        }
    }

    public static class StringTitlecaseS
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d1 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, "err.argument", body);
            String s = SubrUtils.getString(d1, mesg);
            int b = SubrUtils.nextSmallInt((Iterator<Datum>)itr, 0, mesg);
            int e = SubrUtils.nextSmallInt((Iterator<Datum>)itr, s.length(), mesg);
            SubrUtils.checkTerminated(itr, body, mesg);
            ((LispString)d1).value = new String(Strings.toTitleCase(s.toCharArray(), b, e));
            return Undef.UNDEF;
        }
    }

    public static class StringUpcaseS
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d1 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, "err.argument", body);
            String s = SubrUtils.getString(d1, mesg);
            int b = SubrUtils.nextSmallInt((Iterator<Datum>)itr, 0, mesg);
            int e = SubrUtils.nextSmallInt((Iterator<Datum>)itr, s.length(), mesg);
            SubrUtils.checkTerminated(itr, body, mesg);
            ((LispString)d1).value = new String(Strings.toUpperCase(s.toCharArray(), b, e));
            return Undef.UNDEF;
        }
    }

    public static class StringXcopyS
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d1 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, "err.argument", body);
            String w = SubrUtils.getString(d1, mesg);
            int z = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
            String s = SubrUtils.nextString((Iterator<Datum>)itr, mesg, body);
            int f = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
            int t = SubrUtils.nextSmallInt((Iterator<Datum>)itr, s.length() + f, mesg);
            int b = SubrUtils.nextSmallInt((Iterator<Datum>)itr, 0, mesg);
            int e = SubrUtils.nextSmallInt((Iterator<Datum>)itr, s.length(), mesg);
            char[] c = w.toCharArray();
            Strings.xcopy(c, z, s, f, t, b, e);
            ((LispString)d1).value = new String(c);
            return Undef.UNDEF;
        }
    }
}

