/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.morilib.lang.number.Double2;
import net.morilib.lang.number.Integer2;
import net.morilib.lang.number.Rational;
import net.morilib.lisp.lite.LispComplex;
import net.morilib.lisp.lite.LispExactReal;
import net.morilib.lisp.lite.LispInexactReal;
import net.morilib.lisp.lite.LispNotSupportedException;
import net.morilib.lisp.lite.LispNumber;
import net.morilib.lisp.lite.LispReal;
import net.morilib.lisp.lite.LispString;
import net.morilib.lisp.lite.LispUtils;

public class LispDouble
extends LispInexactReal
implements Serializable {
    private static final long serialVersionUID = -3604865349391960731L;
    public static final LispDouble ZERO = new LispDouble(0.0);
    public static final LispDouble ONE = new LispDouble(1.0);
    public static final LispDouble POSITIVE_INFINITY = new LispDouble(Double.POSITIVE_INFINITY);
    public static final LispDouble NEGATIVE_INFINITY = new LispDouble(Double.NEGATIVE_INFINITY);
    public static final LispDouble NaN = new LispDouble(Double.NaN);
    double number;

    public LispDouble(double x) {
        this.number = x;
    }

    public static LispExactReal toExact(double val) {
        if (Double.isInfinite(val) || Double.isNaN(val)) {
            throw new LispNotSupportedException("err.notsupported.exactinfinity");
        }
        BigDecimal v = BigDecimal.valueOf(val);
        return LispUtils.bigDecimalToRational(v);
    }

    @Override
    public BigInteger getNumerator() {
        LispExactReal r = LispDouble.toExact(this.number);
        return r.getNumerator();
    }

    @Override
    public BigInteger getDenominator() {
        LispExactReal r = LispDouble.toExact(this.number);
        return r.getDenominator();
    }

    @Override
    public LispNumber add(LispNumber x) {
        if (x instanceof LispReal) {
            return new LispDouble(this.number + x.getRealDouble());
        }
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex(this.add(c.getReal()), c.getImag());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (x instanceof LispReal) {
            return new LispDouble(this.number - x.getRealDouble());
        }
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex(this.subtract(c.getReal()), c.getImag().uminus());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (x instanceof LispReal) {
            return new LispDouble(this.number * x.getRealDouble());
        }
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex(this.multiply(c.getReal()), this.multiply(c.getImag()));
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (x instanceof LispReal) {
            return new LispDouble(this.number / x.getRealDouble());
        }
        if (x instanceof LispComplex) {
            LispReal xr = x.getReal();
            LispReal xi = x.getImag();
            LispReal xn = xr.multiply(xr).add(xi.multiply(xi));
            return LispComplex.newComplex(this.multiply(xr).divide(xn), this.multiply(xi).uminus().divide(xn));
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispDouble uminus() {
        return new LispDouble(-this.number);
    }

    @Override
    public boolean isEqualTo(LispNumber x) {
        if (x instanceof LispReal) {
            return this.number == x.getRealDouble();
        }
        return false;
    }

    @Override
    public boolean isLessThan(LispReal x) {
        return this.number < x.getRealDouble();
    }

    @Override
    public boolean isMoreThan(LispReal x) {
        return this.number > x.getRealDouble();
    }

    public BigInteger bigIntegerValue() {
        BigDecimal dec = new BigDecimal(this.number);
        return dec.toBigInteger();
    }

    public double doubleValue() {
        return this.number;
    }

    @Override
    public int signum() {
        return this.number > 0.0 ? 1 : (this.number < 0.0 ? -1 : 0);
    }

    @Override
    public LispExactReal toExact() {
        return LispDouble.toExact(this.number);
    }

    @Override
    public LispReal toInexact() {
        return this;
    }

    @Override
    public String print() {
        return LispDouble.disp(this.number);
    }

    @Override
    public String getResult() {
        return LispDouble.disp(this.number);
    }

    @Override
    public boolean isInteger() {
        return LispUtils.toIntegerExact(this.number) != null;
    }

    @Override
    public boolean isRational() {
        return !Double.isInfinite(this.number) && !Double.isNaN(this.number);
    }

    @Override
    public boolean isReal() {
        return true;
    }

    @Override
    public boolean isExact() {
        return false;
    }

    @Override
    public LispString toLispString(int radix) {
        if (radix < 2 || radix > 36) {
            throw new IndexOutOfBoundsException("radix is out of range");
        }
        if (radix != 10) {
            throw new IllegalArgumentException("radix except 10 is not supported");
        }
        if (Double.isNaN(this.number)) {
            return new LispString("+nan.0");
        }
        if (this.number == Double.POSITIVE_INFINITY) {
            return new LispString("+inf.0");
        }
        if (this.number == Double.NEGATIVE_INFINITY) {
            return new LispString("-inf.0");
        }
        return new LispString(Double.toString(this.number));
    }

    @Override
    public LispString toLispString(int radix, int precision) {
        if (radix < 2 || radix > 36) {
            throw new IndexOutOfBoundsException("radix is out of range");
        }
        if (radix != 10) {
            throw new IllegalArgumentException("radix except 10 is not supported");
        }
        if (precision < 0) {
            throw new IllegalArgumentException("precision must not be negative");
        }
        if (Double.isNaN(this.number)) {
            return new LispString("+nan.0");
        }
        if (this.number == Double.POSITIVE_INFINITY) {
            return new LispString("+inf.0");
        }
        if (this.number == Double.NEGATIVE_INFINITY) {
            return new LispString("-inf.0");
        }
        return new LispString(String.format("%" + precision + "d", this.number));
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.number);
    }

    @Override
    public boolean isOne() {
        return this.number == 1.0;
    }

    @Override
    public BigInteger getBigInteger() {
        return this.getBigDecimal().toBigInteger();
    }

    @Override
    public int getInt() {
        return this.getBigInteger().intValue();
    }

    @Override
    public long getLong() {
        return this.getBigInteger().longValue();
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (Double.isInfinite(this.number) || Double.isNaN(this.number)) {
            throw new NumberFormatException("Infinities or NaNs is not supported");
        }
        return BigDecimal.valueOf(this.number);
    }

    @Override
    public double getRealDouble() {
        return this.number;
    }

    @Override
    public boolean isInfinity() {
        return Double.isInfinite(this.number);
    }

    public LispReal invert() {
        return new LispDouble(1.0 / this.number);
    }

    public boolean isUnit() {
        return this.number == 1.0;
    }

    public LispReal multiply(int n) {
        return new LispDouble(this.number * (double)n);
    }

    public LispReal power(int n) {
        return new LispDouble(Math.pow(this.number, n));
    }

    public int castInt() {
        return (int)this.number;
    }

    public long castLong() {
        return (long)this.number;
    }

    public Integer2 castInteger2() {
        return Double2.valueOf(this.number).castInteger2();
    }

    public int intFloor() {
        return (int)this.longFloor();
    }

    public long longFloor() {
        return (long)Math.floor(this.number);
    }

    public Integer2 getInteger2Floor() {
        Rational r = Rational.valueOf(this.number);
        return r.getInteger2Floor();
    }

    public int intCeil() {
        return (int)this.longCeil();
    }

    public long longCeil() {
        return (long)Math.ceil(this.number);
    }

    public Integer2 getInteger2Ceil() {
        Rational r = Rational.valueOf(this.number);
        return r.getInteger2Ceil();
    }

    public float floatValue() {
        return (float)this.number;
    }

    public Object toObject() {
        return new Double(this.number);
    }

    @Override
    public LispReal floor() {
        return new LispDouble(Math.floor(this.number));
    }

    @Override
    public LispReal ceil() {
        return new LispDouble(Math.ceil(this.number));
    }

    @Override
    public boolean isFinite() {
        return !Double.isInfinite(this.number);
    }

    @Override
    public boolean equals(Object x) {
        if (x instanceof LispDouble) {
            return Double.compare(this.number, ((LispDouble)x).number) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int l = 17;
        long lr = Double.doubleToLongBits(this.number);
        l = 37 * l + (int)(lr ^ lr >>> 32);
        return l;
    }

    @Override
    public String toString() {
        return Double.toString(this.number);
    }

    @Override
    public LispReal angle() {
        return new LispDouble(this.number < 0.0 ? Math.PI : 0.0);
    }
}

