/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.morilib.lisp.lite.ConsIterator;
import net.morilib.lisp.lite.ConsOrNil;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.DatumPredicate;
import net.morilib.lisp.lite.LispUtils;
import net.morilib.lisp.lite.Nil;
import net.morilib.lisp.lite.Procedure;
import net.morilib.lisp.lite.Symbol;
import net.morilib.lisp.lite.Undef;
import net.morilib.lisp.lite.subr.IsEqual;

public final class Cons
extends Datum
implements ConsOrNil,
Serializable {
    private Datum car;
    private Datum cdr;

    public Cons() {
        this.car = Nil.NIL;
        this.cdr = Nil.NIL;
    }

    public Cons(Datum car, Datum cdr) {
        if (car == null) {
            throw new NullPointerException("car is null");
        }
        if (cdr == null) {
            throw new NullPointerException("cdr is null");
        }
        this.car = car;
        this.cdr = cdr;
    }

    @Override
    public Datum getCar() {
        return this.car;
    }

    void setCar(Datum car) {
        this.car = car;
    }

    @Override
    public Datum getCdr() {
        return this.cdr;
    }

    void setCdr(Datum cdr) {
        this.cdr = cdr;
    }

    @Override
    public boolean isTypeList() {
        return true;
    }

    @Override
    public boolean isDottedList() {
        return !this.getDottedDatum().isNil();
    }

    @Override
    public List<Datum> getList() {
        ArrayList<Datum> res = new ArrayList<Datum>();
        Datum p = this.cdr;
        res.add(this.car);
        while (p instanceof Cons) {
            Cons p2 = (Cons)p;
            res.add(p2.car);
            p = p2.cdr;
        }
        return Collections.unmodifiableList(res);
    }

    @Override
    public Datum getDottedDatum() {
        Datum p = this.cdr;
        while (p instanceof Cons) {
            p = ((Cons)p).cdr;
        }
        return p;
    }

    @Override
    public String toString() {
        return LispUtils.getResult(this);
    }

    public Datum copy(DatumPredicate p) {
        Datum q = this;
        Cons r = null;
        Cons r0 = null;
        HashMap<Cons, Datum> h = new HashMap<Cons, Datum>();
        while (q instanceof Cons) {
            Cons c = q;
            if (p.test(c.car)) {
                if (r == null) {
                    r0 = r = new Cons();
                } else {
                    r.cdr = new Cons();
                    r = (Cons)r.cdr;
                }
                r.car = c.car;
            }
            h.put(c, c.cdr);
            if (h.containsKey(c.cdr)) {
                if (r == null) {
                    return Nil.NIL;
                }
                r.cdr = (Datum)h.get(c.cdr);
                return r0;
            }
            q = c.cdr;
        }
        r.cdr = q;
        return r0 == null ? Nil.NIL : r0;
    }

    public Cons copy() {
        Cons r;
        Datum d = this;
        Cons r0 = r = new Cons();
        HashMap<Cons, Datum> h = new HashMap<Cons, Datum>();
        HashMap<Cons, Datum> g = new HashMap<Cons, Datum>();
        while (d instanceof Cons) {
            Cons c = d;
            r.car = c.car;
            if (h.containsKey(c.cdr)) {
                r.cdr = (Datum)g.get(c.cdr);
                return r0;
            }
            h.put(c, c.cdr);
            if (c.cdr instanceof Cons) {
                r.cdr = new Cons();
                g.put(c, r.cdr);
                r = (Cons)r.cdr;
            } else {
                r.cdr = c.cdr;
            }
            d = c.cdr;
        }
        return r0;
    }

    public Datum delete(DatumPredicate p) {
        Datum d = this;
        Cons r = null;
        Cons r0 = null;
        HashMap<Cons, Datum> h = new HashMap<Cons, Datum>();
        while (d instanceof Cons) {
            Cons c = d;
            if (p.test(c.car)) {
                if (r == null) {
                    r0 = c;
                }
                r = c;
                r.car = c.car;
            } else if (r != null) {
                r.cdr = c.cdr;
            }
            h.put(c, c.cdr);
            if (h.containsKey(c.cdr)) {
                if (r == null) {
                    return Nil.NIL;
                }
                r.cdr = (Datum)h.get(c.cdr);
                return r0;
            }
            d = c.cdr;
        }
        return r0 == null ? Nil.NIL : r0;
    }

    private Cons _get(int index) {
        Cons r = this;
        if (index < 0) {
            throw new IndexOutOfBoundsException("" + index);
        }
        int i = 0;
        while (i < index) {
            if (!(r.cdr instanceof Cons)) {
                throw new IndexOutOfBoundsException("" + i);
            }
            r = (Cons)r.cdr;
            ++i;
        }
        return r;
    }

    public Datum get(int index) {
        return this._get((int)index).car;
    }

    public Datum copySet(int index, Datum d) {
        return this.copy().set(index, d);
    }

    public Datum set(int index, Datum d) {
        this._get((int)index).car = d;
        return this;
    }

    public Datum copy(int b, int e) {
        Cons r = new Cons();
        Datum c = this._get(b);
        if (b == e) {
            return Nil.NIL;
        }
        Cons r0 = r;
        int i = b;
        while (i < e) {
            if (c instanceof Cons) {
                r.car = c.car;
                if (i < e - 1 && c.cdr instanceof Cons) {
                    r.cdr = new Cons();
                    r = (Cons)r.cdr;
                }
            } else {
                throw new IndexOutOfBoundsException("" + i);
            }
            c = c.cdr;
            ++i;
        }
        return r0;
    }

    public Procedure equivalence() {
        return new IsEqual();
    }

    public Datum copyAdd(Datum d) {
        Cons r = new Cons();
        r.car = d;
        r.cdr = this.copy();
        return r;
    }

    public Datum add(Datum d) {
        return this.copyAdd(d);
    }

    public Datum copyDelete(Datum d) {
        final Datum x = d;
        final boolean[] b = new boolean[]{false};
        return this.copy(new DatumPredicate(){

            @Override
            public boolean test(Datum d) {
                return b[0] || !(b[0] = LispUtils.equals(x, d));
            }
        });
    }

    public Datum delete(Datum d) {
        final Datum x = d;
        final boolean[] b = new boolean[]{false};
        return this.delete(new DatumPredicate(){

            @Override
            public boolean test(Datum d) {
                return b[0] || !(b[0] = LispUtils.equals(x, d));
            }
        });
    }

    public Datum copyDeleteAll(Datum d) {
        final Datum x = d;
        return this.copy(new DatumPredicate(){

            @Override
            public boolean test(Datum d) {
                return !LispUtils.equals(x, d);
            }
        });
    }

    public Datum deleteAll(Datum d) {
        final Datum x = d;
        return this.delete(new DatumPredicate(){

            @Override
            public boolean test(Datum d) {
                return !LispUtils.equals(x, d);
            }
        });
    }

    public Symbol getCollectionName() {
        return Symbol.getSymbol("list");
    }

    public int size() {
        Datum p = this;
        HashSet<Cons> s = new HashSet<Cons>();
        int r = 0;
        while (p instanceof Cons) {
            if (s.contains(p)) {
                return -1;
            }
            ++r;
            s.add((Cons)p);
            p = p.cdr;
        }
        return r;
    }

    public boolean equivalence(Datum a, Datum b) {
        return LispUtils.equals(a, b);
    }

    public Datum prototype() {
        return Nil.NIL;
    }

    public Datum clear() {
        return Nil.NIL;
    }

    public Datum duplicate() {
        return this.copy();
    }

    public boolean contains(Datum d) {
        Datum p = this;
        while (p instanceof Cons) {
            if (LispUtils.equals(d, p.car)) {
                return true;
            }
            p = p.cdr;
        }
        return false;
    }

    public Iterator<Datum> iterator() {
        return new ConsIterator(this);
    }

    public Datum first() {
        return this.car;
    }

    public Datum last() {
        Cons p = this;
        while (p.cdr instanceof Cons) {
            p = (Cons)p.cdr;
        }
        return p.car;
    }

    public Datum copyInsertFirst(Datum d) {
        return new Cons(d, this.copy());
    }

    public Datum copyInsertLast(Datum d) {
        Cons p;
        Cons q = p = this.copy();
        while (p.cdr instanceof Cons) {
            p = (Cons)p.cdr;
        }
        p.cdr = new Cons(d, p.cdr);
        return q;
    }

    public Datum[] removeFirst() {
        return new Datum[]{this.cdr, this.car};
    }

    public Datum[] removeLast() {
        Cons p = this;
        Cons p0 = null;
        while (p.cdr instanceof Cons) {
            p0 = p0 == null ? this : p;
            p = (Cons)p.cdr;
        }
        if (p0 == null) {
            return new Datum[]{Nil.NIL, p.car};
        }
        p0.cdr = Nil.NIL;
        return new Datum[]{this, p.car};
    }

    public Datum[] copyWithoutFirst() {
        if (this.cdr instanceof Cons) {
            return new Datum[]{((Cons)this.cdr).copy(), this.car};
        }
        return new Datum[]{Nil.NIL, this.car};
    }

    public Datum[] copyWithoutLast() {
        return this.copy().removeLast();
    }

    public Datum copyInsert(int index, Datum d) {
        return this.copy().insert(index, d);
    }

    public Datum insert(int index, Datum d) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("" + index);
        }
        if (index == 0) {
            return new Cons(d, this);
        }
        Datum p = this;
        Cons q = this;
        int i = 0;
        while (i < index) {
            if (!(p instanceof Cons)) {
                throw new IndexOutOfBoundsException("" + i);
            }
            q = p;
            p = p.cdr;
            ++i;
        }
        q.cdr = new Cons(d, p);
        return this;
    }

    public Datum copyDelete(int index) {
        return this.copy().delete(index);
    }

    public Datum delete(int index) {
        Cons p = this;
        Cons q = null;
        if (index < 0) {
            throw new IndexOutOfBoundsException("" + index);
        }
        int i = 0;
        while (i < index) {
            if (!(p.cdr instanceof Cons)) {
                throw new IndexOutOfBoundsException();
            }
            q = p;
            p = (Cons)p.cdr;
            ++i;
        }
        if (q == null) {
            return p.cdr;
        }
        q.cdr = p.cdr;
        return this;
    }

    public Iterator<Map.Entry<Datum, Datum>> entryIterator() {
        final Iterator<Datum> itr = this.iterator();
        return new Iterator<Map.Entry<Datum, Datum>>(){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public Map.Entry<Datum, Datum> next() {
                final Datum d = (Datum)itr.next();
                if (d instanceof Cons) {
                    final Cons c = (Cons)d;
                    return new Map.Entry<Datum, Datum>(){

                        @Override
                        public Datum getKey() {
                            return c.getCar();
                        }

                        @Override
                        public Datum getValue() {
                            return c.getCdr();
                        }

                        @Override
                        public Datum setValue(Datum value) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
                return new Map.Entry<Datum, Datum>(){

                    @Override
                    public Datum getKey() {
                        return d;
                    }

                    @Override
                    public Datum getValue() {
                        return Undef.UNDEF;
                    }

                    @Override
                    public Datum setValue(Datum value) {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public void remove() {
                itr.remove();
            }
        };
    }

    public Procedure keyEquivalence() {
        return new IsEqual();
    }

    public Procedure valueEquivalence() {
        return new IsEqual();
    }

    public boolean containsKey(Datum k) {
        Datum x = this;
        while (x instanceof Cons) {
            Cons c = x;
            if (c.car instanceof Cons ? LispUtils.equals(k, ((Cons)c.car).car) : LispUtils.equals(k, c.car)) {
                return true;
            }
            x = x.cdr;
        }
        return false;
    }

    public Datum get(Datum k) {
        Datum x = this;
        while (x instanceof Cons) {
            Cons c = x;
            if (c.car instanceof Cons) {
                if (LispUtils.equals(k, ((Cons)c.car).car)) {
                    return ((Cons)c.car).cdr;
                }
            } else if (LispUtils.equals(k, c.car)) {
                return Undef.UNDEF;
            }
            x = x.cdr;
        }
        return null;
    }

    public Datum[] copyPut(Datum k, Datum v) {
        return this.copy().put(k, v);
    }

    public Datum[] put(Datum k, Datum v) {
        Datum[] r = new Datum[2];
        Datum x = this;
        while (x instanceof Cons) {
            Cons c = x;
            if (c.car instanceof Cons) {
                if (LispUtils.equals(k, ((Cons)c.car).car)) {
                    r[0] = this;
                    r[1] = ((Cons)c.car).cdr;
                    ((Cons)c.car).cdr = v;
                    return r;
                }
            } else if (LispUtils.equals(k, c.car)) {
                r[0] = this;
                r[1] = Undef.UNDEF;
                c.car = new Cons(k, v);
                return r;
            }
            x = x.cdr;
        }
        r[0] = new Cons(new Cons(k, v), this);
        r[1] = null;
        return r;
    }
}

