/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.number;

import net.morilib.lang.algebra.FieldElement;
import net.morilib.lang.number.AbstractNumerical;
import net.morilib.lang.number.Double2Field;
import net.morilib.lang.number.Integer2;
import net.morilib.lang.number.NumericalField;
import net.morilib.lang.number.NumericalFieldElement;
import net.morilib.lang.number.Rational;

public class Double2
extends AbstractNumerical<Double2>
implements NumericalFieldElement<Double2>,
FieldElement<Double2> {
    public static final Double2 ZERO = new Double2(0.0);
    public static final Double2 ONE = new Double2(1.0);
    public static final Double2 NaN = new Double2(Double.NaN);
    public static final Double2 POSITIVE_INFINITY = new Double2(Double.POSITIVE_INFINITY);
    public static final Double2 NEGATIVE_INFINITY = new Double2(Double.NEGATIVE_INFINITY);
    double value;

    private Double2(double d) {
        this.value = d;
    }

    public static Double2 valueOf(double d) {
        if (d == 0.0) {
            return ZERO;
        }
        if (d == 1.0) {
            return ONE;
        }
        return new Double2(d);
    }

    @Override
    public boolean isUnit() {
        return this.value == 1.0;
    }

    @Override
    public boolean isZero() {
        return this.value == 0.0;
    }

    @Override
    public Double2 negate() {
        return Double2.valueOf(this.value);
    }

    @Override
    public Double2 subtract(Double2 x) {
        return Double2.valueOf(this.value - x.value);
    }

    @Override
    public Double2 add(Double2 x) {
        return Double2.valueOf(this.value + x.value);
    }

    @Override
    public Double2 multiply(int n) {
        return Double2.valueOf(this.value * (double)n);
    }

    @Override
    public Double2 multiply(Double2 x) {
        return Double2.valueOf(this.value * x.value);
    }

    @Override
    public Double2 power(int n) {
        return Double2.valueOf(Math.pow(this.value, n));
    }

    @Override
    public Double2 invert() {
        return Double2.valueOf(1.0 / this.value);
    }

    @Override
    public Double2 divide(Double2 x) {
        return Double2.valueOf(this.value / x.value);
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public int compareTo(Double2 o) {
        return this.value > o.value ? 1 : (this.value < o.value ? -1 : 0);
    }

    @Override
    public int castInt() {
        return (int)this.value;
    }

    @Override
    public long castLong() {
        return (long)this.value;
    }

    @Override
    public Integer2 castInteger2() {
        Rational r = Rational.valueOf(this.value);
        return r.castInteger2();
    }

    @Override
    public int intFloor() {
        return (int)this.longFloor();
    }

    @Override
    public long longFloor() {
        return (long)Math.floor(this.value);
    }

    @Override
    public Integer2 getInteger2Floor() {
        Rational r = Rational.valueOf(this.value);
        return r.getInteger2Floor();
    }

    @Override
    public int intCeil() {
        return (int)this.longCeil();
    }

    @Override
    public long longCeil() {
        return (long)Math.ceil(this.value);
    }

    @Override
    public Integer2 getInteger2Ceil() {
        Rational r = Rational.valueOf(this.value);
        return r.getInteger2Ceil();
    }

    @Override
    public boolean isInteger() {
        Rational r = Rational.valueOf(this.value);
        return r.isInteger();
    }

    @Override
    public NumericalField<Double2> getUniverse() {
        return Double2Field.getInstance();
    }

    @Override
    public Rational getRational() {
        return Rational.valueOf(this.value);
    }
}

