/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util;

import java.util.Comparator;
import java.util.List;

public final class Lists {
    private Lists() {
    }

    public static <T extends Comparable<? super T>> boolean isSorted(List<T> vec) {
        int i = 1;
        while (i < vec.size()) {
            if (((Comparable)vec.get(i - 1)).compareTo(vec.get(i)) > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static <T> boolean isSorted(List<T> vec, Comparator<T> cmp) {
        int i = 1;
        while (i < vec.size()) {
            if (cmp.compare(vec.get(i - 1), vec.get(i)) > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> void merge(List<T> vec, List<T> mvec) {
        int i = 0;
        int j = 0;
        while (j < vec.size()) {
            if (i >= vec.size()) {
                vec.add((Comparable)mvec.get(j++));
                continue;
            }
            int c = ((Comparable)vec.get(i)).compareTo(mvec.get(j));
            if (c < 0) {
                ++i;
                continue;
            }
            if (c == 0) {
                ++i;
                ++j;
                continue;
            }
            vec.add(i, (Comparable)mvec.get(j));
            i += 2;
            ++j;
        }
    }

    public static <T> void merge(List<T> vec, List<T> mvec, Comparator<? super T> cmp) {
        int i = 0;
        int j = 0;
        while (j < mvec.size()) {
            if (i >= vec.size()) {
                vec.add(mvec.get(j++));
                continue;
            }
            int c = cmp.compare(vec.get(i), mvec.get(j));
            if (c < 0) {
                ++i;
                continue;
            }
            if (c == 0) {
                ++i;
                ++j;
                continue;
            }
            vec.add(i, mvec.get(j));
            i += 2;
            ++j;
        }
    }
}

