/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite.exlib;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.Procedure;
import net.morilib.lisp.lite.Symbol;
import net.morilib.lisp.lite.Undef;
import net.morilib.lisp.lite.subr.BinaryArgs;
import net.morilib.lisp.lite.subr.UnaryArgs;

public class DefineReaderCtor
extends BinaryArgs {
    private static Map<Datum, Procedure> ctormap = new ConcurrentHashMap<Datum, Procedure>();

    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        if (!(c1a instanceof Symbol)) {
            throw mesg.getError("err.require.symbol", c2a);
        }
        if (!(c2a instanceof Procedure)) {
            throw mesg.getError("err.require.procedure", c2a);
        }
        ctormap.put(c1a, (Procedure)((Object)c2a));
        return Undef.UNDEF;
    }

    public static class LookupReaderCtor
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            Datum d = (Datum)ctormap.get(c1a);
            if (d == null) {
                throw mesg.getError("err.srfi10.require.undefined", c1a);
            }
            return d;
        }
    }
}

