/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite.condition;

import java.util.List;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispBoolean;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.Procedure;
import net.morilib.lisp.lite.Scheme;
import net.morilib.lisp.lite.condition.LispCondition;
import net.morilib.lisp.lite.condition.LispConditionType;
import net.morilib.lisp.lite.condition.LispSimpleCondition;
import net.morilib.lisp.lite.subr.BinaryArgs;
import net.morilib.lisp.lite.subr.UnaryArgs;

public class ConditionAccessor
extends BinaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        if (!(c1a instanceof LispConditionType)) {
            throw mesg.getError("err.condition.require.conditiontype", c1a);
        }
        if (!(c2a instanceof Procedure)) {
            throw mesg.getError("err.require.procedure", c2a);
        }
        return new Proc((LispConditionType)c1a, (Procedure)((Object)c2a));
    }

    private static class Proc
    extends UnaryArgs {
        private LispConditionType type;
        private Procedure p;

        private Proc(LispConditionType type, Procedure p) {
            super("condition-accessor of " + type.getId());
            this.type = type;
            this.p = p;
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispCondition) {
                List<LispSimpleCondition> l = ((LispCondition)((Object)c1a)).getConditions();
                for (LispSimpleCondition c : l) {
                    if (!c.hasType(this.type)) continue;
                    return Scheme.callva(this.p, env, mesg, c);
                }
                return LispBoolean.FALSE;
            }
            throw mesg.getError("err.condition.require.condition", c1a);
        }
    }
}

