/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import java.util.ArrayList;
import java.util.List;
import net.morilib.lisp.lite.ClosureClass;
import net.morilib.lisp.lite.CodeExecutor;
import net.morilib.lisp.lite.CompiledCode;
import net.morilib.lisp.lite.Cons;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.IntStack;
import net.morilib.lisp.lite.LispCompiler;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.MacroDefinition;
import net.morilib.lisp.lite.Symbol;
import net.morilib.lisp.lite.SymbolName;
import net.morilib.lisp.lite.Syntax;
import net.morilib.lisp.lite.SyntaxUtils;
import net.morilib.lisp.lite.Undef;

public class SynDefineMacroQuote
extends Syntax
implements MacroDefinition {
    private void defun(Datum bcar, Datum bcdr, Environment env, LispCompiler comp, CompiledCode.Builder build, Cons callsym, LispMessage mesg, List<Cons> symlist, boolean toplevel, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
        CompiledCode.Builder nbuild = new CompiledCode.Builder();
        Cons c = (Cons)bcar;
        Environment nenv = new Environment(env);
        SyntaxUtils.compileList(bcdr, nenv, comp, nbuild, c, true, mesg, new ArrayList<Cons>(), exec, memento, syncased);
        nbuild.addReturnOp();
        ClosureClass cl = new ClosureClass(c.getCdr(), nbuild.getCodeRef());
        build.addPush(cl);
        build.addBindMacroQuote(c.getCar());
        build.addPush(Undef.UNDEF);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void compile(Datum body0, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
        if (!toplevel) {
            throw mesg.getError("err.nottoplevel");
        }
        if (!(body0 instanceof Cons)) throw mesg.getError("err.definemacro.malform");
        Datum body = comp.expandMacro(body0, env, exec, memento);
        Datum bcar = ((Cons)body).getCar();
        Datum bcdr = ((Cons)body).getCdr();
        if (bcar instanceof Cons) {
            if (!(((Cons)bcar).getCar() instanceof Symbol)) {
                throw mesg.getError("err.definemacro.malform");
            }
            this.defun(bcar, bcdr, env, comp, build, callsym, mesg, symlist, toplevel, exec, memento, syncased);
            return;
        } else {
            if (!(bcar instanceof SymbolName)) throw mesg.getError("err.definemacro.malform");
            SyntaxUtils.compileBindMacroQuote(bcar, bcdr, env, comp, build, callsym, mesg, "err.definemacro.malform", new ArrayList<Cons>(), exec, memento, syncased);
        }
    }

    @Override
    Datum replaceLocalVals(Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, boolean toplv, int ttype) {
        throw mesg.getError("err.definemacro.definesyntax");
    }
}

