/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispFiles;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispString;
import net.morilib.lisp.lite.LispUtils;
import net.morilib.lisp.lite.OutputPort;
import net.morilib.lisp.lite.Subr;

public class SubrOpenOutputFile
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> l = LispUtils.consToList(body, mesg);
        if (l.size() == 1) {
            Datum c1a = l.get(0);
            if (c1a instanceof LispString) {
                String fn = ((LispString)c1a).getString();
                try {
                    return new OutputPort(LispFiles.getFile(env, fn), mesg);
                }
                catch (IOException e) {
                    throw mesg.getError("err.io", e.getMessage());
                }
            }
            throw mesg.getError("err.require.string", c1a);
        }
        if (l.size() == 2) {
            Datum c1a = l.get(0);
            Datum c2a = l.get(1);
            if (!(c1a instanceof LispString)) {
                throw mesg.getError("err.require.string", c1a);
            }
            if (!(c2a instanceof LispString)) {
                throw mesg.getError("err.require.string", c2a);
            }
            String fn = ((LispString)c1a).getString();
            String enc = c2a.getString();
            try {
                return new OutputPort(LispFiles.getFile(env, fn), enc, mesg);
            }
            catch (UnsupportedEncodingException e) {
                throw mesg.getError("err.unsupportedencoding", enc);
            }
            catch (IOException e) {
                throw mesg.getError("err.io", e.getMessage());
            }
        }
        return null;
    }
}

