/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.LispException;
import net.morilib.lisp.lite.PatternDepthException;
import net.morilib.lisp.lite.PatternDepthIndex;
import net.morilib.lisp.lite.Symbol;

class PatternDepthMap {
    private Map<Symbol, Integer> depthMap = new HashMap<Symbol, Integer>();
    private Map<Symbol, Map<PatternDepthIndex, Datum>> map = new HashMap<Symbol, Map<PatternDepthIndex, Datum>>();
    private Map<Symbol, Map<PatternDepthIndex, Integer>> repeats = new HashMap<Symbol, Map<PatternDepthIndex, Integer>>();
    private Set<Symbol> paramSet;

    PatternDepthMap(Set<Symbol> paramSet) {
        this.paramSet = paramSet;
    }

    PatternDepthMap() {
        this(new HashSet<Symbol>());
    }

    void put(Symbol sym, PatternDepthIndex index, Datum d) {
        Integer dp = this.depthMap.get(sym);
        Map<PatternDepthIndex, Datum> dm = this.map.get(sym);
        if (dp == null) {
            this.depthMap.put(sym, index.depth());
        } else if (dp.intValue() != index.depth()) {
            throw new LispException("not the same depth");
        }
        if (dm == null) {
            dm = new HashMap<PatternDepthIndex, Datum>();
            this.map.put(sym, dm);
        }
        dm.put(index, d);
    }

    Datum get(Symbol sym, PatternDepthIndex index) throws PatternDepthException {
        Integer dp = this.depthMap.get(sym);
        Map<PatternDepthIndex, Datum> dm = this.map.get(sym);
        if (dp == null) {
            return null;
        }
        if (dp.intValue() != index.depth()) {
            throw new PatternDepthException(sym.getName());
        }
        if (dm == null) {
            return null;
        }
        return dm.get(index);
    }

    boolean contains(Symbol sym) {
        return this.paramSet.contains(sym);
    }

    boolean hasElement(Symbol sym) {
        return this.depthMap.containsKey(sym);
    }

    void setRepetaion(Set<Symbol> col, PatternDepthIndex index, int rep) {
        for (Symbol i : col) {
            Map<PatternDepthIndex, Integer> map = this.repeats.get(i);
            if (map == null) {
                map = new HashMap<PatternDepthIndex, Integer>();
                this.repeats.put(i, map);
            }
            map.put(index, rep);
        }
    }

    int getRepetaion(Set<Symbol> col, PatternDepthIndex index) {
        int res = Integer.MAX_VALUE;
        for (Symbol i : col) {
            Integer r;
            Map<PatternDepthIndex, Integer> map = this.repeats.get(i);
            if (map == null || (r = map.get(index)) == null) continue;
            int n = res = r < res ? r : res;
        }
        return res == Integer.MAX_VALUE ? 0 : res;
    }

    public String toString() {
        return String.valueOf(this.depthMap.toString()) + "\n" + this.map.toString();
    }
}

