/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite;

import net.morilib.lang.number.Rational;
import net.morilib.lisp.lite.LispComplex;
import net.morilib.lisp.lite.LispDouble;
import net.morilib.lisp.lite.LispInteger;
import net.morilib.lisp.lite.LispIrrational;
import net.morilib.lisp.lite.LispNumber;
import net.morilib.lisp.lite.LispReal;
import net.morilib.lisp.lite.LispSmallInt;
import net.morilib.lisp.lite.LispString;

public abstract class LispExactReal
extends LispReal {
    public abstract Rational toRational();

    @Override
    public abstract LispExactReal uminus();

    @Override
    public LispExactReal toExact() {
        return this;
    }

    @Override
    public boolean isNaN() {
        return false;
    }

    @Override
    public boolean isInfinity() {
        return false;
    }

    public LispReal multiply(int n) {
        return this.multiply(new LispSmallInt(n));
    }

    @Override
    public boolean isExact() {
        return true;
    }

    public LispReal power(int n) {
        if (n < 0) {
            return this.power(-n).inv().getReal();
        }
        if (n == 0) {
            return LispInteger.ONE;
        }
        if (n == 1) {
            return this;
        }
        LispReal r = this;
        int i = 1;
        while (i < n) {
            r = r.multiply(this);
            ++i;
        }
        return r;
    }

    @Override
    public LispNumber add(LispNumber x) {
        if (x instanceof LispDouble) {
            return new LispDouble(this.getRealDouble() + x.getRealDouble());
        }
        if (x instanceof LispIrrational) {
            return new LispDouble(this.getRealDouble() + x.getRealDouble());
        }
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex(this.add(c.getReal()), c.getImag());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (x instanceof LispDouble) {
            return new LispDouble(this.getRealDouble() - x.getRealDouble());
        }
        if (x instanceof LispIrrational) {
            return new LispDouble(this.getRealDouble() - x.getRealDouble());
        }
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex(this.subtract(c.getReal()), c.getImag().uminus());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (x instanceof LispDouble) {
            return new LispDouble(this.getRealDouble() * x.getRealDouble());
        }
        if (x instanceof LispIrrational) {
            return new LispDouble(this.getRealDouble() * x.getRealDouble());
        }
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex(this.multiply(c.getReal()), this.multiply(c.getImag()));
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (x instanceof LispDouble) {
            return new LispDouble(this.getRealDouble() / x.getRealDouble());
        }
        if (x instanceof LispIrrational) {
            return new LispDouble(this.getRealDouble() / x.getRealDouble());
        }
        if (x instanceof LispComplex) {
            LispReal xr = x.getReal();
            LispReal xi = x.getImag();
            LispReal xn = xr.multiply(xr).add(xi.multiply(xi));
            return LispComplex.newComplex(this.multiply(xr).divide(xn), this.multiply(xi).uminus().divide(xn));
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispReal remainder(LispReal r) {
        if (!r.isExact()) {
            double x = Math.IEEEremainder(this.getRealDouble(), r.getRealDouble());
            return new LispDouble(x);
        }
        if (r.signum() > 0) {
            LispReal b = r;
            while (this.compareTo(r) > 0) {
                b = b.subtract(r);
            }
            return b;
        }
        LispReal b = r;
        while (this.compareTo(r) < 0) {
            b = b.add(r);
        }
        return b;
    }

    @Override
    public LispString toLispString(int radix, int precision) {
        return this.toLispString(radix);
    }
}

